/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.test.olap;

import com.tonbeller.jpivot.core.ModelSupport;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.Property;
import com.tonbeller.jpivot.olap.model.Result;
import com.tonbeller.jpivot.olap.model.impl.CellImpl;
import com.tonbeller.jpivot.olap.model.impl.PropertyImpl;
import com.tonbeller.jpivot.olap.model.impl.ResultImpl;
import com.tonbeller.jpivot.olap.navi.DrillExpandMember;
import com.tonbeller.jpivot.test.olap.DimensionBuilder;
import com.tonbeller.jpivot.test.olap.PropertyBuilder;
import com.tonbeller.jpivot.test.olap.TestAxis;
import com.tonbeller.jpivot.test.olap.TestDimension;
import com.tonbeller.jpivot.test.olap.TestHierarchy;
import com.tonbeller.jpivot.test.olap.TestMember;
import com.tonbeller.jpivot.test.olap.TestOlapModelUtils;
import com.tonbeller.jpivot.test.olap.TestPosition;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class TestOlapModel
extends ModelSupport
implements OlapModel {
    TestAxis[] axes;
    TestAxis slicer;
    TestDimension[] dimensions;
    TestDimension measures;
    private static Logger logger = Logger.getLogger(TestOlapModel.class);
    Random random = new Random();
    private String ID = null;
    boolean showTableBelowCube;
    boolean cubeToBrowser;
    boolean changeMode;

    public String getID() {
        return this.ID;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public TestOlapModel() {
        this.reset();
    }

    void reset() {
        DimensionBuilder db = new DimensionBuilder();
        this.measures = db.build("Measures", new String[]{"Measures"}, new int[]{3});
        this.measures.setMeasure(true);
        TestDimension region = db.build("Region", new String[]{"All Region", "Region", "City", "Customer"}, new int[]{1, 5, 8, 200});
        TestDimension time = db.build("Time", new String[]{"Year", "Month"}, new int[]{5, 12});
        time.setTime(true);
        TestDimension products = db.build("Products", new String[]{"All Products", "Category", "Product"}, new int[]{1, 3, 10});
        TestDimension advertising = db.build("Advertising", new String[]{"All Advertising", "Media", "Target", "Type"}, new int[]{1, 4, 3, 3});
        TestDimension material = db.build("Material", new String[]{"All Materials", "Category", "Brand", "Quality"}, new int[]{1, 4, 3, 3});
        this.dimensions = new TestDimension[6];
        this.dimensions[0] = this.measures;
        this.dimensions[1] = region;
        this.dimensions[2] = time;
        this.dimensions[3] = products;
        this.dimensions[4] = advertising;
        this.dimensions[5] = material;
        PropertyBuilder pb = new PropertyBuilder();
        pb.build(products);
        pb.build(region);
        this.axes = new TestAxis[2];
        this.axes[0] = TestOlapModelUtils.createAxis(new TestDimension[]{this.measures});
        this.axes[1] = TestOlapModelUtils.createAxis(new TestDimension[]{products, time});
        TestMember m = ((TestHierarchy)advertising.getHierarchies()[0]).getRootMembers()[0];
        m = (TestMember)m.getChildMember().get(0);
        this.setSlicer(m);
    }

    public void setAxis(int index, TestAxis axis) {
        this.axes[index] = axis;
    }

    public TestAxis getAxis(int index) {
        return this.axes[index];
    }

    public TestAxis[] getAxes() {
        return this.axes;
    }

    public void setAxes(TestAxis[] axes) {
        this.axes = axes;
    }

    public int indexOf(Axis axis) {
        for (int i = 0; i < this.axes.length; ++i) {
            if (!this.axes[i].equals(axis)) continue;
            return i;
        }
        return -1;
    }

    public void setSlicer(TestMember m) {
        this.slicer = new TestAxis();
        TestPosition p = new TestPosition(this.slicer);
        p.setMembers(new TestMember[]{m});
        ArrayList<TestPosition> list = new ArrayList<TestPosition>();
        list.add(p);
        this.slicer.setPositions(list);
    }

    public Result getResult() throws OlapException {
        this.random.setSeed(123427L);
        int cellCount = 1;
        for (int i = 0; i < this.axes.length; ++i) {
            cellCount *= this.axes[i].getPositions().size();
        }
        Locale locale = super.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DecimalFormat fmt = (DecimalFormat)DecimalFormat.getInstance(locale);
        fmt.applyPattern("#,##0.00");
        ArrayList<CellImpl> cells = new ArrayList<CellImpl>();
        for (int i = 0; i < cellCount; ++i) {
            CellImpl c = new CellImpl();
            double value = this.random.nextGaussian() * 100.0 + 1000.0;
            c.setValue(new Double(value));
            c.setFormattedValue(fmt.format(value));
            TestOlapModel.addProperties(c, i);
            cells.add(c);
        }
        ResultImpl res = new ResultImpl();
        res.setAxes(this.axes);
        res.setCells(cells);
        res.setSlicer(this.slicer);
        return res;
    }

    public Dimension[] getDimensions() {
        return this.dimensions;
    }

    public Member[] getMeasures() {
        TestHierarchy hier = (TestHierarchy)this.measures.getHierarchies()[0];
        return hier.getRootMembers();
    }

    public Dimension getDimension(String name) {
        for (int i = 0; i < this.dimensions.length; ++i) {
            if (!name.equals(this.dimensions[i].getLabel())) continue;
            return this.dimensions[i];
        }
        return null;
    }

    public List findPositions(Member m) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.axes.length; ++i) {
            list.addAll(TestOlapModelUtils.findPositions(this.axes[i], m));
        }
        return list;
    }

    public static void addProperties(CellImpl c, int i) {
        Property[] props = new Property[1];
        PropertyImpl p = new PropertyImpl();
        props[0] = p;
        switch (i / 2 % 10) {
            case 0: {
                p.setName("arrow");
                p.setValue("up");
                break;
            }
            case 1: {
                p.setName("arrow");
                p.setValue("down");
                break;
            }
            case 2: {
                p.setName("arrow");
                p.setValue("none");
                break;
            }
            case 4: {
                p.setName("style");
                p.setValue("red");
                break;
            }
            case 5: {
                p.setName("style");
                p.setValue("yellow");
                break;
            }
            case 6: {
                p.setName("style");
                p.setValue("green");
                break;
            }
        }
        p.setLabel(p.getName());
        c.setProperties(props);
    }

    public void expand0() {
        this.expandRow(0);
    }

    public void expandRow(int positionIndex) {
        TestPosition p = (TestPosition)this.axes[1].getPositions().get(positionIndex);
        Member m = p.getMembers()[0];
        DrillExpandMember de = (DrillExpandMember)this.getExtension("drillExpandMember");
        de.expand(m);
    }

    public void collapse0() {
        this.collapseRow(0);
    }

    public void collapseRow(int positionIndex) {
        TestPosition p = (TestPosition)this.axes[1].getPositions().get(positionIndex);
        Member m = p.getMembers()[0];
        DrillExpandMember de = (DrillExpandMember)this.getExtension("drillExpandMember");
        de.collapse(m);
    }

    public TestAxis getSlicer() {
        return this.slicer;
    }

    public void setSlicer(TestAxis slicer) {
        this.slicer = slicer;
    }

    public Object getRootDecoree() {
        return this;
    }

    public void initialize() {
        logger.debug((Object)"init");
    }

    public void destroy() {
        logger.debug((Object)"destroy");
        super.destroy();
    }

    public TestDimension getMeasuresDim() {
        return this.measures;
    }

    public void setServletContext(ServletContext servletContext) {
    }

    public boolean isShowTableBelowCube() {
        return this.showTableBelowCube;
    }

    public void setShowTableBelowCube(boolean b) {
        this.showTableBelowCube = b;
    }

    public boolean isCubeToBrowser() {
        return this.cubeToBrowser;
    }

    public void setCubeToBrowser(boolean b) {
        this.cubeToBrowser = b;
    }

    public boolean isChangeMode() {
        return this.changeMode;
    }

    public void setChangeMode(boolean b) {
        this.changeMode = b;
    }
}

