/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.IOException;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.GenericElementCsvHandler;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.Grid;
import net.sf.jasperreports.engine.export.GridRow;
import net.sf.jasperreports.engine.export.JRAbstractCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterContext;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRCsvExporter
extends JRAbstractCsvExporter {
    private static final Log log = LogFactory.getLog(JRCsvExporter.class);
    private static final String CSV_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.csv.";
    public static final String CSV_EXPORTER_KEY = "net.sf.jasperreports.csv";
    protected JRCsvExporterContext exporterContext = new ExporterContext();

    public JRCsvExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRCsvExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    @Override
    protected void exportPage(JRPrintPage page) throws IOException {
        JRGridLayout layout = new JRGridLayout(this.nature, page.getElements(), this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), this.globalOffsetX, this.globalOffsetY, null);
        Grid grid = layout.getGrid();
        CutsInfo xCuts = layout.getXCuts();
        CutsInfo yCuts = layout.getYCuts();
        StringBuffer rowbuffer = null;
        boolean isFirstColumn = true;
        int rowCount = grid.getRowCount();
        for (int y = 0; y < rowCount; ++y) {
            rowbuffer = new StringBuffer();
            if (!yCuts.isCutNotEmpty(y)) continue;
            isFirstColumn = true;
            GridRow row = grid.getRow(y);
            int rowSize = row.size();
            for (int x = 0; x < rowSize; ++x) {
                JRPrintElement element = row.get(x).getElement();
                if (element != null) {
                    String text = null;
                    if (element instanceof JRPrintText) {
                        JRStyledText styledText = this.getStyledText((JRPrintText)element);
                        text = styledText == null ? "" : styledText.getText();
                    } else if (element instanceof JRGenericPrintElement) {
                        JRGenericPrintElement genericPrintElement = (JRGenericPrintElement)element;
                        GenericElementCsvHandler handler = (GenericElementCsvHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(genericPrintElement.getGenericType(), CSV_EXPORTER_KEY);
                        if (handler == null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("No CSV generic element handler for " + genericPrintElement.getGenericType()));
                            }
                        } else {
                            text = handler.getTextValue(this.exporterContext, genericPrintElement);
                        }
                    }
                    if (text == null) continue;
                    if (!isFirstColumn) {
                        rowbuffer.append(this.delimiter);
                    }
                    rowbuffer.append(this.prepareText(text));
                    isFirstColumn = false;
                    continue;
                }
                if (!xCuts.isCutNotEmpty(x)) continue;
                if (!isFirstColumn) {
                    rowbuffer.append(this.delimiter);
                }
                isFirstColumn = false;
            }
            if (rowbuffer.length() <= 0) continue;
            this.writer.write(rowbuffer.toString());
            this.writer.write(this.recordDelimiter);
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRCsvExporterContext {
        protected ExporterContext() {
            super(JRCsvExporter.this);
        }

        @Override
        public String getExportPropertiesPrefix() {
            return JRCsvExporter.CSV_EXPORTER_PROPERTIES_PREFIX;
        }
    }
}

