/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.binary;

final class ArrayCharList {
    private transient char[] elements;
    private int size;

    public ArrayCharList() {
        this(10);
    }

    public ArrayCharList(int initialCapacity) {
        this.elements = new char[initialCapacity];
        this.size = 0;
    }

    public void add(char elem) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = elem;
    }

    public char[] asArray() {
        return this.elements;
    }

    public void clear() {
        this.size = 0;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.elements.length) {
            int newCapacity = Math.max(minCapacity, 2 * this.elements.length + 1);
            this.elements = this.subArray(0, this.size, newCapacity);
        }
    }

    public int size() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int capacity() {
        return this.elements.length;
    }

    private char[] subArray(int from, int length, int capacity) {
        char[] subArray = new char[capacity];
        System.arraycopy(this.elements, from, subArray, 0, length);
        return subArray;
    }

    public char[] toArray() {
        return this.subArray(0, this.size, this.size);
    }

    public String toString() {
        return new String(this.elements, 0, this.size);
    }
}

