/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.xquery;

import java.util.HashSet;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nux.xom.pool.XQueryPool;
import nux.xom.xquery.DefaultResultSequence;
import nux.xom.xquery.XQuery;
import nux.xom.xquery.XQueryException;

public class XQueryUtil {
    private static final Nodes EMPTY = new Nodes();

    private XQueryUtil() {
    }

    public static Nodes xquery(Node contextNode, String query) {
        try {
            return XQueryPool.GLOBAL_POOL.getXQuery(query, null).execute(contextNode).toNodes();
        }
        catch (XQueryException e) {
            throw new RuntimeException(e);
        }
    }

    public static void update(Nodes nodes, XQuery morpher, Map variables) {
        if (nodes == null) {
            throw new IllegalArgumentException("nodes must not be null");
        }
        HashSet<Node> identities = null;
        int i = nodes.size();
        while (--i >= 0) {
            int size;
            Node node = nodes.get(i);
            Nodes results = EMPTY;
            if (morpher != null) {
                try {
                    results = morpher.execute(node, null, variables).toNodes();
                }
                catch (XQueryException e) {
                    throw new RuntimeException(e);
                }
            }
            if ((size = results.size()) == 0) {
                node.detach();
                continue;
            }
            if (size == 1 && node == results.get(0)) continue;
            ParentNode parent = node.getParent();
            StringBuffer atomics = null;
            boolean isInitialized = false;
            int position = 0;
            if (size > 1) {
                if (identities == null) {
                    identities = new HashSet<Node>();
                } else {
                    identities.clear();
                }
            }
            int j = 0;
            while (j < size) {
                Node result = results.get(j);
                if (DefaultResultSequence.isAtomicValue(result)) {
                    String value = result.getValue();
                    if (atomics == null) {
                        atomics = new StringBuffer(value.length());
                    } else {
                        atomics.append(' ');
                    }
                    atomics.append(value);
                } else if (parent != null) {
                    boolean isRoot;
                    if (size > 1 && !identities.add(result)) {
                        result = result.copy();
                    }
                    boolean bl = isRoot = parent instanceof Document && node instanceof Element;
                    if (!isInitialized) {
                        if (!(node instanceof Attribute)) {
                            position = parent.indexOf(node);
                        }
                        if (!isRoot) {
                            node.detach();
                        }
                        isInitialized = true;
                    }
                    if (result instanceof Attribute) {
                        result.detach();
                        ((Element)parent).addAttribute((Attribute)result);
                    } else {
                        if (isRoot && result instanceof Element) {
                            parent.replaceChild(node, result);
                        } else {
                            result.detach();
                            parent.insertChild(result, position);
                        }
                        ++position;
                    }
                }
                ++j;
            }
            if (atomics == null) continue;
            XQueryUtil.setValue(node, atomics.toString());
        }
    }

    private static void setValue(Node node, String value) {
        if (node instanceof Document) {
            Document doc = (Document)node;
            Element root = doc.getRootElement();
            int k = doc.getChildCount();
            while (--k >= 0) {
                if (doc.getChild(k) == root) continue;
                doc.removeChild(k);
            }
            node = root;
        }
        if (node instanceof Element) {
            Element elem = (Element)node;
            elem.removeChildren();
            elem.appendChild(value);
        } else if (node instanceof Attribute) {
            ((Attribute)node).setValue(value);
        } else if (node instanceof Text) {
            ((Text)node).setValue(value);
        } else if (node instanceof Comment) {
            ((Comment)node).setValue(value);
        } else if (node instanceof ProcessingInstruction) {
            ((ProcessingInstruction)node).setValue(value);
        }
    }

    public static void update(Node contextNode, String select, String morpher) {
        if (contextNode == null) {
            throw new IllegalArgumentException("contextNode must not be null");
        }
        if (select == null) {
            throw new IllegalArgumentException("select must not be null");
        }
        XQuery xmorpher = null;
        if (morpher != null && !morpher.trim().equals("()")) {
            try {
                xmorpher = XQueryPool.GLOBAL_POOL.getXQuery(morpher, null);
            }
            catch (XQueryException e) {
                throw new RuntimeException(e);
            }
        }
        Nodes nodes = XQueryUtil.xquery(contextNode, select);
        XQueryUtil.update(nodes, xmorpher, null);
    }

    static boolean getSystemProperty(String key, boolean defaults) {
        try {
            return "true".equalsIgnoreCase(System.getProperty(key, String.valueOf(defaults)));
        }
        catch (Throwable e) {
            return defaults;
        }
    }
}

