/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.memory;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.index.memory.PatternAnalyzer;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;

public class MemoryIndex {
    private final HashMap fields = new HashMap();
    private transient Map.Entry[] sortedFields;
    private final int stride;
    private static final long serialVersionUID = 2782195016849084649L;
    private static final boolean DEBUG = false;
    private static final Comparator termComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Map.Entry) {
                o1 = ((Map.Entry)o1).getKey();
            }
            if (o2 instanceof Map.Entry) {
                o2 = ((Map.Entry)o2).getKey();
            }
            if (o1 == o2) {
                return 0;
            }
            return ((String)o1).compareTo((String)o2);
        }
    };
    private static final Term MATCH_ALL_TERM = new Term("", "");

    public MemoryIndex() {
        this(false);
    }

    private MemoryIndex(boolean storeOffsets) {
        this.stride = storeOffsets ? 3 : 1;
    }

    public void addField(String fieldName, String text, Analyzer analyzer) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        if (analyzer == null) {
            throw new IllegalArgumentException("analyzer must not be null");
        }
        TokenStream stream = analyzer instanceof PatternAnalyzer ? ((PatternAnalyzer)analyzer).tokenStream(fieldName, text) : analyzer.tokenStream(fieldName, (Reader)new PatternAnalyzer.FastStringReader(text));
        this.addField(fieldName, stream);
    }

    public TokenStream keywordTokenStream(Collection keywords) {
        if (keywords == null) {
            throw new IllegalArgumentException("keywords must not be null");
        }
        return new TokenStream(keywords){
            private Iterator iter;
            private int start;
            {
                this.iter = collection.iterator();
                this.start = 0;
            }

            public Token next() {
                if (!this.iter.hasNext()) {
                    return null;
                }
                Object obj = this.iter.next();
                if (obj == null) {
                    throw new IllegalArgumentException("keyword must not be null");
                }
                String term = obj.toString();
                Token token = new Token(term, this.start, this.start + term.length());
                this.start += term.length() + 1;
                return token;
            }
        };
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addField(String fieldName, TokenStream stream) {
        try {
            try {
                if (fieldName == null) {
                    throw new IllegalArgumentException("fieldName must not be null");
                }
                if (stream == null) {
                    throw new IllegalArgumentException("token stream must not be null");
                }
                if (this.fields.get(fieldName) != null) {
                    throw new IllegalArgumentException("field must not be added more than once");
                }
                HashMap<String, ArrayIntList> terms = new HashMap<String, ArrayIntList>();
                int numTokens = 0;
                int pos = -1;
                while (true) {
                    Token token;
                    block15: {
                        if ((token = stream.next()) != null) break block15;
                        if (numTokens > 0) {
                            this.fields.put(fieldName, new Info(terms, numTokens));
                            this.sortedFields = null;
                        }
                        break;
                    }
                    String term = token.termText();
                    if (term.length() == 0) continue;
                    ++numTokens;
                    pos += token.getPositionIncrement();
                    ArrayIntList positions = (ArrayIntList)terms.get(term);
                    if (positions == null) {
                        positions = new ArrayIntList(this.stride);
                        terms.put(term, positions);
                    }
                    if (this.stride == 1) {
                        positions.add(pos);
                        continue;
                    }
                    positions.add(pos, token.startOffset(), token.endOffset());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
        {
            Object var9_12 = null;
        }
        try {}
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        if (stream == null) return;
        stream.close();
    }

    public IndexSearcher createSearcher() {
        MemoryIndexReader reader = new MemoryIndexReader();
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        reader.setSearcher((Searcher)searcher);
        return searcher;
    }

    public float search(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("query must not be null");
        }
        IndexSearcher searcher = this.createSearcher();
        try {
            final float[] scores = new float[1];
            searcher.search(query, new HitCollector(){

                public void collect(int doc, float score) {
                    scores[0] = score;
                }
            });
            float score = scores[0];
            return score;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getMemorySize() {
        int HEADER = 12;
        int PTR = 4;
        int ARR = HEADER + 4;
        int STR = HEADER + 12 + PTR + ARR;
        int INTARRLIST = HEADER + 4 + PTR + ARR;
        int HASHMAP = HEADER + 4 * PTR + 16 + ARR;
        int size = 0;
        size += HEADER + 2 * PTR + 4;
        if (this.sortedFields != null) {
            size += ARR + PTR * this.sortedFields.length;
        }
        size += HASHMAP + this.fields.size() * (PTR + HEADER + 3 * PTR + 4);
        Iterator iter = this.fields.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Info info = (Info)entry.getValue();
            size += HEADER + 4 + PTR + PTR + PTR;
            if (info.sortedTerms != null) {
                size += ARR + PTR * info.sortedTerms.length;
            }
            int len = info.terms.size();
            size += HASHMAP + len * (PTR + HEADER + 3 * PTR + 4);
            Iterator iter2 = info.terms.entrySet().iterator();
            while (--len >= 0) {
                Map.Entry e = iter2.next();
                size += STR - ARR;
                ArrayIntList positions = (ArrayIntList)e.getValue();
                size += INTARRLIST + 4 * positions.size();
            }
        }
        return size;
    }

    private int numPositions(ArrayIntList positions) {
        return positions.size() / this.stride;
    }

    private void sortFields() {
        if (this.sortedFields == null) {
            this.sortedFields = MemoryIndex.sort(this.fields);
        }
    }

    private static Map.Entry[] sort(HashMap map) {
        int size = map.size();
        Map.Entry[] entries = new Map.Entry[size];
        Iterator iter = map.entrySet().iterator();
        int i = 0;
        while (i < size) {
            entries[i] = iter.next();
            ++i;
        }
        if (size > 1) {
            Arrays.sort(entries, termComparator);
        }
        return entries;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(256);
        this.sortFields();
        int sumChars = 0;
        int sumPositions = 0;
        int sumTerms = 0;
        int i = 0;
        while (i < this.sortedFields.length) {
            Map.Entry entry = this.sortedFields[i];
            String fieldName = (String)entry.getKey();
            Info info = (Info)entry.getValue();
            info.sortTerms();
            result.append(String.valueOf(fieldName) + ":\n");
            int numChars = 0;
            int numPositions = 0;
            int j = 0;
            while (j < info.sortedTerms.length) {
                Map.Entry e = info.sortedTerms[j];
                String term = (String)e.getKey();
                ArrayIntList positions = (ArrayIntList)e.getValue();
                result.append("\t'" + term + "':" + this.numPositions(positions) + ":");
                result.append(positions.toString(this.stride));
                result.append("\n");
                numPositions += this.numPositions(positions);
                numChars += term.length();
                ++j;
            }
            result.append("\tterms=" + info.sortedTerms.length);
            result.append(", positions=" + numPositions);
            result.append(", Kchars=" + (float)numChars / 1000.0f);
            result.append("\n");
            sumPositions += numPositions;
            sumChars += numChars;
            sumTerms += info.sortedTerms.length;
            ++i;
        }
        result.append("\nfields=" + this.sortedFields.length);
        result.append(", terms=" + sumTerms);
        result.append(", positions=" + sumPositions);
        result.append(", Kchars=" + (float)sumChars / 1000.0f);
        return result.toString();
    }

    static /* synthetic */ int access$6(MemoryIndex memoryIndex, ArrayIntList arrayIntList) {
        return memoryIndex.numPositions(arrayIntList);
    }

    private static final class Info
    implements Serializable {
        private final HashMap terms;
        private transient Map.Entry[] sortedTerms;
        private final int numTokens;
        public transient Term template;
        private static final long serialVersionUID = 2882195016849084649L;

        public Info(HashMap terms, int numTokens) {
            this.terms = terms;
            this.numTokens = numTokens;
        }

        public void sortTerms() {
            if (this.sortedTerms == null) {
                this.sortedTerms = MemoryIndex.sort(this.terms);
            }
        }

        public ArrayIntList getPositions(String term) {
            return (ArrayIntList)this.terms.get(term);
        }

        public ArrayIntList getPositions(int pos) {
            return (ArrayIntList)this.sortedTerms[pos].getValue();
        }
    }

    private static final class ArrayIntList
    implements Serializable {
        private int[] elements;
        private int size = 0;
        private static final long serialVersionUID = 2282195016849084649L;

        public ArrayIntList() {
            this(10);
        }

        public ArrayIntList(int initialCapacity) {
            this.elements = new int[initialCapacity];
        }

        public void add(int elem) {
            if (this.size == this.elements.length) {
                this.ensureCapacity(this.size + 1);
            }
            this.elements[this.size++] = elem;
        }

        public void add(int pos, int start, int end) {
            if (this.size + 3 > this.elements.length) {
                this.ensureCapacity(this.size + 3);
            }
            this.elements[this.size] = pos;
            this.elements[this.size + 1] = start;
            this.elements[this.size + 2] = end;
            this.size += 3;
        }

        public int get(int index) {
            if (index >= this.size) {
                this.throwIndex(index);
            }
            return this.elements[index];
        }

        public int size() {
            return this.size;
        }

        public int[] toArray(int stride) {
            int[] arr = new int[this.size() / stride];
            if (stride == 1) {
                System.arraycopy(this.elements, 0, arr, 0, this.size);
            } else {
                int i = 0;
                int j = 0;
                while (j < this.size) {
                    arr[i] = this.elements[j];
                    ++i;
                    j += stride;
                }
            }
            return arr;
        }

        private void ensureCapacity(int minCapacity) {
            int newCapacity = Math.max(minCapacity, this.elements.length * 3 / 2 + 1);
            int[] newElements = new int[newCapacity];
            System.arraycopy(this.elements, 0, newElements, 0, this.size);
            this.elements = newElements;
        }

        private void throwIndex(int index) {
            throw new IndexOutOfBoundsException("index: " + index + ", size: " + this.size);
        }

        public String toString(int stride) {
            int s = this.size() / stride;
            int len = Math.min(10, s);
            StringBuffer buf = new StringBuffer(4 * len);
            buf.append("[");
            int i = 0;
            while (i < len) {
                buf.append(this.get(i * stride));
                if (i < len - 1) {
                    buf.append(", ");
                }
                ++i;
            }
            if (len != s) {
                buf.append(", ...");
            }
            buf.append("]");
            return buf.toString();
        }
    }

    private final class MemoryIndexReader
    extends IndexReader {
        private Searcher searcher;
        private byte[] cachedNorms;
        private String cachedFieldName;
        private Similarity cachedSimilarity;

        private MemoryIndexReader() {
            super(null);
        }

        protected void finalize() {
        }

        private Info getInfo(String fieldName) {
            return (Info)MemoryIndex.this.fields.get(fieldName);
        }

        private Info getInfo(int pos) {
            return (Info)MemoryIndex.this.sortedFields[pos].getValue();
        }

        public int docFreq(Term term) {
            Info info = this.getInfo(term.field());
            int freq = 0;
            if (info != null) {
                freq = info.getPositions(term.text()) != null ? 1 : 0;
            }
            return freq;
        }

        public TermEnum terms() {
            return this.terms(MATCH_ALL_TERM);
        }

        public TermEnum terms(Term term) {
            int i;
            MemoryIndex.this.sortFields();
            int j = MemoryIndex.this.sortedFields.length == 1 && MemoryIndex.this.sortedFields[0].getKey() == term.field() ? 0 : Arrays.binarySearch(MemoryIndex.this.sortedFields, term.field(), termComparator);
            if (j < 0) {
                j = -j - 1;
                i = 0;
                if (j < MemoryIndex.this.sortedFields.length) {
                    this.getInfo(j).sortTerms();
                }
            } else {
                Info info = this.getInfo(j);
                info.sortTerms();
                i = Arrays.binarySearch(info.sortedTerms, term.text(), termComparator);
                if (i < 0 && (i = -i - 1) >= info.sortedTerms.length) {
                    i = 0;
                    if (++j < MemoryIndex.this.sortedFields.length) {
                        this.getInfo(j).sortTerms();
                    }
                }
            }
            int ix = i;
            int jx = j;
            return new TermEnum(this, ix, jx){
                private int i;
                private int j;
                final /* synthetic */ MemoryIndexReader this$1;
                {
                    this.this$1 = memoryIndexReader;
                    this.i = n;
                    this.j = n2;
                }

                public boolean next() {
                    if (this.j >= MemoryIndex.access$2(MemoryIndexReader.access$4(this.this$1)).length) {
                        return false;
                    }
                    Info info = MemoryIndexReader.access$0(this.this$1, this.j);
                    if (++this.i < Info.access$0(info).length) {
                        return true;
                    }
                    ++this.j;
                    this.i = 0;
                    if (this.j >= MemoryIndex.access$2(MemoryIndexReader.access$4(this.this$1)).length) {
                        return false;
                    }
                    MemoryIndexReader.access$0(this.this$1, this.j).sortTerms();
                    return true;
                }

                public Term term() {
                    if (this.j >= MemoryIndex.access$2(MemoryIndexReader.access$4(this.this$1)).length) {
                        return null;
                    }
                    Info info = MemoryIndexReader.access$0(this.this$1, this.j);
                    if (this.i >= Info.access$0(info).length) {
                        return null;
                    }
                    return this.createTerm(info, this.j, (String)Info.access$0(info)[this.i].getKey());
                }

                public int docFreq() {
                    if (this.j >= MemoryIndex.access$2(MemoryIndexReader.access$4(this.this$1)).length) {
                        return 0;
                    }
                    Info info = MemoryIndexReader.access$0(this.this$1, this.j);
                    if (this.i >= Info.access$0(info).length) {
                        return 0;
                    }
                    return MemoryIndex.access$6(MemoryIndexReader.access$4(this.this$1), info.getPositions(this.i));
                }

                public void close() {
                }

                private Term createTerm(Info info, int pos, String text) {
                    Term template = info.template;
                    if (template == null) {
                        String fieldName = (String)MemoryIndex.access$2(MemoryIndexReader.access$4(this.this$1))[pos].getKey();
                        info.template = template = new Term(fieldName, "");
                    }
                    return template.createTerm(text);
                }
            };
        }

        public TermPositions termPositions() {
            return new TermPositions(this){
                private boolean hasNext;
                private int cursor;
                private ArrayIntList current;
                final /* synthetic */ MemoryIndexReader this$1;
                {
                    this.this$1 = memoryIndexReader;
                    this.cursor = 0;
                }

                public void seek(Term term) {
                    Info info = MemoryIndexReader.access$1(this.this$1, term.field());
                    this.current = info == null ? null : info.getPositions(term.text());
                    this.hasNext = this.current != null;
                    this.cursor = 0;
                }

                public void seek(TermEnum termEnum) {
                    this.seek(termEnum.term());
                }

                public int doc() {
                    return 0;
                }

                public int freq() {
                    int freq = this.current != null ? MemoryIndex.access$6(MemoryIndexReader.access$4(this.this$1), this.current) : 0;
                    return freq;
                }

                public boolean next() {
                    boolean next = this.hasNext;
                    this.hasNext = false;
                    return next;
                }

                public int read(int[] docs, int[] freqs) {
                    if (!this.hasNext) {
                        return 0;
                    }
                    this.hasNext = false;
                    docs[0] = 0;
                    freqs[0] = this.freq();
                    return 1;
                }

                public boolean skipTo(int target) {
                    return this.next();
                }

                public void close() {
                }

                public int nextPosition() {
                    int pos = this.current.get(this.cursor);
                    this.cursor += MemoryIndex.access$7(MemoryIndexReader.access$4(this.this$1));
                    return pos;
                }
            };
        }

        public TermDocs termDocs() {
            return this.termPositions();
        }

        public TermFreqVector[] getTermFreqVectors(int docNumber) {
            TermFreqVector[] vectors = new TermFreqVector[MemoryIndex.this.fields.size()];
            Iterator iter = MemoryIndex.this.fields.keySet().iterator();
            int i = 0;
            while (i < vectors.length) {
                String fieldName = (String)iter.next();
                vectors[i] = this.getTermFreqVector(docNumber, fieldName);
                ++i;
            }
            return vectors;
        }

        public TermFreqVector getTermFreqVector(int docNumber, String fieldName) {
            Info info = this.getInfo(fieldName);
            if (info == null) {
                return null;
            }
            info.sortTerms();
            return new TermPositionVector(this, info, fieldName){
                private final Map.Entry[] sortedTerms;
                final /* synthetic */ MemoryIndexReader this$1;
                private final /* synthetic */ String val$fieldName;
                {
                    this.this$1 = memoryIndexReader;
                    this.val$fieldName = string;
                    this.sortedTerms = Info.access$0(info);
                }

                public String getField() {
                    return this.val$fieldName;
                }

                public int size() {
                    return this.sortedTerms.length;
                }

                public String[] getTerms() {
                    String[] terms = new String[this.sortedTerms.length];
                    int i = this.sortedTerms.length;
                    while (--i >= 0) {
                        terms[i] = (String)this.sortedTerms[i].getKey();
                    }
                    return terms;
                }

                public int[] getTermFrequencies() {
                    int[] freqs = new int[this.sortedTerms.length];
                    int i = this.sortedTerms.length;
                    while (--i >= 0) {
                        freqs[i] = MemoryIndex.access$6(MemoryIndexReader.access$4(this.this$1), (ArrayIntList)this.sortedTerms[i].getValue());
                    }
                    return freqs;
                }

                public int indexOf(String term) {
                    int i = Arrays.binarySearch(this.sortedTerms, term, MemoryIndex.access$5());
                    return i >= 0 ? i : -1;
                }

                public int[] indexesOf(String[] terms, int start, int len) {
                    int[] indexes = new int[len];
                    int i = 0;
                    while (i < len) {
                        indexes[i] = this.indexOf(terms[start++]);
                        ++i;
                    }
                    return indexes;
                }

                public int[] getTermPositions(int index) {
                    return ((ArrayIntList)this.sortedTerms[index].getValue()).toArray(MemoryIndex.access$7(MemoryIndexReader.access$4(this.this$1)));
                }

                public TermVectorOffsetInfo[] getOffsets(int index) {
                    if (MemoryIndex.access$7(MemoryIndexReader.access$4(this.this$1)) == 1) {
                        return null;
                    }
                    ArrayIntList positions = (ArrayIntList)this.sortedTerms[index].getValue();
                    int size = positions.size();
                    TermVectorOffsetInfo[] offsets = new TermVectorOffsetInfo[size / MemoryIndex.access$7(MemoryIndexReader.access$4(this.this$1))];
                    int i = 0;
                    int j = 1;
                    while (j < size) {
                        int start = positions.get(j);
                        int end = positions.get(j + 1);
                        offsets[i] = new TermVectorOffsetInfo(start, end);
                        ++i;
                        j += MemoryIndex.access$7(MemoryIndexReader.access$4(this.this$1));
                    }
                    return offsets;
                }
            };
        }

        private Similarity getSimilarity() {
            if (this.searcher != null) {
                return this.searcher.getSimilarity();
            }
            return Similarity.getDefault();
        }

        private void setSearcher(Searcher searcher) {
            this.searcher = searcher;
        }

        public byte[] norms(String fieldName) {
            byte[] norms = this.cachedNorms;
            Similarity sim = this.getSimilarity();
            if (fieldName != this.cachedFieldName || sim != this.cachedSimilarity) {
                Info info = this.getInfo(fieldName);
                int numTokens = info != null ? info.numTokens : 0;
                float n = sim.lengthNorm(fieldName, numTokens);
                byte norm = Similarity.encodeNorm((float)n);
                this.cachedNorms = norms = new byte[]{norm};
                this.cachedFieldName = fieldName;
                this.cachedSimilarity = sim;
            }
            return norms;
        }

        public void norms(String fieldName, byte[] bytes, int offset) {
            byte[] norms = this.norms(fieldName);
            System.arraycopy(norms, 0, bytes, offset, norms.length);
        }

        protected void doSetNorm(int doc, String fieldName, byte value) {
            throw new UnsupportedOperationException();
        }

        public int numDocs() {
            return MemoryIndex.this.fields.size() > 0 ? 1 : 0;
        }

        public int maxDoc() {
            return 1;
        }

        public Document document(int n) {
            return new Document();
        }

        public boolean isDeleted(int n) {
            return false;
        }

        public boolean hasDeletions() {
            return false;
        }

        protected void doDelete(int docNum) {
            throw new UnsupportedOperationException();
        }

        protected void doUndeleteAll() {
            throw new UnsupportedOperationException();
        }

        protected void doCommit() {
        }

        protected void doClose() {
        }

        public Collection getFieldNames() {
            return this.getFieldNames(true);
        }

        public Collection getFieldNames(boolean indexed) {
            return indexed ? Collections.unmodifiableSet(MemoryIndex.this.fields.keySet()) : Collections.EMPTY_SET;
        }

        public Collection getIndexedFieldNames(boolean storedTermVector) {
            return this.getFieldNames(storedTermVector);
        }

        public Collection getIndexedFieldNames(Field.TermVector tvSpec) {
            throw new UnsupportedOperationException("Deprecated; replaced by getFieldNames(IndexReader.FieldOption)");
        }

        public Collection getFieldNames(IndexReader.FieldOption fieldOption) {
            if (fieldOption == IndexReader.FieldOption.UNINDEXED) {
                return Collections.EMPTY_SET;
            }
            if (fieldOption == IndexReader.FieldOption.INDEXED_NO_TERMVECTOR) {
                return Collections.EMPTY_SET;
            }
            if (fieldOption == IndexReader.FieldOption.TERMVECTOR_WITH_OFFSET && MemoryIndex.this.stride == 1) {
                return Collections.EMPTY_SET;
            }
            if (fieldOption == IndexReader.FieldOption.TERMVECTOR_WITH_POSITION_OFFSET && MemoryIndex.this.stride == 1) {
                return Collections.EMPTY_SET;
            }
            return Collections.unmodifiableSet(MemoryIndex.this.fields.keySet());
        }

        static /* synthetic */ Info access$0(MemoryIndexReader memoryIndexReader, int n) {
            return memoryIndexReader.getInfo(n);
        }

        static /* synthetic */ Info access$1(MemoryIndexReader memoryIndexReader, String string) {
            return memoryIndexReader.getInfo(string);
        }

        static /* synthetic */ MemoryIndex access$4(MemoryIndexReader memoryIndexReader) {
            return memoryIndexReader.MemoryIndex.this;
        }
    }
}

