/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.service.impl;

import com.jaspersoft.jasperserver.api.engine.common.service.ActionModelSupport;
import com.jaspersoft.jasperserver.core.util.RegexUtil;
import com.jaspersoft.jasperserver.core.util.XMLUtil;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;

public class ActionModel {
    private static final Log log = LogFactory.getLog(ActionModel.class);
    private static final ActionModel _singleTon = new ActionModel();
    private static final String SIMPLE_ACTION_ELEM = "simpleAction";
    private static final String INPUT_ACTION_ELEM = "inputAction";
    private static final String SELECT_ACTION_ELEM = "selectAction";
    private static final String SEPARATOR_ELEM = "separator";
    private static final String CONDITION_ELEM = "condition";
    private static final String OPTION_ELEM = "option";
    private static final String GENERATED_OPTIONS_ELEM = "generatedOptions";
    private static final String GENERATE_FROM_TEMPLATE_ELEM = "generateFromTemplate";
    private static final String LABEL_OPTION_ELEM = "labelOption";
    private static final String NAME_ATTR = "name";
    private static final String ID_ATTR = "id";
    private static final String TEST_ATTR = "test";
    private static final String TEST_ARGS_ATTR = "testArgs";
    private static final String CLIENT_TEST_ATTR = "clientTest";
    private static final String CLIENT_TEST_ARGS_ATTR = "clientTestArgs";
    private static final String ACTION_ATTR = "action";
    private static final String ACTION_ARGS_ATTR = "actionArgs";
    private static final String SELECTION_CONSTRAINT_ATTR = "selectionConstraint";
    private static final String BUTTON_ATTR = "button";
    private static final String DISABLED_ATTR = "disabled";
    private static final String LABEL_KEY_ATTR = "labelKey";
    private static final String LABEL_CONDITION_ATTR = "labelCondition";
    private static final String LABEL_FUNCTION_ATTR = "labelFunction";
    private static final String LABEL_FUNCTION_ARGS_ATTR = "labelFunctionArgs";
    private static final String LABEL_EXPRESSION_ATTR = "labelExpression";
    private static final String FUNCTION_RESPONSE_ATTR = "functionResponse";
    private static final String IS_SELECTED_TEST_ATTR = "isSelectedTest";
    private static final String IS_SELECTED_TEST_ARGS_ATTR = "isSelectedTestArgs";
    private static final String FUNCTION_ATTR = "function";
    private static final String FUNCTION_ARGS_ATTR = "functionArgs";
    private static final String ALLOWS_INPUT_TEST_ATTR = "allowsInputTest";
    private static final String ALLOWS_INPUT_TEST_ARGS_ATTR = "allowsInputTestArgs";
    private static final String NO_ICON_INDENT_ATTR = "noIconIndent";
    private static final String TYPE_KEY = "type";
    private static final String ID_KEY = "id";
    private static final String TEXT_KEY = "text";
    private static final String CLIENT_TEST_KEY = "clientTest";
    private static final String CLIENT_TEST_ARGS_KEY = "clientTestArgs";
    private static final String ACTION_KEY = "action";
    private static final String ACTION_ARGS_KEY = "actionArgs";
    private static final String IS_SELECTED_TEST_KEY = "isSelectedTest";
    private static final String IS_SELECTED_TEST_ARGS_KEY = "isSelectedTestArgs";
    private static final String ALLOWS_INPUT_TEST_KEY = "allowsInputTest";
    private static final String ALLOWS_INPUT_TEST_ARGS_KEY = "allowsInputTestArgs";
    private static final String NO_ICON_INDENT_KEY = "noIndent";
    private static final String CHILDREN_KEY = "children";
    private static final String SELECTION_CONSTRAINT_KEY = "selectionConstraint";
    private static final String BUTTON_KEY = "button";
    private static final String DISABLED_KEY = "isDisabled";
    private static final String CLASS_NAME = "className";
    private static final String RES_SELECTED_SERVER = "${selected}";
    private static final String RES_EVENT_SERVER = "${event}";
    private static final String RES_LABEL_SERVER = "${label}";
    private static final String RES_OPTION_ID_SERVER = "${optionId}";
    private static final String RES_OPTION_VALUE_SERVER = "${optionValue}";
    private static final String RES_TEMPLATE_INJECTION_INDEX = "${templateInjectionIndex}";
    private static final String RES_TEMPLATE_INJECTION_ID = "${templateInjectionId}";
    private static final String RES_TEMPLATE_INJECTION_VALUE = "${templateInjectionValue}";
    private static final String SIMPLE_VALUE = "simpleAction";
    private static final String SELECT_VALUE = "selectAction";
    private static final String INPUT_VALUE = "inputAction";
    private static final String OPTION_VALUE = "optionAction";
    private static final String SEPARATOR_VALUE = "separator";
    private static final String RES_LABEL_CLIENT = "$label";
    private static final String RES_SELECTED_CLIENT = "$selected";
    private static final String RES_EVENT_CLIENT = "$event";
    private static Map<String, String> actionTypesMap = new HashMap<String, String>();
    private static List<String> directActionTypes = new ArrayList<String>();
    private static List<String> parentActionTypes = new ArrayList<String>();
    private static Map<String, String> specialStringMap = new HashMap<String, String>();
    private static String resourceKeyRegularExpression = "\\$R\\{[a-zA-Z0-9_.]*\\}";
    private static String arrayStringDelimiterRegularExpression = "@@";
    private static int templateInjectionIndex = 0;
    private static String templateInjectionId = "";
    private static String templateInjectionValue = "";

    private ActionModel() {
    }

    public static synchronized ActionModel getInstance() {
        return _singleTon;
    }

    public Document generateActionModelDocument(InputStream stream) {
        try {
            return XMLUtil.toDocument((InputStream)stream);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String generateClientActionModel(ActionModelSupport actionModelInterface, Document actionModel) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        Element root = actionModel.getRootElement();
        Iterator contextIt = root.getChildren().iterator();
        while (contextIt.hasNext()) {
            Element context = (Element)contextIt.next();
            if (context.getAttributeValue(TEST_ATTR) != null && !ActionModel.shouldInclude(actionModelInterface, context)) continue;
            ActionModel.appendContext(context, sb);
            sb.append("[");
            ActionModel.generateChildActions(context, actionModelInterface, sb);
            sb.append("]");
            if (!contextIt.hasNext()) continue;
            sb.append(",");
        }
        int lastCharIndex = sb.length() - 1;
        if (sb.charAt(lastCharIndex) == ',') {
            sb.deleteCharAt(lastCharIndex);
        }
        sb.append("}");
        return sb.toString();
    }

    private static void generateChildActions(Element parentNode, ActionModelSupport actionModelInterface, StringBuffer sb) throws Exception {
        Iterator actionIt = parentNode.getChildren().iterator();
        while (actionIt.hasNext()) {
            Element action = (Element)actionIt.next();
            if (action.getName().equals(CONDITION_ELEM)) {
                if (!ActionModel.shouldInclude(actionModelInterface, action)) continue;
                ActionModel.generateChildActions(action, actionModelInterface, sb);
                continue;
            }
            if (action.getName().equals(GENERATED_OPTIONS_ELEM)) {
                ActionModel.generateOptions(actionModelInterface, sb, action);
            } else if (action.getName().equals(GENERATE_FROM_TEMPLATE_ELEM)) {
                ActionModel.generateFromTemplate(actionModelInterface, sb, action);
            } else {
                ActionModel.generateAction(actionModelInterface, sb, action);
            }
            if (!actionIt.hasNext()) continue;
        }
    }

    private static void generateAction(ActionModelSupport actionModelInterface, StringBuffer sb, Element action) throws Exception {
        String actionType = action.getName();
        Character latestChar = Character.valueOf(sb.charAt(sb.length() - 1));
        if (latestChar.charValue() == ']' || latestChar.charValue() == '}') {
            sb.append(",");
        }
        sb.append("{");
        ActionModel.appendType(actionType, sb);
        ActionModel.appendStandardProperty("id", action.getAttributeValue("id"), sb);
        ActionModel.appendStandardProperty("clientTest", action.getAttributeValue("clientTest"), sb);
        ActionModel.appendStandardArgs("clientTestArgs", action.getAttributeValue("clientTestArgs"), sb);
        ActionModel.appendStandardProperty("selectionConstraint", action.getAttributeValue("selectionConstraint"), sb);
        ActionModel.appendStandardProperty("allowsInputTest", action.getAttributeValue("allowsInputTest"), sb);
        ActionModel.appendStandardArgs("allowsInputTestArgs", action.getAttributeValue("allowsInputTestArgs"), sb);
        ActionModel.appendStandardProperty(NO_ICON_INDENT_KEY, action.getAttributeValue(NO_ICON_INDENT_ATTR), sb);
        ActionModel.appendStandardProperty("button", action.getAttributeValue("button"), sb);
        ActionModel.appendStandardProperty(DISABLED_KEY, action.getAttributeValue(DISABLED_ATTR), sb);
        if (action.getAttributeValue(CLASS_NAME) != null) {
            ActionModel.appendStandardProperty(CLASS_NAME, action.getAttributeValue(CLASS_NAME), sb);
        }
        if (ActionModel.hasText(actionType)) {
            ActionModel.appendText(action, actionModelInterface, sb);
        }
        if (ActionModel.firesAction(actionType)) {
            ActionModel.appendStandardProperty("action", action.getAttributeValue("action"), sb);
            ActionModel.appendStandardArgs("actionArgs", action.getAttributeValue("actionArgs"), sb);
        }
        if (ActionModel.indicatesSelection(action)) {
            ActionModel.appendStandardProperty("isSelectedTest", action.getAttributeValue("isSelectedTest"), sb);
            ActionModel.appendStandardArgs("isSelectedTestArgs", action.getAttributeValue("isSelectedTestArgs"), sb);
        }
        if (ActionModel.hasChildren(actionType)) {
            ActionModel.appendChildren(action, actionModelInterface, sb);
        }
        sb.append("}");
    }

    private static void appendContext(Element context, StringBuffer sb) {
        sb.append("\"");
        sb.append(context.getAttributeValue(NAME_ATTR));
        sb.append("\"");
        sb.append(":");
    }

    private static void appendType(String actionType, StringBuffer sb) {
        sb.append("\"");
        sb.append(TYPE_KEY);
        sb.append("\": ");
        sb.append("\"");
        sb.append(actionTypesMap.get(actionType));
        sb.append("\"");
    }

    private static void appendStandardProperty(String key, String value, StringBuffer sb) {
        if (value != null) {
            sb.append(",");
            sb.append("\"");
            sb.append(key);
            sb.append("\": ");
            sb.append("\"");
            sb.append(value);
            sb.append("\"");
        }
    }

    private static void appendStandardArgs(String key, String args, StringBuffer sb) {
        if (args == null) {
            return;
        }
        sb.append(",");
        sb.append("\"");
        sb.append(key);
        sb.append("\": ");
        sb.append(ActionModel.formatDelimitedStringAsArrayString(args));
    }

    private static void appendText(Element action, ActionModelSupport actionModelContext, StringBuffer sb) throws Exception {
        sb.append(",");
        sb.append("\"");
        sb.append(TEXT_KEY);
        sb.append("\": ");
        String labelKey = ActionModel.getLabelKey(action, actionModelContext);
        sb.append("\"");
        sb.append(ActionModel.getLocalizedValue(labelKey, actionModelContext));
        sb.append("\"");
    }

    private static String getLabelKey(Element action, ActionModelSupport actionModelContext) throws Exception {
        String labelKey = action.getAttributeValue(LABEL_KEY_ATTR);
        if (labelKey != null) {
            return ActionModel.swapOutSpecialStrings(labelKey);
        }
        String labelCondition = action.getAttributeValue(LABEL_CONDITION_ATTR);
        if (labelCondition != null) {
            return ActionModel.getLabelForCondition(action, actionModelContext, labelCondition);
        }
        String labelFunction = action.getAttributeValue(LABEL_FUNCTION_ATTR);
        if (labelFunction != null) {
            return ActionModel.getLabelForFunction(action, actionModelContext, labelFunction, action.getAttributeValue(LABEL_FUNCTION_ARGS_ATTR));
        }
        throw new Exception("could not derive action text for action " + action);
    }

    private static String getLabelForCondition(Element elem, ActionModelSupport actionModelContext, String labelCondition) throws Exception {
        Method labelMethod = actionModelContext.getClass().getMethod(labelCondition, new Class[0]);
        String methodResult = labelMethod.invoke((Object)actionModelContext, new Object[0]).toString();
        for (Element thisLabelOption : elem.getChildren(LABEL_OPTION_ELEM)) {
            if (!thisLabelOption.getAttributeValue(FUNCTION_RESPONSE_ATTR).equals(methodResult)) continue;
            return ActionModel.getLabelKey(thisLabelOption, actionModelContext);
        }
        return null;
    }

    private static String getLabelForFunction(Element elem, ActionModelSupport actionModelContext, String labelFunction, String labelFunctionArgsString) throws Exception {
        Object[] args = labelFunctionArgsString == null ? new Object[]{} : RegexUtil.getResourceKeyPattern((String)arrayStringDelimiterRegularExpression).split(labelFunctionArgsString);
        Class[] argTypes = RegexUtil.getArgTypesFromArgs((Object[])args);
        Method thisMethod = actionModelContext.getClass().getMethod(labelFunction, argTypes);
        return thisMethod.invoke((Object)actionModelContext, args).toString();
    }

    private static void appendChildren(Element action, ActionModelSupport actionModelContext, StringBuffer sb) throws Exception {
        sb.append(",");
        sb.append("\"");
        sb.append(CHILDREN_KEY);
        sb.append("\": ");
        sb.append("[");
        ActionModel.generateChildActions(action, actionModelContext, sb);
        sb.append("]");
    }

    private static void generateOptions(ActionModelSupport actionModelContext, StringBuffer sb, Element action) throws Exception {
        boolean usingMap;
        Iterator<Object> optionsIt;
        Object options = ActionModel.getGenerationSource(actionModelContext, action.getAttributeValue(FUNCTION_ATTR), action.getAttributeValue(FUNCTION_ARGS_ATTR));
        if (options instanceof Map) {
            optionsIt = ((Map)options).keySet().iterator();
            usingMap = true;
        } else {
            optionsIt = ((Collection)options).iterator();
            usingMap = false;
        }
        while (optionsIt.hasNext()) {
            Object thisOption = optionsIt.next();
            String optionId = thisOption.toString();
            String optionValue = usingMap ? ((Map)options).get(thisOption).toString() : optionId;
            Element optionAction = new Element(OPTION_ELEM);
            String labelExpression = action.getAttributeValue(LABEL_EXPRESSION_ATTR);
            if (labelExpression != null) {
                optionAction.setAttribute(LABEL_KEY_ATTR, ActionModel.generateOptionLabel(actionModelContext, labelExpression, optionValue, optionId));
            } else {
                optionAction.setAttribute(LABEL_KEY_ATTR, optionValue);
            }
            optionAction.setAttribute("action", action.getAttributeValue("action"));
            optionAction.setAttribute("actionArgs", ActionModel.getAsOptionArgs(action.getAttributeValue("actionArgs"), optionValue, optionId));
            if (action.getAttributeValue("isSelectedTest") != null) {
                optionAction.setAttribute("isSelectedTest", action.getAttributeValue("isSelectedTest"));
                optionAction.setAttribute("isSelectedTestArgs", ActionModel.getAsOptionArgs(action.getAttributeValue("isSelectedTestArgs"), optionValue, optionId));
            }
            if (action.getAttributeValue("clientTest") != null) {
                optionAction.setAttribute("clientTest", action.getAttributeValue("clientTest"));
                optionAction.setAttribute("clientTestArgs", ActionModel.getAsOptionArgs(action.getAttributeValue("clientTestArgs"), optionValue, optionId));
            }
            if (action.getAttributeValue("allowsInputTest") != null) {
                optionAction.setAttribute("allowsInputTest", action.getAttributeValue("allowsInputTest"));
                optionAction.setAttribute("allowsInputTestArgs", ActionModel.getAsOptionArgs(action.getAttributeValue("allowsInputTestArgs"), optionValue, optionId));
            }
            if (action.getAttributeValue(CLASS_NAME) != null) {
                optionAction.setAttribute(CLASS_NAME, action.getAttributeValue(CLASS_NAME));
            }
            if (action.getAttributeValue("id") != null) {
                optionAction.setAttribute("id", ActionModel.getAsOptionArgs(action.getAttributeValue("id"), optionValue, optionId));
            } else {
                optionAction.setAttribute("id", optionId);
            }
            ActionModel.generateAction(actionModelContext, sb, optionAction);
            if (!optionsIt.hasNext()) continue;
            sb.append(",");
        }
    }

    private static String getAsOptionArgs(String argsString, String optionValue, String optionId) {
        if (argsString == null) {
            return optionId;
        }
        argsString = argsString.replace(RES_OPTION_VALUE_SERVER, optionValue);
        argsString = argsString.replace(RES_OPTION_ID_SERVER, optionId);
        return argsString;
    }

    private static String generateOptionLabel(ActionModelSupport actionModelContext, String labelExpression, String optionValue, String optionId) {
        labelExpression = labelExpression.replace(RES_OPTION_VALUE_SERVER, optionValue);
        labelExpression = labelExpression.replace(RES_OPTION_ID_SERVER, optionId);
        Matcher matcher = RegexUtil.getResourceKeyPattern((String)resourceKeyRegularExpression).matcher(labelExpression);
        if (matcher.find()) {
            String resourceKeyPattern = labelExpression.substring(matcher.start(), matcher.end());
            String resourceKey = resourceKeyPattern.substring(3, resourceKeyPattern.length() - 1);
            String translation = ActionModel.getLocalizedValue(resourceKey, actionModelContext);
            return labelExpression.replace(resourceKeyPattern, translation);
        }
        return labelExpression;
    }

    private static void generateFromTemplate(ActionModelSupport actionModelContext, StringBuffer sb, Element action) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, Exception {
        boolean usingMap;
        Iterator<Object> templateInjectorsIt;
        Object templateInjectors = ActionModel.getGenerationSource(actionModelContext, action.getAttributeValue(FUNCTION_ATTR), action.getAttributeValue(FUNCTION_ARGS_ATTR));
        if (templateInjectors instanceof Map) {
            templateInjectorsIt = ((Map)templateInjectors).keySet().iterator();
            usingMap = true;
        } else {
            templateInjectorsIt = ((Collection)templateInjectors).iterator();
            usingMap = false;
        }
        templateInjectionIndex = -1;
        while (templateInjectorsIt.hasNext()) {
            ++templateInjectionIndex;
            Object thisTemplateInjector = templateInjectorsIt.next();
            templateInjectionId = thisTemplateInjector.toString();
            templateInjectionValue = usingMap ? ((Map)templateInjectors).get(thisTemplateInjector).toString() : templateInjectionId;
            for (Element childAction : action.getChildren()) {
                ActionModel.generateAction(actionModelContext, sb, childAction);
            }
            if (!templateInjectorsIt.hasNext()) continue;
            sb.append(",");
        }
    }

    private static String getLocalizedValue(String labelKey, ActionModelSupport actionModelContext) {
        return actionModelContext.getMessage(labelKey);
    }

    private static boolean firesAction(String actionType) {
        return directActionTypes.contains(actionType);
    }

    private static boolean hasText(String actionType) {
        return !actionType.equals("separator");
    }

    private static boolean indicatesSelection(Element action) {
        return action.getAttribute("isSelectedTest") != null;
    }

    private static boolean hasChildren(String actionType) {
        return parentActionTypes.contains(actionType);
    }

    private static boolean shouldInclude(ActionModelSupport actionModelContext, Element action) throws Exception {
        boolean passingResult = true;
        String test = action.getAttributeValue(TEST_ATTR);
        if (test.indexOf("!") == 0) {
            test = test.substring(1);
            passingResult = false;
        }
        String testArgsString = action.getAttributeValue(TEST_ARGS_ATTR);
        Object result = false;
        Method testMethod = null;
        Object[] testArgs = testArgsString == null ? new Object[]{} : RegexUtil.getResourceKeyPattern((String)arrayStringDelimiterRegularExpression).split(testArgsString);
        Class[] testArgTypes = RegexUtil.getArgTypesFromArgs((Object[])testArgs);
        try {
            testMethod = actionModelContext.getClass().getMethod(test, testArgTypes);
            result = testMethod.invoke((Object)actionModelContext, testArgs);
        }
        catch (NoSuchMethodException ex) {
            log.error((Object)("Test method '" + test + "' not found. Please correct the action model xml. " + "All underlying elements are skipped."));
            return false;
        }
        catch (IllegalAccessException ex) {
            return false;
        }
        catch (InvocationTargetException ex) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result == passingResult;
        }
        throw new Exception("Test " + testMethod + "should return a boolean");
    }

    private static Object getGenerationSource(ActionModelSupport actionModelContext, String function, String functionArgsString) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, Exception {
        Object[] args = functionArgsString == null ? new Object[]{} : RegexUtil.getResourceKeyPattern((String)arrayStringDelimiterRegularExpression).split(functionArgsString);
        Class[] argTypes = RegexUtil.getArgTypesFromArgs((Object[])args);
        Method optionsMethod = actionModelContext.getClass().getMethod(function, argTypes);
        Object options = optionsMethod.invoke((Object)actionModelContext, args);
        if (options instanceof Collection || options instanceof Map) {
            return options;
        }
        throw new Exception("function " + optionsMethod + "should return a Collection or a Map");
    }

    private static String swapOutSpecialStrings(String input) {
        for (String thisKey : specialStringMap.keySet()) {
            input = input.replace(thisKey, specialStringMap.get(thisKey));
        }
        input = input.replace(RES_TEMPLATE_INJECTION_INDEX, templateInjectionIndex + "");
        input = input.replace(RES_TEMPLATE_INJECTION_ID, templateInjectionId);
        input = input.replace(RES_TEMPLATE_INJECTION_VALUE, templateInjectionValue);
        return input;
    }

    private static StringBuffer formatDelimitedStringAsArrayString(String delimitedString) {
        StringTokenizer tokenizer = new StringTokenizer(delimitedString, "@@");
        StringBuffer valueBuffer = new StringBuffer();
        valueBuffer.append("[");
        while (tokenizer.hasMoreTokens()) {
            valueBuffer.append("\"");
            valueBuffer.append(ActionModel.swapOutSpecialStrings(tokenizer.nextToken()));
            valueBuffer.append("\"");
            if (!tokenizer.hasMoreTokens()) continue;
            valueBuffer.append(",");
        }
        valueBuffer.append("]");
        return valueBuffer;
    }

    static {
        actionTypesMap.put("simpleAction", "simpleAction");
        actionTypesMap.put("selectAction", "selectAction");
        actionTypesMap.put("inputAction", "inputAction");
        actionTypesMap.put(OPTION_ELEM, OPTION_VALUE);
        actionTypesMap.put("separator", "separator");
        directActionTypes.add("simpleAction");
        directActionTypes.add(OPTION_ELEM);
        parentActionTypes.add("selectAction");
        parentActionTypes.add(CONDITION_ELEM);
        specialStringMap.put(RES_LABEL_SERVER, RES_LABEL_CLIENT);
        specialStringMap.put(RES_SELECTED_SERVER, RES_SELECTED_CLIENT);
        specialStringMap.put(RES_EVENT_SERVER, RES_EVENT_CLIENT);
    }
}

