/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.service.impl;

import com.jaspersoft.jasperserver.api.engine.common.service.ActionModelSupport;
import com.jaspersoft.jasperserver.api.engine.common.service.impl.ActionModel;
import com.jaspersoft.jasperserver.api.engine.common.service.impl.ActionModelServiceImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContext;
import org.springframework.security.context.SecurityContextHolder;

public class NavigationActionModelSupport
implements ActionModelSupport {
    private static String action_model_context;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messages;
    private static final String ROLES_DELIMITER = ",";
    private static final String NO_TENANT_ID = "null";
    private static boolean isProVersion;
    private static Log log;
    private HttpServletRequest request;

    public String getClientActionModelDocument(String context, HttpServletRequest request) {
        String json = "";
        if (context == null || context.length() <= 0) {
            log.error((Object)("Unable to create " + context + " menu. Most likely programmer error"));
            throw new RuntimeException("Unable to create menu.");
        }
        action_model_context = context;
        this.request = request;
        json = this.getClientActionModelDocument();
        return json;
    }

    public String getClientActionModelDocument() {
        String data;
        Document document = ActionModelServiceImpl.getInstance().getActionModelMenu(action_model_context);
        try {
            data = ActionModel.getInstance().generateClientActionModel(this, document);
        }
        catch (Exception e) {
            log.error((Object)"Unable to create navigation menu");
            e.printStackTrace();
            data = "";
        }
        return data;
    }

    public boolean isProVersion() {
        return isProVersion;
    }

    public boolean isCEVersion() {
        return !this.isProVersion();
    }

    public boolean isAvailableProFeature(String id) {
        return false;
    }

    public boolean isSupportedDevice() {
        String userAgent = this.request.getHeader("user-agent");
        return userAgent.indexOf("iPad") == -1;
    }

    public boolean isMainFeaturesDisabled() {
        return false;
    }

    public boolean isUsersExceeded() {
        return false;
    }

    public boolean banUserRole() {
        return false;
    }

    public boolean showMTMenuItem() {
        return false;
    }

    private Set getAuthenticationRoles() {
        SecurityContext secContext = SecurityContextHolder.getContext();
        Authentication authentication = secContext.getAuthentication();
        Object principalObject = authentication.getPrincipal();
        if (principalObject.toString().equals("anonymousUser")) {
            return new HashSet();
        }
        User principal = (User)principalObject;
        if (principal == null) {
            log.error((Object)"Authentication is null.");
            throw new RuntimeException("[Error]: Authentication is null.");
        }
        return principal.getRoles();
    }

    public boolean checkAuthenticationRoles(String allowedRoles) {
        String[] roles;
        for (String role : roles = allowedRoles.split(ROLES_DELIMITER)) {
            if (!this.checkRole(role.trim())) continue;
            return true;
        }
        return false;
    }

    private boolean checkRole(String role) {
        String[] tenantIdArray = role.split("\\|");
        String expectedTenantId = tenantIdArray.length > 1 ? tenantIdArray[1] : NO_TENANT_ID;
        String expectedRole = tenantIdArray[0];
        Set userRoles = this.getAuthenticationRoles();
        for (Object obj : userRoles) {
            String roleName = ((Role)obj).getRoleName();
            String roleTenantId = ((Role)obj).getTenantId();
            if (roleTenantId == null) {
                roleTenantId = NO_TENANT_ID;
            }
            if (!roleTenantId.equals(expectedTenantId) || !roleName.equals(expectedRole)) continue;
            return true;
        }
        return false;
    }

    public int getFunctionId() {
        return 3;
    }

    public String getMessage(String label) {
        return this.messages.getMessage(label, null, LocaleContextHolder.getLocale());
    }

    public void setDefaultMessageSource(MessageSource messages) {
        this.messages = messages;
    }

    public MessageSource getDefaultMessageSource() {
        return this.messages;
    }

    public static void setProVersion(boolean proVersion) {
        isProVersion = proVersion;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    static {
        isProVersion = false;
        log = LogFactory.getLog(NavigationActionModelSupport.class);
    }
}

