/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.BeanReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceServiceFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class BeanReportDataSourceServiceFactory
implements ReportDataSourceServiceFactory,
ApplicationContextAware {
    ApplicationContext ctx;

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        this.ctx = arg0;
    }

    public ReportDataSourceService createService(ReportDataSource reportDataSource) {
        if (!(reportDataSource instanceof BeanReportDataSource)) {
            throw new JSException("jsexception.invalid.bean.datasource", new Object[]{reportDataSource.getClass()});
        }
        BeanReportDataSource beanDataSource = (BeanReportDataSource)reportDataSource;
        Object bean = this.ctx.getBean(beanDataSource.getBeanName());
        if (bean == null) {
            throw new JSException("jsexception.bean.no.name", new Object[]{beanDataSource.getBeanName()});
        }
        if (beanDataSource.getBeanMethod() == null) {
            if (!(bean instanceof ReportDataSourceService)) {
                throw new JSException("jsexception.bean.not.a.ReportDataSourceService", new Object[]{beanDataSource.getBeanName()});
            }
            return (ReportDataSourceService)bean;
        }
        try {
            Method serviceMethod = bean.getClass().getMethod(beanDataSource.getBeanMethod(), null);
            return (ReportDataSourceService)serviceMethod.invoke(bean, null);
        }
        catch (SecurityException e) {
            throw new JSExceptionWrapper((Exception)e);
        }
        catch (NoSuchMethodException e) {
            throw new JSException("jsexception.bean.has.no.method", new Object[]{beanDataSource.getBeanName(), beanDataSource.getBeanMethod()});
        }
        catch (IllegalArgumentException e) {
            throw new JSExceptionWrapper((Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new JSExceptionWrapper((Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new JSExceptionWrapper((Exception)e);
        }
    }
}

