/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JdbcDataSourceService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.PooledDataSource;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.PooledJdbcDataSourceFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.PooledObjectCache;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.PooledObjectEntry;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceServiceFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdbcReportDataSourceServiceFactory
implements ReportDataSourceServiceFactory {
    private static final Log log = LogFactory.getLog(JdbcReportDataSourceServiceFactory.class);
    private PooledJdbcDataSourceFactory pooledJdbcDataSourceFactory;
    private PooledDataSourcesCache poolDataSources = new PooledDataSourcesCache();
    private int poolTimeout;
    private boolean defaultReadOnly = true;
    private boolean defaultAutoCommit = false;

    protected TimeZone getTimeZoneByDataSourceTimeZone(String dataSourceTimeZone) {
        String timezoneId = dataSourceTimeZone == null ? "" : dataSourceTimeZone;
        return timezoneId.isEmpty() ? TimeZone.getDefault() : TimeZone.getTimeZone(timezoneId);
    }

    public ReportDataSourceService createService(ReportDataSource reportDataSource) {
        if (!(reportDataSource instanceof JdbcReportDataSource)) {
            throw new JSException("jsexception.invalid.jdbc.datasource", new Object[]{reportDataSource.getClass()});
        }
        JdbcReportDataSource jdbcDataSource = (JdbcReportDataSource)reportDataSource;
        DataSource dataSource = this.getPoolDataSource(jdbcDataSource.getDriverClass(), jdbcDataSource.getConnectionUrl(), jdbcDataSource.getUsername(), jdbcDataSource.getPassword());
        return new JdbcDataSourceService(dataSource, this.getTimeZoneByDataSourceTimeZone(jdbcDataSource.getTimezone()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSource getPoolDataSource(String driverClass, String url, String username, String password) {
        PooledDataSource dataSource;
        long now = System.currentTimeMillis();
        this.releaseExpiredPools(now);
        Object poolKey = this.createJdbcPoolKey(driverClass, url, username, password);
        PooledObjectCache pooledObjectCache = this.poolDataSources.pooledObjectCache;
        synchronized (pooledObjectCache) {
            dataSource = this.poolDataSources.get(poolKey, now);
            if (dataSource == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating connection pool for " + poolKey + "."));
                }
                dataSource = this.pooledJdbcDataSourceFactory.createPooledDataSource(driverClass, url, username, password, this.defaultReadOnly, this.defaultAutoCommit);
                this.poolDataSources.put(poolKey, dataSource, now);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Using cached connection pool for " + poolKey + "."));
            }
        }
        return dataSource.getDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseExpiredPools(long now) {
        List expired = null;
        PooledObjectCache pooledObjectCache = this.poolDataSources.pooledObjectCache;
        synchronized (pooledObjectCache) {
            if (this.getPoolTimeout() > 0) {
                expired = this.poolDataSources.removeExpired(now, this.getPoolTimeout());
            }
        }
        if (expired != null && !expired.isEmpty()) {
            for (PooledDataSource ds : expired) {
                try {
                    ds.release();
                }
                catch (Exception e) {
                    log.error((Object)"Error while releasing connection pool.", (Throwable)e);
                }
            }
        }
    }

    public PooledJdbcDataSourceFactory getPooledJdbcDataSourceFactory() {
        return this.pooledJdbcDataSourceFactory;
    }

    public void setPooledJdbcDataSourceFactory(PooledJdbcDataSourceFactory jdbcDataSourceFactory) {
        this.pooledJdbcDataSourceFactory = jdbcDataSourceFactory;
    }

    protected Object createJdbcPoolKey(String driverClass, String url, String username, String password) {
        return new JdbcPoolKey(driverClass, url, username, password);
    }

    public int getPoolTimeout() {
        return this.poolTimeout;
    }

    public void setPoolTimeout(int poolTimeout) {
        this.poolTimeout = poolTimeout;
    }

    public boolean getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    public boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    protected static class JdbcPoolKey {
        private final String driverClass;
        private final String url;
        private final String username;
        private final String password;
        private final int hash;

        public JdbcPoolKey(String driverClass, String url, String username, String password) {
            this.driverClass = driverClass;
            this.url = url;
            this.username = username;
            this.password = password;
            int hashCode = 559;
            if (driverClass != null) {
                hashCode += driverClass.hashCode();
            }
            hashCode *= 43;
            if (url != null) {
                hashCode += url.hashCode();
            }
            hashCode *= 43;
            if (username != null) {
                hashCode += username.hashCode();
            }
            hashCode *= 43;
            if (password != null) {
                hashCode += password.hashCode();
            }
            this.hash = hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof JdbcPoolKey)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            JdbcPoolKey key = (JdbcPoolKey)obj;
            return (this.driverClass == null ? key.driverClass == null : key.driverClass != null && this.driverClass.equals(key.driverClass)) && (this.url == null ? key.url == null : key.url != null && this.url.equals(key.url)) && (this.username == null ? key.username == null : key.username != null && this.username.equals(key.username)) && (this.password == null ? key.password == null : key.password != null && this.password.equals(key.password));
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return "driver=\"" + this.driverClass + "\", url=\"" + this.url + "\", username=\"" + this.username + "\"";
        }
    }

    protected static class PooledDataSourcesCache {
        protected PooledObjectCache pooledObjectCache = new PooledObjectCache();

        public PooledDataSourcesCache() {
            this.pooledObjectCache.setLog(new PooledDataSourcesCacheLog());
        }

        public PooledDataSource get(Object key, long now) {
            PooledObjectEntry entry = this.pooledObjectCache.get(key, now);
            if (entry != null && entry instanceof DataSourceEntry) {
                return ((DataSourceEntry)entry).ds;
            }
            return null;
        }

        public void put(Object key, PooledDataSource ds, long now) {
            DataSourceEntry entry = new DataSourceEntry(key, ds);
            this.pooledObjectCache.put(key, entry, now);
        }

        public List removeExpired(long now, int timeout) {
            ArrayList<PooledDataSource> expired = new ArrayList<PooledDataSource>();
            List<PooledObjectEntry> expiredEntries = this.pooledObjectCache.removeExpired(now, timeout);
            for (PooledObjectEntry objectEntry : expiredEntries) {
                expired.add(((DataSourceEntry)objectEntry).ds);
            }
            return expired;
        }

        static class PooledDataSourcesCacheLog
        implements PooledObjectCache.PooledObjectCacheLog {
            PooledDataSourcesCacheLog() {
            }

            @Override
            public void debug(Object key, PooledObjectCache.PooledObjectCacheLog.DebugCode code) {
                if (!log.isDebugEnabled()) {
                    return;
                }
                switch (code) {
                    case STILL_ACTIVE: {
                        log.debug((Object)("Connection pool for " + key + " is still active, not expiring"));
                        break;
                    }
                    case EXPIRING: {
                        log.debug((Object)("Expiring connection pool for " + key));
                    }
                }
            }
        }

        protected static class DataSourceEntry
        extends PooledObjectEntry {
            final PooledDataSource ds;

            public DataSourceEntry(Object key, PooledDataSource ds) {
                super(key);
                this.ds = ds;
            }

            @Override
            public boolean isActive() {
                return this.ds.isActive();
            }
        }
    }
}

