/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitRequestBase;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.ReportDataParameterContributor;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.ReportLoadingService;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControlsContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.util.RepositoryUtils;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JasperReport;

public class ReportInputDataParameterContributors
implements ReportDataParameterContributor {
    private ReportLoadingService reportLoadingService;

    @Override
    public Map<String, Object> getDataParameters(ExecutionContext context, ReportUnitRequestBase request, ReportUnit reportUnit, JasperReport report) {
        HashMap<String, Object> inputParams = new HashMap<String, Object>();
        Map params = request.getReportParameters();
        List<ResourceReference> inputControls = this.getReportLoadingService().getInputControlReferences(context, (InputControlsContainer)reportUnit);
        if (inputControls != null) {
            for (ResourceReference ref : inputControls) {
                String paramName = this.getInputControlParameterName(ref);
                if (paramName == null) continue;
                Object value = params == null ? null : (Object)params.get(paramName);
                inputParams.put(paramName, value);
            }
        }
        return inputParams;
    }

    protected String getInputControlParameterName(ResourceReference inputControlRef) {
        String name = null;
        if (inputControlRef.isLocal()) {
            name = inputControlRef.getLocalResource().getName();
        } else {
            String referenceURI = inputControlRef.getReferenceURI();
            if (referenceURI != null) {
                name = RepositoryUtils.getName((String)referenceURI);
            }
        }
        return name;
    }

    public ReportLoadingService getReportLoadingService() {
        return this.reportLoadingService;
    }

    public void setReportLoadingService(ReportLoadingService reportLoadingService) {
        this.reportLoadingService = reportLoadingService;
    }
}

