/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.RepositoryContextManager;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.util.LocalLockManager;
import com.jaspersoft.jasperserver.api.metadata.common.util.LockHandle;
import com.jaspersoft.jasperserver.api.metadata.common.util.LockManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryCacheMap {
    private static final Log log = LogFactory.getLog(RepositoryCacheMap.class);
    private final RepositoryService repository;
    private final RepositoryContextManager repositoryContextManager;
    private final ObjectCache objectCache;
    private final Map map;
    private LockManager lockManager;

    public RepositoryCacheMap(RepositoryService repository, RepositoryContextManager repositoryContextManager, ObjectCache objectCache) {
        this.repository = repository;
        this.repositoryContextManager = repositoryContextManager;
        this.objectCache = objectCache;
        this.map = Collections.synchronizedMap(new HashMap());
        this.lockManager = new LocalLockManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheObject cache(ExecutionContext context, FileResource res, boolean cacheFirst) {
        String resourcePathKey = this.getResourcePathKey(res);
        LockHandle lock = this.lockManager.lock(this.getLockName(), resourcePathKey);
        try {
            Object ret;
            VersionObject val = null;
            if (cacheFirst) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Searching cache for " + resourcePathKey + ", version " + res.getVersion()));
                }
                val = (VersionObject)this.map.get(resourcePathKey);
                if (log.isDebugEnabled()) {
                    if (val == null) {
                        log.debug((Object)("Cache doesn't contain " + resourcePathKey));
                    } else {
                        log.debug((Object)("Found in cache " + resourcePathKey + " with version " + val.version));
                    }
                }
            }
            boolean cached = true;
            if (val != null && val.version >= res.getVersion() && (val.isReference() || this.objectCache.isValid(val.o))) {
                ret = val.o;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating cached object for " + resourcePathKey + ", version " + res.getVersion()));
                }
                if (res.isReference()) {
                    FileResource ref = (FileResource)this.repository.getResource(context, res.getReferenceURI());
                    CacheObject refCache = this.cache(context, ref, true);
                    ret = refCache.getObject();
                    if (cacheFirst) {
                        VersionObject value = new VersionObject(res.getReferenceURI(), res.getVersion());
                        this.put(resourcePathKey, value);
                    }
                } else {
                    ret = this.objectCache.create(context, res);
                    if (cacheFirst) {
                        VersionObject value = new VersionObject(ret, res.getVersion());
                        this.put(resourcePathKey, value);
                    } else {
                        cached = false;
                    }
                }
            }
            CacheObject cacheObject = new CacheObject(ret, cached);
            return cacheObject;
        }
        finally {
            this.lockManager.unlock(lock);
        }
    }

    private String getLockName() {
        return "RepositoryCacheMap_" + System.identityHashCode(this);
    }

    protected String getResourcePathKey(FileResource res) {
        String resourceUri = res.getURIString();
        String resourcePathKey = this.repositoryContextManager.getRepositoryPathKey(resourceUri);
        return resourcePathKey;
    }

    public void remove(String resourceURI) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing from cache " + resourceURI));
        }
        this.map.remove(resourceURI);
    }

    protected void put(String pathKey, VersionObject value) {
        VersionObject old = this.map.put(pathKey, value);
        if (old != null && !old.isReference()) {
            this.objectCache.release(old.o);
        }
    }

    public void release() {
        for (VersionObject val : this.map.values()) {
            if (val.isReference()) continue;
            this.objectCache.release(val.o);
        }
    }

    protected void finalize() throws Throwable {
        this.release();
    }

    public static class CacheObject {
        private final Object o;
        private final boolean cached;

        public CacheObject(Object o, boolean cached) {
            this.o = o;
            this.cached = cached;
        }

        public Object getObject() {
            return this.o;
        }

        public boolean isCached() {
            return this.cached;
        }
    }

    protected static class VersionObject {
        public final Object o;
        public final String referenceURI;
        public final int version;

        public VersionObject(Object o, int version) {
            this.o = o;
            this.referenceURI = null;
            this.version = version;
        }

        public VersionObject(String referenceURI, int version) {
            this.o = null;
            this.referenceURI = referenceURI;
            this.version = version;
        }

        public boolean isReference() {
            return this.referenceURI != null;
        }
    }

    public static interface ObjectCache {
        public boolean isValid(Object var1);

        public Object create(ExecutionContext var1, FileResource var2);

        public void release(Object var1);
    }
}

