/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.sample;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.sample.WSClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ContentResourceDataServlet
extends HttpServlet {
    private static final String WS_CLIENT_SESSION_NAME = "client";
    private static final String INVALID_SESSION_REDIRECT = "/index.jsp";
    private static final int BUFFER_SIZE = 65536;

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WSClient wsClient;
        HttpSession session = request.getSession(false);
        WSClient wSClient = wsClient = session == null ? null : (WSClient)session.getAttribute(WS_CLIENT_SESSION_NAME);
        if (wsClient == null) {
            response.sendRedirect(request.getContextPath() + INVALID_SESSION_REDIRECT);
            return;
        }
        String resourceURI = request.getPathInfo();
        ArrayList<Argument> args = new ArrayList<Argument>(1);
        args.add(new Argument("NO_SUBRESOURCE_ATTACHMENTS", null));
        File tmpDir = (File)this.getServletContext().getAttribute("javax.servlet.context.tmpdir");
        File tmpFile = File.createTempFile("contentResource", ".data", tmpDir);
        try {
            ResourceDescriptor resourceDescriptor = wsClient.get(resourceURI, tmpFile, args);
            String contentType = resourceDescriptor.getResourcePropertyValue("CONTENT_TYPE");
            if (contentType.equals("html")) {
                response.setContentType("text/html;charset=UTF-8");
            } else if (contentType.equals("pdf")) {
                response.setContentType("application/pdf");
                response.setHeader("Content-Disposition", "inline; filename=\"" + resourceDescriptor.getName() + "\"");
            } else if (contentType.equals("xls")) {
                response.setContentType("application/xls");
                response.setHeader("Content-Disposition", "inline; filename=\"" + resourceDescriptor.getName() + "\"");
            } else if (contentType.equals("rtf")) {
                response.setContentType("application/rtf");
                response.setHeader("Content-Disposition", "inline; filename=\"" + resourceDescriptor.getName() + "\"");
            } else if (contentType.equals("csv")) {
                response.setContentType("text/csv");
                response.setHeader("Content-Disposition", "inline; filename=\"" + resourceDescriptor.getName() + "\"");
            }
            response.setContentLength((int)tmpFile.length());
            this.writeFileContent(response, tmpFile);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            tmpFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFileContent(HttpServletResponse resp, File file) throws IOException {
        ServletOutputStream out = resp.getOutputStream();
        FileInputStream fileIn = new FileInputStream(file);
        try {
            int read;
            byte[] buf = new byte[65536];
            while ((read = fileIn.read(buf)) > 0) {
                out.write(buf, 0, read);
            }
        }
        finally {
            fileIn.close();
        }
        out.flush();
        out.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Content resource data servlet";
    }
}

