/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.sample;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.irplugin.JServer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JasperPrint;

public class WSClient {
    protected JServer server = new JServer();
    protected static String reportUnitDataSourceURI = "/datasources/JServerJdbcDS";
    protected static String contentFilesFolderUri = "/ContentFiles";

    public WSClient(String webServiceUrl, String username, String password) {
        this.server.setUsername(username);
        this.server.setPassword(password);
        this.server.setUrl(webServiceUrl);
    }

    public String getContentFilesFolder() {
        return contentFilesFolderUri;
    }

    public List list(String uri) throws Exception {
        ResourceDescriptor rd = new ResourceDescriptor();
        rd.setWsType("folder");
        rd.setUriString(uri);
        return this.server.getWSClient().list(rd);
    }

    public ResourceDescriptor get(String uri) throws Exception {
        return this.get(uri, null);
    }

    public ResourceDescriptor get(String uri, List args) throws Exception {
        return this.get(uri, null, args);
    }

    public ResourceDescriptor get(String uri, File outputFile, List args) throws Exception {
        ResourceDescriptor rd = new ResourceDescriptor();
        rd.setUriString(uri);
        return this.server.getWSClient().get(rd, outputFile, args);
    }

    public ResourceDescriptor get(ResourceDescriptor rd, File outputFile, List args) throws Exception {
        return this.server.getWSClient().get(rd, outputFile, args);
    }

    public JasperPrint runReport(String reportUri, Map parameters) throws Exception {
        ResourceDescriptor rd = new ResourceDescriptor();
        rd.setWsType("reportUnit");
        rd.setUriString(reportUri);
        return this.server.getWSClient().runReport(rd, parameters);
    }

    public Map runReport(String reportUri, Map parameters, List arguments) throws Exception {
        ResourceDescriptor rd = new ResourceDescriptor();
        rd.setWsType("reportUnit");
        rd.setUriString(reportUri);
        return this.server.getWSClient().runReport(rd, parameters, arguments);
    }

    public ResourceDescriptor put(String type, String name, String label, String desc, String parentFolder) throws Exception {
        ResourceDescriptor rd = new ResourceDescriptor();
        rd.setName(name);
        rd.setLabel(label);
        rd.setDescription(desc);
        rd.setParentFolder(parentFolder);
        rd.setUriString(rd.getParentFolder() + "/" + rd.getName());
        rd.setWsType(type);
        rd.setIsNew(true);
        if (type.equalsIgnoreCase("folder")) {
            return this.server.getWSClient().addOrModifyResource(rd, null);
        }
        if (type.equalsIgnoreCase("reportUnit")) {
            return this.putReportUnit(rd);
        }
        return null;
    }

    public ResourceDescriptor update(String name, String label, String desc, String parentFolder) throws Exception {
        ResourceDescriptor rd = this.get(parentFolder + "/" + name);
        rd.setLabel(label);
        rd.setDescription(desc);
        rd.setIsNew(false);
        rd.setChildren(new ArrayList());
        return this.server.getWSClient().addOrModifyResource(rd, null);
    }

    public void delete(String uri) throws Exception {
        ResourceDescriptor rd = new ResourceDescriptor();
        rd.setUriString(uri);
        this.server.getWSClient().delete(rd);
    }

    protected String getDataSourceUri() {
        return reportUnitDataSourceURI;
    }

    private ResourceDescriptor putReportUnit(ResourceDescriptor rd) throws Exception {
        File resourceFile = null;
        ResourceDescriptor tmpDataSourceDescriptor = new ResourceDescriptor();
        tmpDataSourceDescriptor.setWsType("datasource");
        tmpDataSourceDescriptor.setReferenceUri(this.getDataSourceUri());
        tmpDataSourceDescriptor.setIsReference(true);
        rd.getChildren().add(tmpDataSourceDescriptor);
        ResourceDescriptor jrxmlDescriptor = new ResourceDescriptor();
        jrxmlDescriptor.setWsType("jrxml");
        jrxmlDescriptor.setName("test_jrxml");
        jrxmlDescriptor.setLabel("Main jrxml");
        jrxmlDescriptor.setDescription("Main jrxml");
        jrxmlDescriptor.setIsNew(true);
        jrxmlDescriptor.setHasData(true);
        jrxmlDescriptor.setMainReport(true);
        rd.getChildren().add(jrxmlDescriptor);
        resourceFile = new File(this.getFileResourceURL("test.jrxml"));
        return this.server.getWSClient().addOrModifyResource(rd, resourceFile);
    }

    private String getFileResourceURL(String name) throws FileNotFoundException, UnsupportedEncodingException {
        File f = new File(URLDecoder.decode(this.getClass().getClassLoader().getResource(name).getFile(), "UTF-8"));
        if (!f.exists()) {
            throw new FileNotFoundException();
        }
        return f.getPath();
    }
}

