/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.sample.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class WSServlet
extends HttpServlet {
    public static final String ATTR_WS_USERNAME = "wsUsername";
    public static final String ATTR_PASSWORD = "password";
    public static final String PARAM_PROTOCOL = "protocol";
    public static final String PARAM_HOST = "host";
    public static final String PARAM_PORT = "port";
    public static final String PARAM_APP_NAME = "appName";
    public static final String BASE_WSDL_SOAP_ADDRESS = "/services";

    protected String getBaseAddress(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String wsUsername = (String)session.getAttribute(ATTR_WS_USERNAME);
        String password = (String)session.getAttribute(ATTR_PASSWORD);
        String protocol = this.getServletContext().getInitParameter(PARAM_PROTOCOL);
        String host = this.getServletContext().getInitParameter(PARAM_HOST);
        String port = this.getServletContext().getInitParameter(PARAM_PORT);
        String appName = this.getServletContext().getInitParameter(PARAM_APP_NAME);
        return protocol + wsUsername + ":" + password + "@" + host + ":" + port + "/" + appName + BASE_WSDL_SOAP_ADDRESS;
    }

    protected void forward(String view, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String viewPath = "/" + view;
        RequestDispatcher jsp = request.getRequestDispatcher(viewPath);
        jsp.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void forwardError(Exception e, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        request.setAttribute("message", (Object)e.getMessage());
        request.setAttribute("stackTrace", (Object)sw.toString());
        this.forward("error.jsp", request, response);
    }
}

