/*
 * Decompiled with CFR 0.152.
 */
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;

public class MultiCoreTester {
    private static final int THREADS = 8;
    private static final int CYCLES = 1000000000;
    private static CountDownLatch ct = new CountDownLatch(8);
    private static AtomicLong total = new AtomicLong();

    public static void main(String[] args) throws InterruptedException {
        System.out.println("Working... ");
        long elapsedTime = System.nanoTime();
        for (int i = 0; i < 8; ++i) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    total.addAndGet(MultiCoreTester.measureThreadCpuTime());
                    ct.countDown();
                }
            };
            thread.start();
        }
        ct.await();
        elapsedTime = System.nanoTime() - elapsedTime;
        System.out.println("Total elapsed time " + elapsedTime);
        System.out.println("Total thread CPU time " + total.get());
        double factor = total.get();
        System.out.printf("Factor: %.2f%n", factor /= (double)elapsedTime);
        int cpuReported = Runtime.getRuntime().availableProcessors();
        System.out.println("\nResults:");
        System.out.printf("Java report on CPU count : %d%n", cpuReported);
        System.out.printf("Calculated CPU count : %d%n", Math.round(factor));
    }

    private static long measureThreadCpuTime() {
        ThreadMXBean tm = ManagementFactory.getThreadMXBean();
        long cpuTime = tm.getCurrentThreadCpuTime();
        long total = 0L;
        for (int i = 0; i < 1000000000; ++i) {
            total += (long)i;
            total *= 10L;
        }
        cpuTime = tm.getCurrentThreadCpuTime() - cpuTime;
        System.out.println(total + " ... " + Thread.currentThread() + ": cpuTime = " + cpuTime);
        return cpuTime;
    }
}

