/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.teiid.adminapi.DataPolicy;

public class DataPolicyMetadata
implements DataPolicy,
Serializable {
    private static final long serialVersionUID = -4119646357275977190L;
    protected String name;
    protected String description;
    protected boolean anyAuthenticated;
    protected Boolean allowCreateTemporaryTables;
    protected Map<String, PermissionMetaData> permissions = new HashMap<String, PermissionMetaData>();
    protected Map<String, PermissionMetaData> languagePermissions = new HashMap<String, PermissionMetaData>(2);
    protected List<String> mappedRoleNames = new CopyOnWriteArrayList<String>();

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    @Override
    public List<DataPolicy.DataPermission> getPermissions() {
        ArrayList<DataPolicy.DataPermission> result = new ArrayList<DataPolicy.DataPermission>(this.permissions.values());
        result.addAll(this.languagePermissions.values());
        return result;
    }

    public void setPermissions(List<DataPolicy.DataPermission> permissions) {
        this.permissions.clear();
        for (DataPolicy.DataPermission permission : permissions) {
            this.addPermissionMetadata((PermissionMetaData)permission);
        }
    }

    public void addPermission(PermissionMetaData ... perms) {
        for (PermissionMetaData permission : perms) {
            this.addPermissionMetadata(permission);
        }
    }

    private void addPermissionMetadata(PermissionMetaData permission) {
        PermissionMetaData previous = null;
        previous = permission.getAllowLanguage() != null ? this.languagePermissions.put(permission.getResourceName(), permission) : this.permissions.put(permission.getResourceName().toLowerCase(), permission);
        if (previous != null) {
            permission.bits = (byte)(permission.bits | previous.bits);
            permission.bitsSet = (byte)(permission.bitsSet | previous.bitsSet);
        }
    }

    @Override
    public List<String> getMappedRoleNames() {
        return this.mappedRoleNames;
    }

    public void setMappedRoleNames(List<String> names) {
        this.mappedRoleNames.clear();
        this.mappedRoleNames.addAll(names);
    }

    public void addMappedRoleName(String mappedName) {
        this.mappedRoleNames.add(mappedName);
    }

    public void removeMappedRoleName(String mappedName) {
        this.mappedRoleNames.remove(mappedName);
    }

    public Boolean allows(String resourceName, DataPolicy.PermissionType type) {
        PermissionMetaData p = null;
        p = type == DataPolicy.PermissionType.LANGUAGE ? this.languagePermissions.get(resourceName) : this.permissions.get(resourceName);
        if (p != null) {
            return p.allows(type);
        }
        return null;
    }

    @Override
    public Boolean isAllowCreateTemporaryTables() {
        return this.allowCreateTemporaryTables;
    }

    public void setAllowCreateTemporaryTables(Boolean allowCreateTemporaryTables) {
        this.allowCreateTemporaryTables = allowCreateTemporaryTables;
    }

    @Override
    public boolean isAnyAuthenticated() {
        return this.anyAuthenticated;
    }

    public void setAnyAuthenticated(boolean anyAuthenticated) {
        this.anyAuthenticated = anyAuthenticated;
    }

    public static class PermissionMetaData
    implements DataPolicy.DataPermission,
    Serializable {
        private static final long serialVersionUID = 7034744531663164277L;
        private String resourceName;
        protected byte bits;
        protected byte bitsSet;

        @Override
        public String getResourceName() {
            return this.resourceName;
        }

        public void setResourceName(String value) {
            this.resourceName = value;
        }

        @Override
        public Boolean getAllowCreate() {
            return this.bitSet(1);
        }

        private Boolean bitSet(int bitMask) {
            if ((this.bitsSet & bitMask) == bitMask) {
                if ((this.bits & bitMask) == bitMask) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return null;
        }

        private void setBit(int bitMask, Boolean bool) {
            if (bool == null) {
                this.bitsSet = (byte)(this.bitsSet & ~bitMask);
                this.bits = (byte)(this.bits & ~bitMask);
                return;
            }
            this.bitsSet = (byte)(this.bitsSet | bitMask);
            this.bits = bool != false ? (byte)(this.bits | bitMask) : (byte)(this.bits & ~bitMask);
        }

        public void setAllowCreate(Boolean value) {
            this.setBit(1, value);
        }

        @Override
        public Boolean getAllowRead() {
            return this.bitSet(2);
        }

        public void setAllowRead(Boolean value) {
            this.setBit(2, value);
        }

        @Override
        public Boolean getAllowUpdate() {
            return this.bitSet(4);
        }

        public void setAllowUpdate(Boolean value) {
            this.setBit(4, value);
        }

        @Override
        public Boolean getAllowDelete() {
            return this.bitSet(8);
        }

        public void setAllowDelete(Boolean value) {
            this.setBit(8, value);
        }

        public String getType() {
            StringBuilder sb = new StringBuilder();
            if (Boolean.TRUE.equals(this.getAllowCreate())) {
                sb.append("C");
            }
            if (Boolean.TRUE.equals(this.getAllowRead())) {
                sb.append("R");
            }
            if (Boolean.TRUE.equals(this.getAllowUpdate())) {
                sb.append("U");
            }
            if (Boolean.TRUE.equals(this.getAllowDelete())) {
                sb.append("D");
            }
            if (Boolean.TRUE.equals(this.getAllowExecute())) {
                sb.append("E");
            }
            if (Boolean.TRUE.equals(this.getAllowAlter())) {
                sb.append("A");
            }
            if (Boolean.TRUE.equals(this.getAllowLanguage())) {
                sb.append("L");
            }
            return sb.toString();
        }

        public Boolean allows(DataPolicy.PermissionType type) {
            switch (type) {
                case ALTER: {
                    return this.getAllowAlter();
                }
                case CREATE: {
                    return this.getAllowCreate();
                }
                case EXECUTE: {
                    if (this.getAllowExecute() != null) {
                        return this.getAllowExecute();
                    }
                }
                case READ: {
                    return this.getAllowRead();
                }
                case UPDATE: {
                    return this.getAllowUpdate();
                }
                case DELETE: {
                    return this.getAllowDelete();
                }
                case LANGUAGE: {
                    return this.getAllowLanguage();
                }
            }
            throw new AssertionError();
        }

        @Override
        public Boolean getAllowAlter() {
            return this.bitSet(16);
        }

        @Override
        public Boolean getAllowExecute() {
            return this.bitSet(32);
        }

        public void setAllowAlter(Boolean allowAlter) {
            this.setBit(16, allowAlter);
        }

        public void setAllowExecute(Boolean allowExecute) {
            this.setBit(32, allowExecute);
        }

        @Override
        public Boolean getAllowLanguage() {
            return this.bitSet(64);
        }

        public void setAllowLanguage(Boolean value) {
            this.setBit(64, value);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getResourceName());
            sb.append("[");
            sb.append(this.getType());
            sb.append("]");
            return sb.toString();
        }
    }
}

