/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.logging.diagnostic.service.impl;

import com.jaspersoft.jasperserver.api.logging.diagnostic.domain.DiagnosticAttribute;
import com.jaspersoft.jasperserver.api.logging.diagnostic.helper.DiagnosticAttributeBuilder;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.Diagnostic;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.DiagnosticCallback;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.concurrent.SessionRegistry;

public class SessionRegistryDiagnosticService
implements Diagnostic {
    private SessionRegistry sessionRegistry;

    public Map<DiagnosticAttribute, DiagnosticCallback> getDiagnosticData() {
        return new DiagnosticAttributeBuilder().addDiagnosticAttribute("LoggedInUsersCount", (DiagnosticCallback)new DiagnosticCallback<Integer>(){

            public Integer getDiagnosticAttributeValue() {
                return SessionRegistryDiagnosticService.this.sessionRegistry.getAllPrincipals().length;
            }
        }).addDiagnosticAttribute("LoggedInUsersList", (DiagnosticCallback)new DiagnosticCallback<Map<String, Integer>>(){

            public Map<String, Integer> getDiagnosticAttributeValue() {
                HashMap<String, Integer> sessionsCountForUser = new HashMap<String, Integer>();
                for (Object principle : SessionRegistryDiagnosticService.this.sessionRegistry.getAllPrincipals()) {
                    sessionsCountForUser.put(principle.toString(), SessionRegistryDiagnosticService.this.sessionRegistry.getAllSessions(principle, false).length);
                }
                return sessionsCountForUser;
            }
        }).build();
    }

    public void setSessionRegistry(SessionRegistry sessionRegistry) {
        this.sessionRegistry = sessionRegistry;
    }
}

