/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.RepositorySecurityChecker;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseRepositorySecurityChecker
implements RepositorySecurityChecker {
    private static final Log log = LogFactory.getLog(BaseRepositorySecurityChecker.class);

    @Override
    public void filterResources(List allResources, Map removableResources, Map editableResources) {
        for (Resource res : allResources) {
            this.filterResource(res, removableResources, editableResources);
        }
    }

    @Override
    public void filterResource(Resource resource, Map removableResources, Map editableResources) {
        if (this.isEditable(resource)) {
            editableResources.put(resource.getURIString(), "true");
            log.debug((Object)(resource.getURIString() + ": " + (editableResources.containsKey(resource.getURIString()) ? "EDIT" : "??edit??")));
        }
        if (this.isRemovable(resource)) {
            removableResources.put(resource.getURIString(), "true");
            log.debug((Object)(resource.getURIString() + ": " + (removableResources.containsKey(resource.getURIString()) ? "DELETE" : "??delete??")));
        }
    }
}

