/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.util;

import com.jaspersoft.jasperserver.api.JSException;
import java.util.StringTokenizer;

public class RepositoryUtils {
    public static final String FOLDER_PARENT = "..";
    public static final String FOLDER_CURRENT = ".";

    public static String getParentPath(String path) {
        if (path.equals("/")) {
            return null;
        }
        int lastSep = path.lastIndexOf("/");
        if (lastSep < 0) {
            throw new JSException("Path " + path + " is not an absolute repository path");
        }
        String parentPath = lastSep == 0 ? "/" : path.substring(0, lastSep);
        return parentPath;
    }

    public static String getName(String path) {
        if (path.equals("/")) {
            return "/";
        }
        int lastSep = path.lastIndexOf("/");
        if (lastSep < 0) {
            throw new JSException("Path " + path + " is not an absolute repository path");
        }
        return path.substring(lastSep + 1);
    }

    public static String concatenatePath(String parentPath, String name) {
        StringBuffer concantenated = new StringBuffer(parentPath);
        if (!parentPath.equals("/")) {
            concantenated.append("/");
        }
        concantenated.append(name);
        return concantenated.toString();
    }

    public static String concatenatePaths(String parentPath, String path) {
        StringBuffer concantenated = new StringBuffer();
        if (parentPath.equals("/")) {
            concantenated.append(path);
        } else {
            concantenated.append(parentPath);
            if (!path.equals("/")) {
                concantenated.append(path);
            }
        }
        return concantenated.toString();
    }

    public static boolean isAncestorOrEqual(String ancestorPath, String path) {
        if (ancestorPath.equals(path)) {
            return true;
        }
        if (!path.startsWith(ancestorPath)) {
            return false;
        }
        return "/".equals(ancestorPath) || path.substring(ancestorPath.length()).startsWith("/");
    }

    public static String resolveRelativePath(String contextPath, String path) {
        if (contextPath == null || contextPath.isEmpty() || !contextPath.startsWith("/")) {
            throw new IllegalArgumentException("contextPath needs to be an absolute path");
        }
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("path cannot be empty");
        }
        if (path.startsWith("/")) {
            return path;
        }
        StringBuilder pathBuilder = new StringBuilder(contextPath.length() + path.length() + 1);
        pathBuilder.append(contextPath);
        StringTokenizer pathTokenizer = new StringTokenizer(path, "/");
        while (pathTokenizer.hasMoreTokens()) {
            String pathToken = pathTokenizer.nextToken();
            if (pathToken.equals(FOLDER_PARENT)) {
                if (pathBuilder.length() <= 1) continue;
                int lastPathIndex = pathBuilder.lastIndexOf("/");
                pathBuilder.delete(lastPathIndex == 0 ? 1 : lastPathIndex, pathBuilder.length());
                continue;
            }
            if (pathToken.equals(FOLDER_CURRENT)) continue;
            if (pathBuilder.length() > 1) {
                pathBuilder.append("/");
            }
            pathBuilder.append(pathToken);
        }
        return pathBuilder.toString();
    }
}

