/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.security;

import com.jaspersoft.jasperserver.api.common.util.Functor;
import com.jaspersoft.jasperserver.api.metadata.security.MethodArgumentAclVoter;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.AuthorizationServiceException;
import org.springframework.security.acl.AclEntry;
import org.springframework.security.acl.AclManager;
import org.springframework.security.acl.basic.BasicAclEntry;

public class BasicMethodArgumentVoter
implements MethodArgumentAclVoter {
    private static final Log log = LogFactory.getLog(BasicMethodArgumentVoter.class);
    private Class argumentType;
    private int argumentIndex = 1;
    private int[] accessPermissions;
    private Functor argumentFunctor;

    @Override
    public boolean allow(MethodInvocation methodCall, Authentication authentication, AclManager aclManager) {
        Object secureObject = this.getSecureObject(methodCall);
        return this.accessPermitted(authentication, aclManager, secureObject);
    }

    protected Object getSecureObject(MethodInvocation methodCall) {
        Class<?>[] types = methodCall.getMethod().getParameterTypes();
        int idx = -1;
        int cnt = 0;
        for (int i = 0; i < types.length; ++i) {
            if (!this.argumentType.isAssignableFrom(types[i]) || ++cnt != this.argumentIndex) continue;
            idx = i;
            break;
        }
        if (idx == 0) {
            throw new AuthorizationServiceException("Argument #" + this.argumentIndex + " of type " + this.argumentType + " not found in method " + methodCall.getMethod());
        }
        Object arg = methodCall.getArguments()[idx];
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found argument #" + this.argumentIndex + " of type " + this.argumentType + " in methdo " + methodCall.getMethod() + ": " + arg));
        }
        if (this.argumentFunctor != null) {
            arg = this.argumentFunctor.transform(arg);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Argument transformed to " + arg));
            }
        }
        return arg;
    }

    protected boolean accessPermitted(Authentication authentication, AclManager aclManager, Object secureObject) {
        AclEntry[] acls = aclManager.getAcls(secureObject, authentication);
        boolean permitted = this.accessPermitted(acls);
        if (log.isDebugEnabled()) {
            if (permitted) {
                log.debug((Object)("Access permitted on " + secureObject + " for " + authentication));
            } else {
                log.debug((Object)("Access denied on " + secureObject + " for " + authentication));
            }
        }
        return permitted;
    }

    protected boolean accessPermitted(AclEntry[] acls) {
        boolean matches = false;
        if (acls != null && acls.length > 0) {
            for (int i = 0; i < acls.length; ++i) {
                AclEntry aclEntry = acls[i];
                if (aclEntry instanceof BasicAclEntry) {
                    BasicAclEntry basicAclEntry = (BasicAclEntry)aclEntry;
                    if (!this.accessPermitted(basicAclEntry)) continue;
                    matches = true;
                    break;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Ignoring non BasicAclEntry ACL entry instance " + aclEntry));
            }
        }
        return matches;
    }

    protected boolean accessPermitted(BasicAclEntry basicAclEntry) {
        boolean access = false;
        for (int i = 0; i < this.accessPermissions.length; ++i) {
            if (!basicAclEntry.isPermitted(this.accessPermissions[i])) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("ACL entry " + basicAclEntry + " matched permission " + this.accessPermissions[i] + ", access permitted"));
            }
            access = true;
            break;
        }
        return access;
    }

    public Class getArgumentType() {
        return this.argumentType;
    }

    public void setArgumentType(Class argumentType) {
        this.argumentType = argumentType;
    }

    public int getArgumentIndex() {
        return this.argumentIndex;
    }

    public void setArgumentIndex(int argumentIndex) {
        this.argumentIndex = argumentIndex;
    }

    public int[] getAccessPermissions() {
        return this.accessPermissions;
    }

    public void setAccessPermissions(int[] accessPermissions) {
        this.accessPermissions = accessPermissions;
    }

    public Functor getArgumentFunctor() {
        return this.argumentFunctor;
    }

    public void setArgumentFunctor(Functor argumentFunctor) {
        this.argumentFunctor = argumentFunctor;
    }
}

