/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.service.impl;

import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.TenantQualified;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.acl.AclEntry;
import org.springframework.security.acl.basic.BasicAclEntry;
import org.springframework.security.acl.basic.EffectiveAclsResolver;
import org.springframework.security.userdetails.UserDetails;

public class ObjectPermissionEffectiveAclsResolver
implements EffectiveAclsResolver {
    private static final Log logger = LogFactory.getLog(ObjectPermissionEffectiveAclsResolver.class);

    public AclEntry[] resolveEffectiveAcls(AclEntry[] allAcls, Authentication filteredBy) {
        if (allAcls == null || allAcls.length == 0) {
            return null;
        }
        Vector<AclEntry> list = new Vector<AclEntry>();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Locating AclEntry[]s (from set of " + (allAcls == null ? 0 : allAcls.length) + ") that apply to Authentication: " + filteredBy));
        }
        for (int i = 0; i < allAcls.length; ++i) {
            if (!(allAcls[i] instanceof BasicAclEntry)) continue;
            Object recipient = ((BasicAclEntry)allAcls[i]).getRecipient();
            String recipientName = null;
            String recipientTenant = null;
            if (recipient instanceof Role) {
                recipientName = ((Role)recipient).getRoleName();
                recipientTenant = ((Role)recipient).getTenantId();
            } else if (recipient instanceof User) {
                recipientName = ((User)recipient).getUsername();
                recipientTenant = ((User)recipient).getTenantId();
            }
            if (filteredBy.getPrincipal().equals(recipient)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Principal matches AclEntry recipient: " + recipient));
                }
                list.add(allAcls[i]);
                continue;
            }
            if (filteredBy.getPrincipal() instanceof UserDetails && filteredBy.getPrincipal() instanceof TenantQualified && ((UserDetails)filteredBy.getPrincipal()).getUsername().equals(recipientName)) {
                String filteredTenantId = ((TenantQualified)filteredBy.getPrincipal()).getTenantId();
                if (!(filteredTenantId == null || recipientTenant == null ? recipientTenant == null : filteredTenantId.endsWith(recipientTenant))) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Principal (from UserDetails) matches AclEntry recipient: " + recipient));
                }
                list.add(allAcls[i]);
                continue;
            }
            GrantedAuthority[] authorities = filteredBy.getAuthorities();
            if (authorities == null || authorities.length == 0) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Did not match principal and there are no granted authorities, so cannot compare with recipient: " + recipient));
                continue;
            }
            for (int k = 0; k < authorities.length; ++k) {
                boolean canAddAcls = false;
                if (authorities[k] instanceof TenantQualified) {
                    String tenantId = ((TenantQualified)authorities[k]).getTenantId();
                    canAddAcls = authorities[k].getAuthority().equals(recipientTenant == null ? recipientName : recipientName + "|" + recipientTenant) && (recipientTenant == null ? tenantId == null : recipientTenant.equals(tenantId));
                } else {
                    canAddAcls = authorities[k].getAuthority().equals(recipientName);
                }
                if (!canAddAcls) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("GrantedAuthority: " + authorities[k] + " matches recipient: " + recipient));
                }
                list.add(allAcls[i]);
            }
        }
        if (list.size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Returning effective AclEntry array with " + list.size() + " elements"));
            }
            return list.toArray(new BasicAclEntry[0]);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Returning null AclEntry array as zero effective AclEntrys found");
        }
        return null;
    }
}

