/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.service.impl;

import com.jaspersoft.jasperserver.api.metadata.user.service.impl.RequestAuthenticationToken;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.event.authentication.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.ui.AbstractProcessingFilter;
import org.springframework.security.ui.savedrequest.SavedRequest;
import org.springframework.security.util.PortResolver;
import org.springframework.security.util.PortResolverImpl;
import org.springframework.util.Assert;

public class RequestAuthenticationProcessingFilter
extends AbstractProcessingFilter {
    private static final Log log = LogFactory.getLog(RequestAuthenticationProcessingFilter.class);
    public static final String REQUEST_AUTHENTICATION_ID = "REQUEST_AUTHENTICATION_ID";
    private PortResolver portResolver = new PortResolverImpl();

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.getDefaultTargetUrl(), (String)"defaultTargetUrl must be specified");
        Assert.hasLength((String)this.getAuthenticationFailureUrl(), (String)"authenticationFailureUrl must be specified");
        Assert.notNull((Object)this.getAuthenticationManager(), (String)"authenticationManager must be specified");
        Assert.notNull((Object)this.getRememberMeServices());
    }

    public Authentication attemptAuthentication(HttpServletRequest request) throws AuthenticationException {
        Map requestParameters = this.obtainRequestParameters(request);
        String targetUrl = (String)request.getSession().getAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY");
        if (log.isDebugEnabled()) {
            targetUrl = (String)request.getSession().getAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY");
            log.debug((Object)("Authenticating with values: '" + requestParameters + "'"));
            log.debug((Object)("from URL: " + targetUrl));
        }
        RequestAuthenticationToken authRequest = new RequestAuthenticationToken(requestParameters);
        request.getSession().setAttribute(REQUEST_AUTHENTICATION_ID, (Object)targetUrl);
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        return SecurityContextHolder.getContext().getAuthentication() == null;
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authentication success: " + authResult.toString()));
        }
        SecurityContextHolder.getContext().setAuthentication(authResult);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Updated SecurityContextHolder to contain the following Authentication: '" + authResult + "'"));
        }
        String targetUrl = new SavedRequest(request, this.portResolver).getFullRequestUrl();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Redirecting to target URL from HTTP Session (or default): " + targetUrl));
        }
        this.onSuccessfulAuthentication(request, response, authResult);
        this.getRememberMeServices().loginSuccess(request, response, authResult);
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent((ApplicationEvent)new InteractiveAuthenticationSuccessEvent(authResult, ((Object)((Object)this)).getClass()));
        }
        response.sendRedirect(response.encodeRedirectURL(targetUrl));
    }

    protected Map obtainRequestParameters(HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(request.getParameterMap());
        Enumeration attrs = request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attrName = (String)attrs.nextElement();
            result.put(attrName, request.getAttribute(attrName));
        }
        return result;
    }

    public String getDefaultFilterProcessesUrl() {
        return "/requestAuthentication";
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

