/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security;

import com.jaspersoft.jasperserver.api.JSSecurityException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public final class SecurityConfiguration {
    private static final Logger log = Logger.getLogger(SecurityConfiguration.class);
    private static Properties securityConfig = null;
    private static final String SECURITY_CONFIG = "esapi/security-config.properties";
    private static final String INPUT_FILTER_SWITCH = "security.validation.input.on";
    private static final String CSRF_FILTER_SWITCH = "security.validation.csrf.on";
    private static final String SQL_FILTER_SWITCH = "security.validation.sql.on";
    public static final String SQL_COMMENTS_REGEXP = "security.validation.sql.comments.regexp";
    private static final String ENCRYPTION_FILTER_SWITCH = "encryption.on";
    private static final String MSG_SECURITY_OFF = "log.msg.security.off";
    private static final String LOG_MSG_CANNOT_LOAD = "msg.cannot.load";
    private static final String DYNAMIC_KEY_GENERATION = "encryption.dynamic.key";
    private static final String ENCRYPTION_TYPE = "encryption.type";
    private static final String KEYPAIR_SESSION_KEY = "encryption.keypairSessionKey";
    private static final String KEY_LENGTH = "encryption.key.length";
    private static final String ENCRYPTION_PARAM_PREFIX = "encryption.param.";
    private static final String KEYSTORE_LOCATION = "keystore.location";
    private static final String KEYSTORE_PASSWORD = "keystore.password";
    private static final String KEYSTORE_KEY_ALIAS = "keystore.key.alias";
    private static final String INPUT_VALIDATION = "INPUT-VALIDATION";
    private static final String CSRF = "CSRF";
    private static final String SQL_INJECTION = "SQL-INJECTION";
    private static final String ENCRYPTION = "ENCRYPTION";
    private static final Set<String> encryptedParameters = new HashSet<String>();
    public static final String KEYSTORE_KEY_PASSWORD = "keystore.key.password";

    private SecurityConfiguration() {
    }

    private static void initEncryptedParameters() {
        for (String propName : securityConfig.stringPropertyNames()) {
            if (!propName.startsWith(ENCRYPTION_PARAM_PREFIX)) continue;
            encryptedParameters.add(SecurityConfiguration.getProperty(propName));
        }
    }

    private static synchronized void loadSecurityConfiguration() {
        if (securityConfig == null) {
            securityConfig = new Properties();
            try {
                InputStream is = SecurityConfiguration.class.getClassLoader().getResourceAsStream(SECURITY_CONFIG);
                securityConfig.load(is);
                is.close();
            }
            catch (Exception e) {
                String errMsg = String.format(SecurityConfiguration.getProperty(LOG_MSG_CANNOT_LOAD), SECURITY_CONFIG);
                log.error((Object)errMsg, (Throwable)e);
                throw new JSSecurityException(errMsg, (Throwable)e);
            }
        }
    }

    private static void logSettings() {
        if (!SecurityConfiguration.isInputValidationOn()) {
            SecurityConfiguration.logSecuritySetting(INPUT_VALIDATION);
        }
        if (!SecurityConfiguration.isCSRFValidationOn()) {
            SecurityConfiguration.logSecuritySetting(CSRF);
        }
        if (!SecurityConfiguration.isSQLValidationOn()) {
            SecurityConfiguration.logSecuritySetting(SQL_INJECTION);
        }
        if (!SecurityConfiguration.isEncryptionOn()) {
            SecurityConfiguration.logSecuritySetting(ENCRYPTION);
        }
    }

    public static boolean isEncryptionOn() {
        String encryptioOn = SecurityConfiguration.getProperty(ENCRYPTION_FILTER_SWITCH);
        return encryptioOn == null || !encryptioOn.equalsIgnoreCase("false");
    }

    public static boolean isInputValidationOn() {
        String inputValidationOn = SecurityConfiguration.getProperty(INPUT_FILTER_SWITCH);
        return inputValidationOn == null || !inputValidationOn.equalsIgnoreCase("false");
    }

    public static boolean isCSRFValidationOn() {
        String csrfValidationOn = SecurityConfiguration.getProperty(CSRF_FILTER_SWITCH);
        return csrfValidationOn == null || !csrfValidationOn.equalsIgnoreCase("false");
    }

    public static boolean isSQLValidationOn() {
        String sqlValidationOn = SecurityConfiguration.getProperty(SQL_FILTER_SWITCH);
        return sqlValidationOn == null || !sqlValidationOn.equalsIgnoreCase("false");
    }

    public static String getMsgSecurityOff() {
        return SecurityConfiguration.getProperty(MSG_SECURITY_OFF);
    }

    public static int getEncryptionKeySize() {
        return Integer.parseInt(SecurityConfiguration.getProperty(KEY_LENGTH));
    }

    public static String getEncryptionKeyPairSession() {
        return SecurityConfiguration.getProperty(KEYPAIR_SESSION_KEY);
    }

    public static String getEncryptionType() {
        return SecurityConfiguration.getProperty(ENCRYPTION_TYPE);
    }

    public static Set<String> getEncryptionParameters() {
        return encryptedParameters;
    }

    public static boolean isEncryptionDynamicKeyGeneration() {
        return Boolean.parseBoolean(SecurityConfiguration.getProperty(DYNAMIC_KEY_GENERATION));
    }

    public static String getProperty(String propertyName) {
        return securityConfig.getProperty(propertyName);
    }

    private static void logSecuritySetting(String typeOfValidation) {
        log.warn((Object)String.format(SecurityConfiguration.getProperty(MSG_SECURITY_OFF), typeOfValidation));
    }

    public static String getKeystoreLocation() {
        return SecurityConfiguration.getProperty(KEYSTORE_LOCATION);
    }

    public static String getKeystorePassword() {
        return SecurityConfiguration.getProperty(KEYSTORE_PASSWORD);
    }

    public static String getKeystoreKeyAlias() {
        return SecurityConfiguration.getProperty(KEYSTORE_KEY_ALIAS);
    }

    public static String getKeystoreKeyPassword() {
        return SecurityConfiguration.getProperty(KEYSTORE_KEY_PASSWORD);
    }

    static {
        SecurityConfiguration.loadSecurityConfiguration();
        SecurityConfiguration.logSettings();
        SecurityConfiguration.initEncryptedParameters();
    }
}

