/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security.encryption;

import com.jaspersoft.jasperserver.api.security.encryption.Encryption;
import com.jaspersoft.jasperserver.core.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class EncryptionRSA
implements Encryption {
    private static final Pattern SPLIT_BY_WHITESPACE = Pattern.compile("\\s");
    private static final Pattern SPLIT_BY_AMPERSAND = Pattern.compile("&");
    private static final Pattern SPLIT_BY_EQUALITY = Pattern.compile("=");
    public static final int RADIX_16 = 16;

    public KeyPair generateKeypair(int keyLength) {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(keyLength);
            return kpg.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("RSA algorithm not supported", e);
        }
    }

    public String decrypt(String encrypted, PrivateKey privateKey) {
        Cipher dec;
        try {
            dec = Cipher.getInstance("RSA/NONE/NoPadding", (Provider)new BouncyCastleProvider());
            dec.init(2, privateKey);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("RSA algorithm not supported", e);
        }
        String[] blocks = SPLIT_BY_WHITESPACE.split(encrypted);
        StringBuilder result = new StringBuilder();
        try {
            for (int i = blocks.length - 1; i >= 0; --i) {
                byte[] data = StringUtil.hexStringToByteArray((String)blocks[i]);
                byte[] decryptedBlock = dec.doFinal(data);
                result.append(new String(decryptedBlock));
            }
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Decrypt error", e);
        }
        return result.toString();
    }

    public static Map<String, Object> parse(String url, String encoding) {
        try {
            String urlToParse = URLDecoder.decode(url, encoding);
            return EncryptionRSA.parseEncryptedData(urlToParse);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unknown encoding.", e);
        }
    }

    public static Map<String, Object> parseEncryptedData(String data) {
        String[] params = SPLIT_BY_AMPERSAND.split(data);
        HashMap<String, Object> parsed = new HashMap<String, Object>();
        for (String param : params) {
            String value;
            String[] p = SPLIT_BY_EQUALITY.split(param);
            String name = p.length > 0 ? p[0] : null;
            String string = value = p.length > 1 ? p[1] : "";
            if (name == null) continue;
            if (parsed.containsKey(name)) {
                Object existingValue = parsed.get(name);
                if (existingValue instanceof String[]) {
                    String[] existingValues = (String[])existingValue;
                    String[] combinedValues = new String[existingValues.length + 1];
                    System.arraycopy(existingValues, 0, combinedValues, 0, existingValues.length);
                    combinedValues[existingValues.length] = value;
                    parsed.put(name, combinedValues);
                    continue;
                }
                parsed.put(name, new String[]{(String)existingValue, value});
                continue;
            }
            parsed.put(name, value);
        }
        return parsed;
    }

    public static String getPublicKeyModulus(PublicKey key) {
        return ((RSAPublicKey)key).getModulus().toString(16);
    }

    public static String getPublicKeyExponent(PublicKey key) {
        return ((RSAPublicKey)key).getPublicExponent().toString(16);
    }

    public static int getMaxDigits(int keyLength) {
        return keyLength * 2 / 16 + 3;
    }
}

