/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jboss.as.cli.gui.CommandExecutor;
import org.jboss.as.cli.gui.GuiMain;
import org.jboss.dmr.ModelNode;

public class DoOperationActionListener
extends AbstractAction {
    private CommandExecutor executor;
    private JTextField cmdText;
    private JTextComponent output;
    private JTabbedPane tabs;
    private LinkedList<String> cmdHistory = new LinkedList();

    public DoOperationActionListener(JTextComponent output, JTabbedPane tabs) {
        this.executor = GuiMain.getExecutor();
        this.cmdText = GuiMain.getCommandText();
        this.output = output;
        this.tabs = tabs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = this.cmdText.getText();
        try {
            this.cmdHistory.push(command);
            ModelNode result = this.executor.doCommand(command);
            this.postOutput(command, result.toString());
        }
        catch (Exception e) {
            try {
                this.postOutput(command, e.getMessage());
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
        finally {
            this.tabs.setSelectedIndex(1);
        }
    }

    public List getCmdHistory() {
        return Collections.unmodifiableList(this.cmdHistory);
    }

    private void postOutput(String command, String response) throws BadLocationException {
        this.processOutput(response + "\n\n", null);
        this.processBoldOutput(command + "\n");
    }

    private void processBoldOutput(String text) throws BadLocationException {
        SimpleAttributeSet attribs = new SimpleAttributeSet();
        StyleConstants.setBold(attribs, true);
        this.processOutput(text, attribs);
    }

    private void processOutput(String text, AttributeSet attribs) throws BadLocationException {
        Document doc = this.output.getDocument();
        doc.insertString(0, text, attribs);
        this.output.setCaretPosition(0);
    }
}

