/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JTree;
import org.jboss.as.cli.gui.CommandExecutor;
import org.jboss.as.cli.gui.GuiMain;
import org.jboss.as.cli.gui.ManagementModelNode;
import org.jboss.as.cli.gui.OperationDialog;
import org.jboss.dmr.ModelNode;

public class OperationMenu
extends JPopupMenu {
    private static final String[] genericOps = new String[]{"add", "read-operation-description", "read-resource-description", "read-operation-names"};
    private static final List<String> genericOpList = Arrays.asList(genericOps);
    private static final String[] leafOps = new String[]{"write-attribute", "undefine-attribute"};
    private static final List<String> leafOpList = Arrays.asList(leafOps);
    private CommandExecutor executor;
    private JTree invoker;
    private JTextField cmdText;

    public OperationMenu(CommandExecutor executor, JTree invoker, JTextField cmdText) {
        this.executor = executor;
        this.invoker = invoker;
        this.cmdText = cmdText;
        this.setLightWeightPopupEnabled(true);
        this.setOpaque(true);
    }

    public void show(ManagementModelNode node, int x, int y) {
        this.removeAll();
        String addressPath = node.addressPath();
        try {
            ModelNode opNames = this.executor.doCommand(addressPath + ":read-operation-names");
            if (opNames.get("outcome").asString().equals("failed")) {
                return;
            }
            for (ModelNode name : opNames.get("result").asList()) {
                String strName = name.asString();
                if (node.isGeneric() && !genericOpList.contains(strName) || node.isLeaf() && !leafOpList.contains(strName) || !node.isGeneric() && !node.isLeaf() && strName.equals("add")) continue;
                ModelNode opDescription = this.getResourceDescription(addressPath, strName);
                this.add(new OperationAction(node, strName, opDescription));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.show(this.invoker, x, y);
    }

    private ModelNode getResourceDescription(String addressPath, String name) {
        try {
            return this.executor.doCommand(addressPath + ":read-operation-description(name=\"" + name + "\")");
        }
        catch (Exception e) {
            return null;
        }
    }

    private class OperationAction
    extends AbstractAction {
        private ManagementModelNode node;
        private String opName;
        private String addressPath;
        private ModelNode opDescription;
        private String strDescription;

        public OperationAction(ManagementModelNode node, String opName, ModelNode opDescription) {
            super(opName);
            this.node = node;
            this.opName = opName;
            this.addressPath = node.addressPath();
            this.opDescription = opDescription;
            if (opDescription != null) {
                this.strDescription = opDescription.get(new String[]{"result", "description"}).asString();
                this.putValue("ShortDescription", this.strDescription);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ModelNode requestProperties = this.opDescription.get(new String[]{"result", "request-properties"});
            if (requestProperties == null || !requestProperties.isDefined() || requestProperties.asList().isEmpty()) {
                OperationMenu.this.cmdText.setText(this.addressPath + ":" + this.opName);
                OperationMenu.this.cmdText.requestFocus();
                return;
            }
            if (this.node.isLeaf() && this.opName.equals("undefine-attribute")) {
                ManagementModelNode.UserObject usrObj = (ManagementModelNode.UserObject)this.node.getUserObject();
                OperationMenu.this.cmdText.setText(this.addressPath + ":" + this.opName + "(name=" + usrObj.getName() + ")");
                OperationMenu.this.cmdText.requestFocus();
                return;
            }
            OperationDialog dialog = new OperationDialog(this.node, this.opName, this.strDescription, requestProperties);
            dialog.setLocationRelativeTo(GuiMain.getFrame());
            dialog.setVisible(true);
        }
    }
}

