/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.tomcat.jndi;

import com.jaspersoft.jasperserver.crypto.EncryptionEngine;
import com.jaspersoft.jasperserver.crypto.KeystoreManager;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import org.apache.commons.codec.binary.Base64;
import org.apache.tomcat.dbcp.dbcp.BasicDataSource;
import org.apache.tomcat.dbcp.dbcp.BasicDataSourceFactory;

public class JSBasicDataSourceFactory
extends BasicDataSourceFactory {
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        Object object2 = super.getObjectInstance(object, name, context, hashtable);
        if (object2 != null) {
            BasicDataSource basicDataSource = (BasicDataSource)object2;
            String string = basicDataSource.getPassword();
            if (string != null && !string.isEmpty()) {
                if (EncryptionEngine.isEncrypted(string = string.trim())) {
                    KeystoreManager keystoreManager = KeystoreManager.getInstance();
                    string = EncryptionEngine.decrypt(keystoreManager.getBuildKey(), string);
                    basicDataSource.setPassword(string);
                } else if (string.startsWith("B-") && string.endsWith("-")) {
                    string = new String(Base64.decodeBase64((String)string.replaceFirst("B-", "").replace("-$", "")), "UTF-8");
                    basicDataSource.setPassword(string);
                }
            }
            return basicDataSource;
        }
        return null;
    }
}

