/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import org.teiid.core.types.DataTypeManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Datatype;
import org.teiid.translator.TypeFacility;

public abstract class BaseColumn
extends AbstractMetadataRecord {
    private static final long serialVersionUID = 6382258617714856616L;
    private String datatypeUUID;
    private String runtimeType;
    private String defaultValue;
    private int length;
    private int scale;
    private int radix;
    private int precision;
    private NullType nullType;
    private int position;
    private Datatype datatype;

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDatatypeUUID() {
        return this.datatypeUUID;
    }

    public String getRuntimeType() {
        return this.runtimeType;
    }

    public Class<?> getJavaType() {
        return TypeFacility.getDataTypeClass(this.runtimeType);
    }

    public int getLength() {
        return this.length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public int getRadix() {
        return this.radix;
    }

    public int getPosition() {
        return this.position;
    }

    public NullType getNullType() {
        if (this.nullType == null) {
            return NullType.Unknown;
        }
        return this.nullType;
    }

    public void setLength(int i) {
        this.length = i;
    }

    public void setPrecision(int i) {
        this.precision = i;
    }

    public void setScale(int i) {
        this.scale = i;
    }

    public void setRadix(int i) {
        this.radix = i;
    }

    public void setNullType(NullType i) {
        this.nullType = i;
    }

    public void setPosition(int i) {
        this.position = i;
    }

    public void setRuntimeType(String string) {
        this.runtimeType = DataTypeManager.getCanonicalString((String)string);
    }

    public void setDatatypeUUID(String string) {
        this.datatypeUUID = DataTypeManager.getCanonicalString((String)string);
    }

    public void setDefaultValue(String object) {
        this.defaultValue = DataTypeManager.getCanonicalString((String)object);
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public void setDatatype(Datatype datatype) {
        this.setDatatype(datatype, false);
    }

    public void setDatatype(Datatype datatype, boolean copyAttributes) {
        this.datatype = datatype;
        if (datatype != null) {
            this.datatypeUUID = this.datatype.getUUID();
            this.runtimeType = this.datatype.getRuntimeTypeName();
            if (copyAttributes) {
                this.radix = this.datatype.getRadix();
                this.length = this.datatype.getLength();
                this.precision = this.datatype.getPrecision();
                this.scale = this.datatype.getScale();
                this.nullType = this.datatype.getNullType();
            }
        }
    }

    public static enum NullType {
        No_Nulls{

            public String toString() {
                return "No Nulls";
            }
        }
        ,
        Nullable,
        Unknown;

    }
}

