/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.service.BeanForInterfaceFactory;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class BeanForInterfaceFactoryImpl
implements BeanForInterfaceFactory,
ApplicationContextAware {
    private static final Log log = LogFactory.getLog(BeanForInterfaceFactoryImpl.class);
    private ApplicationContext ctx;
    private final Comparator itfComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Class itf1 = (Class)o1;
            Class itf2 = (Class)o2;
            if (itf1.equals(itf2)) {
                return 0;
            }
            if (itf2.isAssignableFrom(itf1)) {
                return -1;
            }
            if (itf1.isAssignableFrom(itf2)) {
                return 1;
            }
            return itf1.getName().compareTo(itf2.getName());
        }
    };

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public String getBeanName(Map interfaceToBeanMappings, Class itfClass) {
        if (interfaceToBeanMappings == null) {
            return null;
        }
        try {
            TreeSet interfaces = new TreeSet(this.itfComparator);
            for (String itfName : interfaceToBeanMappings.keySet()) {
                Class<?> itf = Class.forName(itfName, true, Thread.currentThread().getContextClassLoader());
                if (!itf.isAssignableFrom(itfClass)) continue;
                interfaces.add(itf);
            }
            if (!interfaces.isEmpty()) {
                Class itf = (Class)interfaces.iterator().next();
                return (String)interfaceToBeanMappings.get(itf.getName());
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    public Object getBean(Map classToBeanMappings, Class _class) {
        String beanName = this.getBeanName(classToBeanMappings, _class);
        if (beanName == null) {
            throw new JSException("jsexception.bean.name.not.found.for.interface", new Object[]{_class.getName()});
        }
        Object bean = this.ctx.getBean(beanName);
        if (bean == null) {
            throw new JSException("jsexception.bean.no.name", new Object[]{beanName});
        }
        return bean;
    }

    public boolean hasMapping(Map classToBeanMappings, Class _class) {
        if (classToBeanMappings == null) {
            return false;
        }
        try {
            boolean found = false;
            for (String itfName : classToBeanMappings.keySet()) {
                Class<?> itf = Class.forName(itfName, true, Thread.currentThread().getContextClassLoader());
                if (!itf.isAssignableFrom(_class)) continue;
                found = true;
                break;
            }
            return found;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }
}

