/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql;

import java.util.EnumSet;
import java.util.Set;

public enum MySQLServerCapabilities {
    LONG_PASSWORD(1),
    FOUND_ROWS(2),
    LONG_FLAG(4),
    CONNECT_WITH_DB(8),
    NO_SCHEMA(16),
    COMPRESS(32),
    ODBC(64),
    LOCAL_FILES(128),
    IGNORE_SPACE(256),
    CLIENT_PROTOCOL_41(512),
    CLIENT_INTERACTIVE(1024),
    SSL(2048),
    IGNORE_SIGPIPE(4096),
    TRANSACTIONS(8192),
    RESERVED(16384),
    SECURE_CONNECTION(32768),
    MULTI_STATEMENTS(65536),
    MULTI_RESULTS(131072),
    PLUGIN_AUTH(524288),
    PROGRESS(0x20000000);

    private final int bitmapFlag;

    private MySQLServerCapabilities(int i) {
        this.bitmapFlag = i;
    }

    public static Set<MySQLServerCapabilities> getServerCapabilitiesSet(short i) {
        EnumSet<MySQLServerCapabilities> statusSet = EnumSet.noneOf(MySQLServerCapabilities.class);
        for (MySQLServerCapabilities value : MySQLServerCapabilities.values()) {
            if ((i & value.getBitmapFlag()) != value.getBitmapFlag()) continue;
            statusSet.add(value);
        }
        return statusSet;
    }

    public int getBitmapFlag() {
        return this.bitmapFlag;
    }

    public static int fromSet(Set<MySQLServerCapabilities> capabilities) {
        int retVal = 0;
        for (MySQLServerCapabilities cap : capabilities) {
            retVal |= cap.getBitmapFlag();
        }
        return retVal;
    }
}

