/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.virtualization;

import java.io.IOException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.virtualization.ObjectSerializer;
import net.sf.jasperreports.engine.virtualization.ReferenceType;
import net.sf.jasperreports.engine.virtualization.VirtualizationInput;
import net.sf.jasperreports.engine.virtualization.VirtualizationOutput;

public class BooleanSerializer
implements ObjectSerializer<Boolean> {
    @Override
    public int typeValue() {
        return 24;
    }

    @Override
    public ReferenceType defaultReferenceType() {
        return ReferenceType.OBJECT;
    }

    @Override
    public boolean defaultStoreReference() {
        return false;
    }

    @Override
    public void write(Boolean value, VirtualizationOutput out) throws IOException {
        out.writeByte(value != false ? 1 : 0);
    }

    @Override
    public Boolean read(VirtualizationInput in) throws IOException {
        byte byteValue = in.readByte();
        if (byteValue != 0 && byteValue != 1) {
            throw new JRRuntimeException("Unexpected boolean byte value " + byteValue);
        }
        return byteValue == 1;
    }
}

