/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRGanttDataset;
import net.sf.jasperreports.charts.JRGanttSeries;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRItemLabel;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRMultiAxisPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.charts.type.PlotOrientationEnum;
import net.sf.jasperreports.charts.type.TimePeriodEnum;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.type.CrosstabColumnPositionEnum;
import net.sf.jasperreports.crosstabs.type.CrosstabPercentageEnum;
import net.sf.jasperreports.crosstabs.type.CrosstabRowPositionEnum;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGenericElement;
import net.sf.jasperreports.engine.JRGenericElementParameter;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReturnValue;
import net.sf.jasperreports.engine.analytics.dataset.BucketOrder;
import net.sf.jasperreports.engine.analytics.dataset.DataAxis;
import net.sf.jasperreports.engine.analytics.dataset.DataAxisLevel;
import net.sf.jasperreports.engine.analytics.dataset.DataLevelBucket;
import net.sf.jasperreports.engine.analytics.dataset.DataLevelBucketProperty;
import net.sf.jasperreports.engine.analytics.dataset.DataMeasure;
import net.sf.jasperreports.engine.analytics.dataset.MultiAxisData;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentXmlWriter;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;
import net.sf.jasperreports.engine.type.BreakTypeEnum;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.FooterPositionEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.PositionTypeEnum;
import net.sf.jasperreports.engine.type.PrintOrderEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import net.sf.jasperreports.engine.type.SortOrderEnum;
import net.sf.jasperreports.engine.type.SplitTypeEnum;
import net.sf.jasperreports.engine.type.StretchTypeEnum;
import net.sf.jasperreports.engine.type.WhenNoDataTypeEnum;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.util.XmlNamespace;
import net.sf.jasperreports.engine.xml.JRXmlBaseWriter;
import net.sf.jasperreports.engine.xml.XmlWriterVisitor;

public class JRXmlWriter
extends JRXmlBaseWriter {
    public static final XmlNamespace JASPERREPORTS_NAMESPACE = new XmlNamespace("http://jasperreports.sourceforge.net/jasperreports", null, "http://jasperreports.sourceforge.net/xsd/jasperreport.xsd");
    private JasperReportsContext jasperReportsContext;
    private JRReport report;
    private String encoding;
    private XmlWriterVisitor xmlWriterVisitor = new XmlWriterVisitor(this);

    public JRXmlWriter(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    protected JRXmlWriter(JRReport report, String encoding) {
        this.report = report;
        this.encoding = encoding;
    }

    public JRReport getReport() {
        return this.report;
    }

    public String write(JRReport report, String encoding) {
        StringWriter buffer = new StringWriter();
        try {
            this.writeReport(report, encoding, buffer);
        }
        catch (IOException e) {
            throw new JRRuntimeException("Error writing report design.", e);
        }
        return buffer.toString();
    }

    public void write(JRReport report, String destFileName, String encoding) throws JRException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(destFileName);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, encoding);
            this.writeReport(report, encoding, out);
        }
        catch (IOException e) {
            throw new JRException("Error writing to file : " + destFileName, e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void write(JRReport report, OutputStream outputStream, String encoding) throws JRException {
        try {
            OutputStreamWriter out = new OutputStreamWriter(outputStream, encoding);
            this.writeReport(report, encoding, out);
        }
        catch (Exception e) {
            throw new JRException("Error writing to OutputStream : " + report.getName(), e);
        }
    }

    public static String writeReport(JRReport report, String encoding) {
        return new JRXmlWriter(DefaultJasperReportsContext.getInstance()).write(report, encoding);
    }

    public static void writeReport(JRReport report, String destFileName, String encoding) throws JRException {
        new JRXmlWriter(DefaultJasperReportsContext.getInstance()).write(report, destFileName, encoding);
    }

    public static void writeReport(JRReport report, OutputStream outputStream, String encoding) throws JRException {
        new JRXmlWriter(DefaultJasperReportsContext.getInstance()).write(report, outputStream, encoding);
    }

    protected void writeReport(JRReport report, String encoding, Writer out) throws IOException {
        JRSection detail;
        JRDataset[] datasets;
        this.report = report;
        String version = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(report, "net.sf.jasperreports.report.version");
        this.useWriter(new JRXmlWriteHelper(out), version);
        this.writer.writeProlog(encoding);
        this.writer.startElement("jasperReport", this.getNamespace());
        this.writer.addEncodedAttribute("name", report.getName());
        this.writer.addEncodedAttribute("language", report.getLanguage(), "java");
        this.writer.addAttribute("columnCount", report.getColumnCount(), 1);
        this.writer.addAttribute("printOrder", report.getPrintOrderValue(), PrintOrderEnum.VERTICAL);
        if (this.isNewerVersionOrEqual("3.7.5")) {
            this.writer.addAttribute("columnDirection", report.getColumnDirection(), RunDirectionEnum.LTR);
        }
        this.writer.addAttribute("pageWidth", report.getPageWidth());
        this.writer.addAttribute("pageHeight", report.getPageHeight());
        this.writer.addAttribute("orientation", report.getOrientationValue(), OrientationEnum.PORTRAIT);
        this.writer.addAttribute("whenNoDataType", report.getWhenNoDataTypeValue(), WhenNoDataTypeEnum.NO_PAGES);
        this.writer.addAttribute("columnWidth", report.getColumnWidth());
        this.writer.addAttribute("columnSpacing", report.getColumnSpacing(), 0);
        this.writer.addAttribute("leftMargin", report.getLeftMargin());
        this.writer.addAttribute("rightMargin", report.getRightMargin());
        this.writer.addAttribute("topMargin", report.getTopMargin());
        this.writer.addAttribute("bottomMargin", report.getBottomMargin());
        this.writer.addAttribute("isTitleNewPage", report.isTitleNewPage(), false);
        this.writer.addAttribute("isSummaryNewPage", report.isSummaryNewPage(), false);
        if (this.isNewerVersionOrEqual("3.6.1")) {
            this.writer.addAttribute("isSummaryWithPageHeaderAndFooter", report.isSummaryWithPageHeaderAndFooter(), false);
        }
        this.writer.addAttribute("isFloatColumnFooter", report.isFloatColumnFooter(), false);
        this.writer.addAttribute("scriptletClass", report.getScriptletClass());
        this.writer.addAttribute("formatFactoryClass", report.getFormatFactoryClass());
        this.writer.addEncodedAttribute("resourceBundle", report.getResourceBundle());
        this.writer.addAttribute("whenResourceMissingType", report.getWhenResourceMissingTypeValue(), WhenResourceMissingTypeEnum.NULL);
        this.writer.addAttribute("isIgnorePagination", report.isIgnorePagination(), false);
        if (this.isNewerVersionOrEqual("4.6.0")) {
            this.writer.addAttribute("uuid", report.getUUID().toString());
        }
        this.writeProperties(report);
        String[] imports = report.getImports();
        if (imports != null && imports.length > 0) {
            for (int i = 0; i < imports.length; ++i) {
                String value = imports[i];
                if (value == null) continue;
                this.writer.startElement("import");
                this.writer.addEncodedAttribute("value", value);
                this.writer.closeElement();
            }
        }
        this.writeTemplates(report);
        JRStyle[] styles = report.getStyles();
        if (styles != null && styles.length > 0) {
            for (int i = 0; i < styles.length; ++i) {
                this.writeStyle(styles[i]);
            }
        }
        if ((datasets = report.getDatasets()) != null && datasets.length > 0) {
            for (int i = 0; i < datasets.length; ++i) {
                this.writeDataset(datasets[i]);
            }
        }
        this.writeDatasetContents(report.getMainDataset());
        if (report.getBackground() != null) {
            this.writer.startElement("background");
            this.writeBand(report.getBackground());
            this.writer.closeElement();
        }
        if (report.getTitle() != null) {
            this.writer.startElement("title");
            this.writeBand(report.getTitle());
            this.writer.closeElement();
        }
        if (report.getPageHeader() != null) {
            this.writer.startElement("pageHeader");
            this.writeBand(report.getPageHeader());
            this.writer.closeElement();
        }
        if (report.getColumnHeader() != null) {
            this.writer.startElement("columnHeader");
            this.writeBand(report.getColumnHeader());
            this.writer.closeElement();
        }
        if ((detail = report.getDetailSection()) != null) {
            this.writer.startElement("detail");
            this.writeSection(detail);
            this.writer.closeElement(true);
        }
        if (report.getColumnFooter() != null) {
            this.writer.startElement("columnFooter");
            this.writeBand(report.getColumnFooter());
            this.writer.closeElement();
        }
        if (report.getPageFooter() != null) {
            this.writer.startElement("pageFooter");
            this.writeBand(report.getPageFooter());
            this.writer.closeElement();
        }
        if (report.getLastPageFooter() != null) {
            this.writer.startElement("lastPageFooter");
            this.writeBand(report.getLastPageFooter());
            this.writer.closeElement();
        }
        if (report.getSummary() != null) {
            this.writer.startElement("summary");
            this.writeBand(report.getSummary());
            this.writer.closeElement();
        }
        if (report.getNoData() != null) {
            this.writer.startElement("noData");
            this.writeBand(report.getNoData());
            this.writer.closeElement();
        }
        this.writer.closeElement();
        out.flush();
    }

    protected void writeReport(Writer out) throws IOException {
        this.writeReport(this.report, this.encoding, out);
    }

    public void writeProperties(JRPropertiesHolder propertiesHolder) throws IOException {
        JRPropertiesMap propertiesMap;
        String[] propertyNames;
        if (propertiesHolder.hasProperties() && (propertyNames = (propertiesMap = propertiesHolder.getPropertiesMap()).getPropertyNames()) != null && propertyNames.length > 0) {
            for (int i = 0; i < propertyNames.length; ++i) {
                this.writer.startElement("property", this.getNamespace());
                this.writer.addEncodedAttribute("name", propertyNames[i]);
                String value = propertiesMap.getProperty(propertyNames[i]);
                if (value != null) {
                    this.writer.addEncodedAttribute("value", value);
                }
                this.writer.closeElement();
            }
        }
    }

    protected void writeTemplates(JRReport report) throws IOException {
        JRReportTemplate[] templates = report.getTemplates();
        if (templates != null) {
            for (int i = 0; i < templates.length; ++i) {
                JRReportTemplate template = templates[i];
                this.writeTemplate(template);
            }
        }
    }

    protected void writeTemplates() throws IOException {
        this.writeTemplates(this.report);
    }

    protected void writeTemplate(JRReportTemplate template) throws IOException {
        this.writeExpression("template", template.getSourceExpression(), true, String.class.getName());
    }

    private void writeScriptlet(JRScriptlet scriptlet) throws IOException {
        if (this.isNewerVersionOrEqual("3.1.4")) {
            this.writer.startElement("scriptlet");
            this.writer.addEncodedAttribute("name", scriptlet.getName());
            this.writer.addAttribute("class", scriptlet.getValueClassName());
            this.writeProperties(scriptlet);
            this.writer.writeCDATAElement("scriptletDescription", scriptlet.getDescription());
            this.writer.closeElement();
        }
    }

    private void writeParameter(JRParameter parameter) throws IOException {
        this.writer.startElement("parameter");
        this.writer.addEncodedAttribute("name", parameter.getName());
        this.writer.addAttribute("class", parameter.getValueClassName());
        if (this.isNewerVersionOrEqual("3.1.4")) {
            this.writer.addAttribute("nestedType", parameter.getNestedTypeName());
        }
        this.writer.addAttribute("isForPrompting", parameter.isForPrompting(), true);
        this.writeProperties(parameter);
        this.writer.writeCDATAElement("parameterDescription", parameter.getDescription());
        this.writeExpression("defaultValueExpression", parameter.getDefaultValueExpression(), false);
        this.writer.closeElement();
    }

    private void writeQuery(JRQuery query) throws IOException {
        this.writer.startElement("queryString");
        this.writer.addEncodedAttribute("language", query.getLanguage(), "sql");
        this.writer.writeCDATA(query.getText());
        this.writer.closeElement();
    }

    private void writeField(JRField field) throws IOException {
        this.writer.startElement("field");
        this.writer.addEncodedAttribute("name", field.getName());
        this.writer.addAttribute("class", field.getValueClassName());
        this.writeProperties(field);
        this.writer.writeCDATAElement("fieldDescription", field.getDescription());
        this.writer.closeElement();
    }

    private void writeSortField(JRSortField sortField) throws IOException {
        this.writer.startElement("sortField");
        this.writer.addEncodedAttribute("name", sortField.getName());
        this.writer.addAttribute("order", sortField.getOrderValue(), SortOrderEnum.ASCENDING);
        if (this.isNewerVersionOrEqual("3.7.5")) {
            this.writer.addAttribute("type", sortField.getType(), SortFieldTypeEnum.FIELD);
        }
        this.writer.closeElement();
    }

    private void writeVariable(JRVariable variable) throws IOException {
        this.writer.startElement("variable");
        this.writer.addEncodedAttribute("name", variable.getName());
        this.writer.addAttribute("class", variable.getValueClassName());
        this.writer.addAttribute("resetType", variable.getResetTypeValue(), ResetTypeEnum.REPORT);
        if (variable.getResetGroup() != null) {
            this.writer.addEncodedAttribute("resetGroup", variable.getResetGroup().getName());
        }
        this.writer.addAttribute("incrementType", variable.getIncrementTypeValue(), IncrementTypeEnum.NONE);
        if (variable.getIncrementGroup() != null) {
            this.writer.addEncodedAttribute("incrementGroup", variable.getIncrementGroup().getName());
        }
        this.writer.addAttribute("calculation", variable.getCalculationValue(), CalculationEnum.NOTHING);
        this.writer.addAttribute("incrementerFactoryClass", variable.getIncrementerFactoryClassName());
        this.writeExpression("variableExpression", variable.getExpression(), false);
        this.writeExpression("initialValueExpression", variable.getInitialValueExpression(), false);
        this.writer.closeElement();
    }

    private void writeGroup(JRGroup group) throws IOException {
        JRSection groupFooter;
        this.writer.startElement("group");
        this.writer.addEncodedAttribute("name", group.getName());
        this.writer.addAttribute("isStartNewColumn", group.isStartNewColumn(), false);
        this.writer.addAttribute("isStartNewPage", group.isStartNewPage(), false);
        this.writer.addAttribute("isResetPageNumber", group.isResetPageNumber(), false);
        this.writer.addAttribute("isReprintHeaderOnEachPage", group.isReprintHeaderOnEachPage(), false);
        this.writer.addAttributePositive("minHeightToStartNewPage", group.getMinHeightToStartNewPage());
        if (this.isNewerVersionOrEqual("3.6.2")) {
            this.writer.addAttribute("footerPosition", group.getFooterPositionValue(), FooterPositionEnum.NORMAL);
            this.writer.addAttribute("keepTogether", group.isKeepTogether(), false);
        }
        this.writeExpression("groupExpression", group.getExpression(), false);
        JRSection groupHeader = group.getGroupHeaderSection();
        if (groupHeader != null) {
            this.writer.startElement("groupHeader");
            this.writeSection(groupHeader);
            this.writer.closeElement(true);
        }
        if ((groupFooter = group.getGroupFooterSection()) != null) {
            this.writer.startElement("groupFooter");
            this.writeSection(groupFooter);
            this.writer.closeElement(true);
        }
        this.writer.closeElement();
    }

    protected void writeSection(JRSection section) throws IOException {
        JRBand[] bands;
        if (section != null && (bands = section.getBands()) != null && bands.length > 0) {
            if (this.isNewerVersionOrEqual("3.5.2")) {
                for (int i = 0; i < bands.length; ++i) {
                    this.writeBand(bands[i]);
                }
            } else {
                this.writeBand(bands[0]);
            }
        }
    }

    private void writeBand(JRBand band) throws IOException {
        this.writer.startElement("band");
        this.writer.addAttributePositive("height", band.getHeight());
        if (this.isNewerVersionOrEqual("3.5.2")) {
            this.writer.addAttribute("splitType", band.getSplitTypeValue());
        } else {
            this.writer.addAttribute("isSplitAllowed", band.getSplitTypeValue() != SplitTypeEnum.PREVENT, true);
        }
        if (this.isNewerVersionOrEqual("4.8.0")) {
            this.writeProperties(band);
        }
        this.writeExpression("printWhenExpression", band.getPrintWhenExpression(), false);
        this.writeChildElements(band);
        this.writer.closeElement();
    }

    public void writeChildElements(JRElementGroup elementContainer) {
        List<JRChild> children = elementContainer.getChildren();
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                children.get(i).visit(this.xmlWriterVisitor);
            }
        }
    }

    public void writeElementGroup(JRElementGroup elementGroup) throws IOException {
        this.writer.startElement("elementGroup", this.getNamespace());
        this.writeChildElements(elementGroup);
        this.writer.closeElement();
    }

    public void writeBreak(JRBreak breakElement) throws IOException {
        this.writer.startElement("break", this.getNamespace());
        this.writer.addAttribute("type", breakElement.getTypeValue(), BreakTypeEnum.PAGE);
        this.writeReportElement(breakElement);
        this.writer.closeElement();
    }

    public void writeLine(JRLine line) throws IOException {
        this.writer.startElement("line", this.getNamespace());
        this.writer.addAttribute("direction", line.getDirectionValue(), LineDirectionEnum.TOP_DOWN);
        this.writeReportElement(line);
        this.writeGraphicElement(line);
        this.writer.closeElement();
    }

    private void writeReportElement(JRElement element) throws IOException {
        this.writer.startElement("reportElement");
        this.writer.addEncodedAttribute("key", element.getKey());
        this.writeStyleReferenceAttr(element);
        this.writer.addAttribute("positionType", element.getPositionTypeValue(), PositionTypeEnum.FIX_RELATIVE_TO_TOP);
        this.writer.addAttribute("stretchType", element.getStretchTypeValue(), StretchTypeEnum.NO_STRETCH);
        this.writer.addAttribute("isPrintRepeatedValues", element.isPrintRepeatedValues(), true);
        this.writer.addAttribute("mode", element.getOwnModeValue());
        this.writer.addAttribute("x", element.getX());
        this.writer.addAttribute("y", element.getY());
        this.writer.addAttribute("width", element.getWidth());
        this.writer.addAttribute("height", element.getHeight());
        this.writer.addAttribute("isRemoveLineWhenBlank", element.isRemoveLineWhenBlank(), false);
        this.writer.addAttribute("isPrintInFirstWholeBand", element.isPrintInFirstWholeBand(), false);
        this.writer.addAttribute("isPrintWhenDetailOverflows", element.isPrintWhenDetailOverflows(), false);
        if (element.getPrintWhenGroupChanges() != null) {
            this.writer.addEncodedAttribute("printWhenGroupChanges", element.getPrintWhenGroupChanges().getName());
        }
        this.writer.addAttribute("forecolor", element.getOwnForecolor());
        this.writer.addAttribute("backcolor", element.getOwnBackcolor());
        if (this.isNewerVersionOrEqual("4.6.0")) {
            this.writer.addEncodedAttribute("uuid", element.getUUID().toString());
        }
        this.writeProperties(element);
        this.writePropertyExpressions(element.getPropertyExpressions());
        this.writeExpression("printWhenExpression", element.getPrintWhenExpression(), false);
        this.writer.closeElement();
    }

    public void writePropertyExpressions(JRPropertyExpression[] propertyExpressions) throws IOException {
        if (propertyExpressions != null) {
            for (int i = 0; i < propertyExpressions.length; ++i) {
                this.writePropertyExpression(propertyExpressions[i]);
            }
        }
    }

    protected void writePropertyExpression(JRPropertyExpression propertyExpression) throws IOException {
        JRExpression valueExpression = propertyExpression.getValueExpression();
        String expressionText = valueExpression == null ? "" : valueExpression.getText();
        this.writer.writeCDATAElement("propertyExpression", this.getNamespace(), expressionText, "name", propertyExpression.getName());
    }

    private void writeGraphicElement(JRGraphicElement element) throws IOException {
        this.writer.startElement("graphicElement");
        this.writer.addAttribute("fill", element.getOwnFillValue());
        this.writePen(element.getLinePen());
        this.writer.closeElement(true);
    }

    public void writeRectangle(JRRectangle rectangle) throws IOException {
        this.writer.startElement("rectangle", this.getNamespace());
        this.writer.addAttribute("radius", rectangle.getOwnRadius());
        this.writeReportElement(rectangle);
        this.writeGraphicElement(rectangle);
        this.writer.closeElement();
    }

    public void writeEllipse(JREllipse ellipse) throws IOException {
        this.writer.startElement("ellipse", this.getNamespace());
        this.writeReportElement(ellipse);
        this.writeGraphicElement(ellipse);
        this.writer.closeElement();
    }

    public void writeImage(JRImage image) throws IOException {
        this.writer.startElement("image", this.getNamespace());
        this.writer.addAttribute("scaleImage", image.getOwnScaleImageValue());
        this.writer.addAttribute("hAlign", image.getOwnHorizontalAlignmentValue());
        this.writer.addAttribute("vAlign", image.getOwnVerticalAlignmentValue());
        this.writer.addAttribute("isUsingCache", image.getUsingCache());
        this.writer.addAttribute("isLazy", image.isLazy(), false);
        this.writer.addAttribute("onErrorType", image.getOnErrorTypeValue(), OnErrorTypeEnum.ERROR);
        this.writer.addAttribute("evaluationTime", image.getEvaluationTimeValue(), EvaluationTimeEnum.NOW);
        if (image.getEvaluationGroup() != null) {
            this.writer.addEncodedAttribute("evaluationGroup", image.getEvaluationGroup().getName());
        }
        this.writer.addEncodedAttribute("hyperlinkType", image.getLinkType(), HyperlinkTypeEnum.NONE.getName());
        this.writer.addEncodedAttribute("hyperlinkTarget", image.getLinkTarget(), HyperlinkTargetEnum.SELF.getName());
        this.writer.addAttribute("bookmarkLevel", image.getBookmarkLevel(), 0);
        this.writeReportElement(image);
        this.writeBox(image.getLineBox());
        this.writeGraphicElement(image);
        this.writeExpression("imageExpression", image.getExpression(), true);
        this.writeExpression("anchorNameExpression", image.getAnchorNameExpression(), false);
        this.writeExpression("hyperlinkReferenceExpression", image.getHyperlinkReferenceExpression(), false);
        this.writeExpression("hyperlinkWhenExpression", image.getHyperlinkWhenExpression(), false);
        this.writeExpression("hyperlinkAnchorExpression", image.getHyperlinkAnchorExpression(), false);
        this.writeExpression("hyperlinkPageExpression", image.getHyperlinkPageExpression(), false);
        this.writeExpression("hyperlinkTooltipExpression", image.getHyperlinkTooltipExpression(), false);
        this.writeHyperlinkParameters(image.getHyperlinkParameters());
        this.writer.closeElement();
    }

    public void writeStaticText(JRStaticText staticText) throws IOException {
        this.writer.startElement("staticText", this.getNamespace());
        this.writeReportElement(staticText);
        this.writeBox(staticText.getLineBox());
        this.writeTextElement(staticText);
        this.writer.writeCDATAElement("text", staticText.getText());
        this.writer.closeElement();
    }

    private void writeTextElement(JRTextElement textElement) throws IOException {
        this.writer.startElement("textElement");
        this.writer.addAttribute("textAlignment", textElement.getOwnHorizontalAlignmentValue());
        this.writer.addAttribute("verticalAlignment", textElement.getOwnVerticalAlignmentValue());
        this.writer.addAttribute("rotation", textElement.getOwnRotationValue());
        if (this.isOlderVersionThan("4.0.2")) {
            this.writer.addAttribute("lineSpacing", textElement.getParagraph().getLineSpacing());
        }
        this.writer.addAttribute("markup", textElement.getOwnMarkup());
        this.writeFont(textElement);
        this.writeParagraph(textElement.getParagraph());
        this.writer.closeElement(true);
    }

    public void writeFont(JRFont font) throws IOException {
        if (font != null) {
            this.writer.startElement("font", this.getNamespace());
            this.writer.addEncodedAttribute("fontName", font.getOwnFontName());
            this.writer.addAttribute("size", font.getOwnFontSize());
            this.writer.addAttribute("isBold", font.isOwnBold());
            this.writer.addAttribute("isItalic", font.isOwnItalic());
            this.writer.addAttribute("isUnderline", font.isOwnUnderline());
            this.writer.addAttribute("isStrikeThrough", font.isOwnStrikeThrough());
            this.writer.addEncodedAttribute("pdfFontName", font.getOwnPdfFontName());
            this.writer.addEncodedAttribute("pdfEncoding", font.getOwnPdfEncoding());
            this.writer.addAttribute("isPdfEmbedded", font.isOwnPdfEmbedded());
            this.writer.closeElement(true);
        }
    }

    public void writeTextField(JRTextField textField) throws IOException {
        this.writer.startElement("textField", this.getNamespace());
        this.writer.addAttribute("isStretchWithOverflow", textField.isStretchWithOverflow(), false);
        this.writer.addAttribute("evaluationTime", textField.getEvaluationTimeValue(), EvaluationTimeEnum.NOW);
        if (textField.getEvaluationGroup() != null) {
            this.writer.addEncodedAttribute("evaluationGroup", textField.getEvaluationGroup().getName());
        }
        this.writer.addEncodedAttribute("pattern", textField.getOwnPattern());
        this.writer.addAttribute("isBlankWhenNull", textField.isOwnBlankWhenNull());
        this.writer.addEncodedAttribute("hyperlinkType", textField.getLinkType(), HyperlinkTypeEnum.NONE.getName());
        this.writer.addEncodedAttribute("hyperlinkTarget", textField.getLinkTarget(), HyperlinkTargetEnum.SELF.getName());
        this.writer.addAttribute("bookmarkLevel", textField.getBookmarkLevel(), 0);
        this.writeReportElement(textField);
        this.writeBox(textField.getLineBox());
        this.writeTextElement(textField);
        this.writeExpression("textFieldExpression", textField.getExpression(), true);
        if (this.isNewerVersionOrEqual("4.1.1")) {
            this.writer.writeExpression("patternExpression", textField.getPatternExpression());
        }
        this.writeExpression("anchorNameExpression", textField.getAnchorNameExpression(), false);
        this.writeExpression("hyperlinkReferenceExpression", textField.getHyperlinkReferenceExpression(), false);
        this.writeExpression("hyperlinkWhenExpression", textField.getHyperlinkWhenExpression(), false);
        this.writeExpression("hyperlinkAnchorExpression", textField.getHyperlinkAnchorExpression(), false);
        this.writeExpression("hyperlinkPageExpression", textField.getHyperlinkPageExpression(), false);
        this.writeExpression("hyperlinkTooltipExpression", textField.getHyperlinkTooltipExpression(), false);
        this.writeHyperlinkParameters(textField.getHyperlinkParameters());
        this.writer.closeElement();
    }

    public void writeSubreport(JRSubreport subreport) throws IOException {
        this.writer.startElement("subreport", this.getNamespace());
        this.writer.addAttribute("isUsingCache", subreport.getUsingCache());
        if (this.isNewerVersionOrEqual("3.5.0")) {
            this.writer.addAttribute("runToBottom", subreport.isRunToBottom());
        }
        this.writeReportElement(subreport);
        this.writeExpression("parametersMapExpression", subreport.getParametersMapExpression(), false);
        JRSubreportParameter[] parameters = subreport.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                this.writeSubreportParameter(parameters[i]);
            }
        }
        this.writeExpression("connectionExpression", subreport.getConnectionExpression(), false);
        this.writeExpression("dataSourceExpression", subreport.getDataSourceExpression(), false);
        JRSubreportReturnValue[] returnValues = subreport.getReturnValues();
        if (returnValues != null && returnValues.length > 0) {
            for (int i = 0; i < returnValues.length; ++i) {
                this.writeSubreportReturnValue(returnValues[i]);
            }
        }
        this.writeExpression("subreportExpression", subreport.getExpression(), true);
        this.writer.closeElement();
    }

    private void writeSubreportParameter(JRSubreportParameter subreportParameter) throws IOException {
        this.writer.startElement("subreportParameter");
        this.writer.addEncodedAttribute("name", subreportParameter.getName());
        this.writeExpression("subreportParameterExpression", subreportParameter.getExpression(), false);
        this.writer.closeElement();
    }

    private void writeDatasetParameter(JRDatasetParameter datasetParameter) throws IOException {
        this.writer.startElement("datasetParameter");
        this.writer.addEncodedAttribute("name", datasetParameter.getName());
        this.writeExpression("datasetParameterExpression", datasetParameter.getExpression(), false);
        this.writer.closeElement();
    }

    private void writeChart(JRChart chart) throws IOException {
        this.writer.startElement("chart");
        this.writer.addAttribute("isShowLegend", chart.getShowLegend());
        this.writer.addAttribute("evaluationTime", chart.getEvaluationTimeValue(), EvaluationTimeEnum.NOW);
        if (chart.getEvaluationTimeValue() == EvaluationTimeEnum.GROUP) {
            this.writer.addEncodedAttribute("evaluationGroup", chart.getEvaluationGroup().getName());
        }
        this.writer.addEncodedAttribute("hyperlinkType", chart.getLinkType(), HyperlinkTypeEnum.NONE.getName());
        this.writer.addEncodedAttribute("hyperlinkTarget", chart.getLinkTarget(), HyperlinkTargetEnum.SELF.getName());
        this.writer.addAttribute("bookmarkLevel", chart.getBookmarkLevel(), 0);
        this.writer.addAttribute("customizerClass", chart.getCustomizerClass());
        this.writer.addEncodedAttribute("renderType", chart.getRenderType());
        if (this.isNewerVersionOrEqual("3.1.0")) {
            this.writer.addEncodedAttribute("theme", chart.getTheme());
        }
        this.writeReportElement(chart);
        this.writeBox(chart.getLineBox());
        this.writer.startElement("chartTitle");
        this.writer.addAttribute("position", chart.getTitlePositionValue());
        this.writer.addAttribute("color", chart.getOwnTitleColor());
        this.writeFont(chart.getTitleFont());
        if (chart.getTitleExpression() != null) {
            this.writeExpression("titleExpression", chart.getTitleExpression(), false);
        }
        this.writer.closeElement();
        this.writer.startElement("chartSubtitle");
        this.writer.addAttribute("color", chart.getOwnSubtitleColor());
        this.writeFont(chart.getSubtitleFont());
        if (chart.getSubtitleExpression() != null) {
            this.writeExpression("subtitleExpression", chart.getSubtitleExpression(), false);
        }
        this.writer.closeElement();
        this.writer.startElement("chartLegend");
        if (chart.getOwnLegendColor() != null) {
            this.writer.addAttribute("textColor", chart.getOwnLegendColor());
        }
        if (chart.getOwnLegendBackgroundColor() != null) {
            this.writer.addAttribute("backgroundColor", chart.getOwnLegendBackgroundColor());
        }
        this.writer.addAttribute("position", chart.getLegendPositionValue());
        this.writeFont(chart.getLegendFont());
        this.writer.closeElement();
        this.writeExpression("anchorNameExpression", chart.getAnchorNameExpression(), false);
        this.writeExpression("hyperlinkReferenceExpression", chart.getHyperlinkReferenceExpression(), false);
        this.writeExpression("hyperlinkWhenExpression", chart.getHyperlinkWhenExpression(), false);
        this.writeExpression("hyperlinkAnchorExpression", chart.getHyperlinkAnchorExpression(), false);
        this.writeExpression("hyperlinkPageExpression", chart.getHyperlinkPageExpression(), false);
        this.writeExpression("hyperlinkTooltipExpression", chart.getHyperlinkTooltipExpression(), false);
        this.writeHyperlinkParameters(chart.getHyperlinkParameters());
        this.writer.closeElement();
    }

    public void writeElementDataset(JRElementDataset dataset) throws IOException {
        this.writeElementDataset(dataset, ResetTypeEnum.REPORT, true);
    }

    public void writeElementDataset(JRElementDataset dataset, boolean skipIfEmpty) throws IOException {
        this.writeElementDataset(dataset, ResetTypeEnum.REPORT, skipIfEmpty);
    }

    public void writeElementDataset(JRElementDataset dataset, ResetTypeEnum defaultResetType, boolean skipIfEmpty) throws IOException {
        this.writer.startElement("dataset", this.getNamespace());
        this.writer.addAttribute("resetType", dataset.getResetTypeValue(), defaultResetType);
        if (dataset.getResetTypeValue() == ResetTypeEnum.GROUP) {
            this.writer.addEncodedAttribute("resetGroup", dataset.getResetGroup().getName());
        }
        this.writer.addAttribute("incrementType", dataset.getIncrementTypeValue(), IncrementTypeEnum.NONE);
        if (dataset.getIncrementTypeValue() == IncrementTypeEnum.GROUP) {
            this.writer.addEncodedAttribute("incrementGroup", dataset.getIncrementGroup().getName());
        }
        this.writeExpression("incrementWhenExpression", dataset.getIncrementWhenExpression(), false);
        JRDatasetRun datasetRun = dataset.getDatasetRun();
        if (datasetRun != null) {
            this.writeDatasetRun(datasetRun);
        }
        this.writer.closeElement(skipIfEmpty);
    }

    private void writeCategoryDataSet(JRCategoryDataset dataset) throws IOException {
        this.writer.startElement("categoryDataset");
        this.writeElementDataset(dataset);
        JRCategorySeries[] categorySeries = dataset.getSeries();
        if (categorySeries != null && categorySeries.length > 0) {
            for (int i = 0; i < categorySeries.length; ++i) {
                this.writeCategorySeries(categorySeries[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeTimeSeriesDataset(JRTimeSeriesDataset dataset) throws IOException {
        this.writer.startElement("timeSeriesDataset");
        this.writer.addAttribute("timePeriod", TimePeriodEnum.getByValue(dataset.getTimePeriod()), TimePeriodEnum.DAY);
        this.writeElementDataset(dataset);
        JRTimeSeries[] timeSeries = dataset.getSeries();
        if (timeSeries != null && timeSeries.length > 0) {
            for (int i = 0; i < timeSeries.length; ++i) {
                this.writeTimeSeries(timeSeries[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeGanttDataset(JRGanttDataset dataset) throws IOException {
        this.writer.startElement("ganttDataset");
        this.writeElementDataset(dataset);
        JRGanttSeries[] ganttSeries = dataset.getSeries();
        if (ganttSeries != null && ganttSeries.length > 0) {
            for (int i = 0; i < ganttSeries.length; ++i) {
                this.writeGanttSeries(ganttSeries[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeTimePeriodDataset(JRTimePeriodDataset dataset) throws IOException {
        this.writer.startElement("timePeriodDataset");
        this.writeElementDataset(dataset);
        JRTimePeriodSeries[] timePeriodSeries = dataset.getSeries();
        if (timePeriodSeries != null && timePeriodSeries.length > 0) {
            for (int i = 0; i < timePeriodSeries.length; ++i) {
                this.writeTimePeriodSeries(timePeriodSeries[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writePieSeries(JRPieSeries pieSeries) throws IOException {
        this.writer.startElement("pieSeries");
        this.writeExpression("keyExpression", pieSeries.getKeyExpression(), false);
        this.writeExpression("valueExpression", pieSeries.getValueExpression(), false);
        this.writeExpression("labelExpression", pieSeries.getLabelExpression(), false);
        this.writeHyperlink("sectionHyperlink", pieSeries.getSectionHyperlink());
        this.writer.closeElement();
    }

    private void writeCategorySeries(JRCategorySeries categorySeries) throws IOException {
        this.writer.startElement("categorySeries");
        this.writeExpression("seriesExpression", categorySeries.getSeriesExpression(), false);
        this.writeExpression("categoryExpression", categorySeries.getCategoryExpression(), false);
        this.writeExpression("valueExpression", categorySeries.getValueExpression(), false);
        this.writeExpression("labelExpression", categorySeries.getLabelExpression(), false);
        this.writeHyperlink("itemHyperlink", categorySeries.getItemHyperlink());
        this.writer.closeElement();
    }

    private void writeXyzDataset(JRXyzDataset dataset) throws IOException {
        this.writer.startElement("xyzDataset");
        this.writeElementDataset(dataset);
        JRXyzSeries[] series = dataset.getSeries();
        if (series != null && series.length > 0) {
            for (int i = 0; i < series.length; ++i) {
                this.writeXyzSeries(series[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeXyzSeries(JRXyzSeries series) throws IOException {
        this.writer.startElement("xyzSeries");
        this.writeExpression("seriesExpression", series.getSeriesExpression(), false);
        this.writeExpression("xValueExpression", series.getXValueExpression(), false);
        this.writeExpression("yValueExpression", series.getYValueExpression(), false);
        this.writeExpression("zValueExpression", series.getZValueExpression(), false);
        this.writeHyperlink("itemHyperlink", series.getItemHyperlink());
        this.writer.closeElement();
    }

    private void writeXySeries(JRXySeries xySeries) throws IOException {
        this.writer.startElement("xySeries");
        if (this.isNewerVersionOrEqual("5.0.1")) {
            this.writer.addAttribute("autoSort", xySeries.getAutoSort());
        }
        this.writeExpression("seriesExpression", xySeries.getSeriesExpression(), false);
        this.writeExpression("xValueExpression", xySeries.getXValueExpression(), false);
        this.writeExpression("yValueExpression", xySeries.getYValueExpression(), false);
        this.writeExpression("labelExpression", xySeries.getLabelExpression(), false);
        this.writeHyperlink("itemHyperlink", xySeries.getItemHyperlink());
        this.writer.closeElement();
    }

    private void writeXyDataset(JRXyDataset dataset) throws IOException {
        this.writer.startElement("xyDataset");
        this.writeElementDataset(dataset);
        JRXySeries[] xySeries = dataset.getSeries();
        if (xySeries != null && xySeries.length > 0) {
            for (int i = 0; i < xySeries.length; ++i) {
                this.writeXySeries(xySeries[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeTimeSeries(JRTimeSeries timeSeries) throws IOException {
        this.writer.startElement("timeSeries");
        this.writeExpression("seriesExpression", timeSeries.getSeriesExpression(), false);
        this.writeExpression("timePeriodExpression", timeSeries.getTimePeriodExpression(), false);
        this.writeExpression("valueExpression", timeSeries.getValueExpression(), false);
        this.writeExpression("labelExpression", timeSeries.getLabelExpression(), false);
        this.writeHyperlink("itemHyperlink", timeSeries.getItemHyperlink());
        this.writer.closeElement();
    }

    private void writeGanttSeries(JRGanttSeries ganttSeries) throws IOException {
        this.writer.startElement("ganttSeries");
        this.writeExpression("seriesExpression", ganttSeries.getSeriesExpression(), false);
        this.writeExpression("taskExpression", ganttSeries.getTaskExpression(), false);
        this.writeExpression("subtaskExpression", ganttSeries.getSubtaskExpression(), false);
        this.writeExpression("startDateExpression", ganttSeries.getStartDateExpression(), false);
        this.writeExpression("endDateExpression", ganttSeries.getEndDateExpression(), false);
        this.writeExpression("percentExpression", ganttSeries.getPercentExpression(), false);
        this.writeExpression("labelExpression", ganttSeries.getLabelExpression(), false);
        this.writeHyperlink("itemHyperlink", ganttSeries.getItemHyperlink());
        this.writer.closeElement();
    }

    private void writeTimePeriodSeries(JRTimePeriodSeries timePeriodSeries) throws IOException {
        this.writer.startElement("timePeriodSeries");
        this.writeExpression("seriesExpression", timePeriodSeries.getSeriesExpression(), false);
        this.writeExpression("startDateExpression", timePeriodSeries.getStartDateExpression(), false);
        this.writeExpression("endDateExpression", timePeriodSeries.getEndDateExpression(), false);
        this.writeExpression("valueExpression", timePeriodSeries.getValueExpression(), false);
        this.writeExpression("labelExpression", timePeriodSeries.getLabelExpression(), false);
        this.writeHyperlink("itemHyperlink", timePeriodSeries.getItemHyperlink());
        this.writer.closeElement();
    }

    public void writePieDataset(JRPieDataset dataset) throws IOException {
        this.writer.startElement("pieDataset", this.getNamespace());
        if (this.isNewerVersionOrEqual("3.5.0")) {
            this.writer.addAttribute("maxCount", dataset.getMaxCount());
            this.writer.addAttribute("minPercentage", dataset.getMinPercentage());
        }
        this.writeElementDataset(dataset);
        JRPieSeries[] pieSeries = dataset.getSeries();
        if (pieSeries != null) {
            if (this.isNewerVersionOrEqual("3.5.0") && pieSeries.length > 1) {
                for (int i = 0; i < pieSeries.length; ++i) {
                    this.writePieSeries(pieSeries[i]);
                }
            } else {
                JRPieSeries ps = pieSeries[0];
                this.writeExpression("keyExpression", ps.getKeyExpression(), false);
                this.writeExpression("valueExpression", ps.getValueExpression(), false);
                this.writeExpression("labelExpression", ps.getLabelExpression(), false);
                this.writeHyperlink("sectionHyperlink", ps.getSectionHyperlink());
            }
        }
        if (this.isNewerVersionOrEqual("3.5.0")) {
            this.writeExpression("otherKeyExpression", dataset.getOtherKeyExpression(), false);
            this.writeExpression("otherLabelExpression", dataset.getOtherLabelExpression(), false);
            this.writeHyperlink("otherSectionHyperlink", dataset.getOtherSectionHyperlink());
        }
        this.writer.closeElement();
    }

    public void writeValueDataset(JRValueDataset dataset) throws IOException {
        this.writer.startElement("valueDataset", this.getNamespace());
        this.writeElementDataset(dataset, ResetTypeEnum.NONE, true);
        this.writeExpression("valueExpression", dataset.getValueExpression(), false);
        this.writer.closeElement();
    }

    public void writeValueDisplay(JRValueDisplay valueDisplay) throws IOException {
        this.writer.startElement("valueDisplay", this.getNamespace());
        this.writer.addAttribute("color", valueDisplay.getColor());
        this.writer.addAttribute("mask", valueDisplay.getMask());
        this.writeFont(valueDisplay.getFont());
        this.writer.closeElement();
    }

    public void writeItemLabel(JRItemLabel itemLabel) throws IOException {
        if (this.isNewerVersionOrEqual("3.5.3") && itemLabel != null) {
            this.writer.startElement("itemLabel", this.getNamespace());
            this.writer.addAttribute("color", itemLabel.getColor());
            this.writer.addAttribute("backgroundColor", itemLabel.getBackgroundColor());
            this.writeFont(itemLabel.getFont());
            this.writer.closeElement();
        }
    }

    public void writeDataRange(JRDataRange dataRange) throws IOException {
        this.writer.startElement("dataRange", this.getNamespace());
        this.writeExpression("lowExpression", dataRange.getLowExpression(), false);
        this.writeExpression("highExpression", dataRange.getHighExpression(), false);
        this.writer.closeElement();
    }

    private void writeMeterInterval(JRMeterInterval interval) throws IOException {
        this.writer.startElement("meterInterval");
        this.writer.addAttribute("label", interval.getLabel());
        this.writer.addAttribute("color", interval.getBackgroundColor());
        this.writer.addAttribute("alpha", interval.getAlphaDouble());
        this.writeDataRange(interval.getDataRange());
        this.writer.closeElement();
    }

    private void writeSeriesColors(SortedSet<JRChartPlot.JRSeriesColor> seriesColors) throws IOException {
        if (seriesColors == null || seriesColors.size() == 0) {
            return;
        }
        JRChartPlot.JRSeriesColor[] colors = seriesColors.toArray(new JRChartPlot.JRSeriesColor[seriesColors.size()]);
        for (int i = 0; i < colors.length; ++i) {
            this.writer.startElement("seriesColor");
            this.writer.addAttribute("seriesOrder", colors[i].getSeriesOrder());
            this.writer.addAttribute("color", colors[i].getColor());
            this.writer.closeElement();
        }
    }

    private void writeChartAxis(JRChartAxis chartAxis) throws IOException {
        this.writer.startElement("axis");
        this.writer.addAttribute("position", chartAxis.getPositionValue());
        this.writeChartTag(chartAxis.getChart());
        this.writer.closeElement();
    }

    private void writePlot(JRChartPlot plot) throws IOException {
        this.writer.startElement("plot");
        this.writer.addAttribute("backcolor", plot.getOwnBackcolor());
        this.writer.addAttribute("orientation", plot.getOrientationValue(), PlotOrientationEnum.VERTICAL);
        this.writer.addAttribute("backgroundAlpha", plot.getBackgroundAlphaFloat());
        this.writer.addAttribute("foregroundAlpha", plot.getForegroundAlphaFloat());
        this.writer.addAttribute("labelRotation", plot.getLabelRotationDouble());
        this.writeSeriesColors(plot.getSeriesColors());
        this.writer.closeElement();
    }

    public void writePieChart(JRChart chart) throws IOException {
        this.writer.startElement("pieChart", this.getNamespace());
        this.writeChart(chart);
        this.writePieDataset((JRPieDataset)chart.getDataset());
        JRPiePlot plot = (JRPiePlot)chart.getPlot();
        this.writer.startElement("piePlot");
        if (this.isNewerVersionOrEqual("3.7.5")) {
            this.writer.addAttribute("isShowLabels", plot.getShowLabels());
        }
        this.writer.addAttribute("isCircular", plot.getCircular());
        if (this.isNewerVersionOrEqual("3.1.0")) {
            this.writer.addAttribute("labelFormat", plot.getLabelFormat());
            this.writer.addAttribute("legendLabelFormat", plot.getLegendLabelFormat());
        }
        this.writePlot(chart.getPlot());
        this.writeItemLabel(plot.getItemLabel());
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writePie3DChart(JRChart chart) throws IOException {
        this.writer.startElement("pie3DChart", this.getNamespace());
        this.writeChart(chart);
        this.writePieDataset((JRPieDataset)chart.getDataset());
        JRPie3DPlot plot = (JRPie3DPlot)chart.getPlot();
        this.writer.startElement("pie3DPlot");
        if (this.isNewerVersionOrEqual("3.7.5")) {
            this.writer.addAttribute("isShowLabels", plot.getShowLabels());
        }
        this.writer.addAttribute("depthFactor", plot.getDepthFactorDouble());
        this.writer.addAttribute("isCircular", plot.getCircular());
        if (this.isNewerVersionOrEqual("3.1.0")) {
            this.writer.addAttribute("labelFormat", plot.getLabelFormat());
            this.writer.addAttribute("legendLabelFormat", plot.getLegendLabelFormat());
        }
        this.writePlot(chart.getPlot());
        this.writeItemLabel(plot.getItemLabel());
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeCategoryAxisFormat(JRFont axisLabelFont, Color axisLabelColor, JRFont axisTickLabelFont, Color axisTickLabelColor, String axisTickLabelMask, Boolean axisVerticalTickLabels, Double labelRotation, Color axisLineColor) throws IOException {
        this.writer.startElement("categoryAxisFormat", this.getNamespace());
        this.writer.addAttribute("labelRotation", labelRotation);
        this.writeAxisFormat(axisLabelFont, axisLabelColor, axisTickLabelFont, axisTickLabelColor, axisTickLabelMask, axisVerticalTickLabels, axisLineColor);
        this.writer.closeElement();
    }

    public void writeAxisFormat(String axisFormatElementName, JRFont axisLabelFont, Color axisLabelColor, JRFont axisTickLabelFont, Color axisTickLabelColor, String axisTickLabelMask, Boolean axisVerticalTickLabels, Color axisLineColor) throws IOException {
        this.writer.startElement(axisFormatElementName, this.getNamespace());
        this.writeAxisFormat(axisLabelFont, axisLabelColor, axisTickLabelFont, axisTickLabelColor, axisTickLabelMask, axisVerticalTickLabels, axisLineColor);
        this.writer.closeElement();
    }

    public void writeAxisFormat(JRFont axisLabelFont, Color axisLabelColor, JRFont axisTickLabelFont, Color axisTickLabelColor, String axisTickLabelMask, Boolean axisVerticalTickLabels, Color axisLineColor) throws IOException {
        this.writer.startElement("axisFormat");
        this.writer.addAttribute("labelColor", axisLabelColor);
        this.writer.addAttribute("tickLabelColor", axisTickLabelColor);
        this.writer.addAttribute("tickLabelMask", axisTickLabelMask);
        if (this.isNewerVersionOrEqual("3.6.2")) {
            this.writer.addAttribute("verticalTickLabels", axisVerticalTickLabels);
        }
        this.writer.addAttribute("axisLineColor", axisLineColor);
        if (axisLabelFont != null) {
            this.writer.startElement("labelFont");
            this.writeFont(axisLabelFont);
            this.writer.closeElement();
        }
        if (axisTickLabelFont != null) {
            this.writer.startElement("tickLabelFont");
            this.writeFont(axisTickLabelFont);
            this.writer.closeElement();
        }
        this.writer.closeElement();
    }

    private void writeBarPlot(JRBarPlot plot) throws IOException {
        this.writer.startElement("barPlot");
        this.writer.addAttribute("isShowLabels", plot.getShowLabels());
        this.writer.addAttribute("isShowTickLabels", plot.getShowTickLabels());
        this.writer.addAttribute("isShowTickMarks", plot.getShowTickMarks());
        this.writePlot(plot);
        this.writeItemLabel(plot.getItemLabel());
        this.writeExpression("categoryAxisLabelExpression", plot.getCategoryAxisLabelExpression(), false);
        this.writeCategoryAxisFormat(plot.getCategoryAxisLabelFont(), plot.getOwnCategoryAxisLabelColor(), plot.getCategoryAxisTickLabelFont(), plot.getOwnCategoryAxisTickLabelColor(), plot.getCategoryAxisTickLabelMask(), plot.getCategoryAxisVerticalTickLabels(), plot.getCategoryAxisTickLabelRotation(), plot.getOwnCategoryAxisLineColor());
        this.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor());
        if (this.isNewerVersionOrEqual("3.5.0")) {
            this.writeExpression("domainAxisMinValueExpression", plot.getDomainAxisMinValueExpression(), false);
            this.writeExpression("domainAxisMaxValueExpression", plot.getDomainAxisMaxValueExpression(), false);
            this.writeExpression("rangeAxisMinValueExpression", plot.getRangeAxisMinValueExpression(), false);
            this.writeExpression("rangeAxisMaxValueExpression", plot.getRangeAxisMaxValueExpression(), false);
        }
        this.writer.closeElement();
    }

    private void writeBubblePlot(JRBubblePlot plot) throws IOException {
        this.writer.startElement("bubblePlot");
        this.writer.addAttribute("scaleType", plot.getScaleTypeValue());
        this.writePlot(plot);
        this.writeExpression("xAxisLabelExpression", plot.getXAxisLabelExpression(), false);
        this.writeAxisFormat("xAxisFormat", plot.getXAxisLabelFont(), plot.getOwnXAxisLabelColor(), plot.getXAxisTickLabelFont(), plot.getOwnXAxisTickLabelColor(), plot.getXAxisTickLabelMask(), plot.getXAxisVerticalTickLabels(), plot.getOwnXAxisLineColor());
        this.writeExpression("yAxisLabelExpression", plot.getYAxisLabelExpression(), false);
        this.writeAxisFormat("yAxisFormat", plot.getYAxisLabelFont(), plot.getOwnYAxisLabelColor(), plot.getYAxisTickLabelFont(), plot.getOwnYAxisTickLabelColor(), plot.getYAxisTickLabelMask(), plot.getYAxisVerticalTickLabels(), plot.getOwnYAxisLineColor());
        if (this.isNewerVersionOrEqual("3.5.0")) {
            this.writeExpression("domainAxisMinValueExpression", plot.getDomainAxisMinValueExpression(), false);
            this.writeExpression("domainAxisMaxValueExpression", plot.getDomainAxisMaxValueExpression(), false);
            this.writeExpression("rangeAxisMinValueExpression", plot.getRangeAxisMinValueExpression(), false);
            this.writeExpression("rangeAxisMaxValueExpression", plot.getRangeAxisMaxValueExpression(), false);
        }
        this.writer.closeElement();
    }

    private void writeLinePlot(JRLinePlot plot) throws IOException {
        this.writer.startElement("linePlot");
        this.writer.addAttribute("isShowLines", plot.getShowLines());
        this.writer.addAttribute("isShowShapes", plot.getShowShapes());
        this.writePlot(plot);
        this.writeExpression("categoryAxisLabelExpression", plot.getCategoryAxisLabelExpression(), false);
        this.writeCategoryAxisFormat(plot.getCategoryAxisLabelFont(), plot.getOwnCategoryAxisLabelColor(), plot.getCategoryAxisTickLabelFont(), plot.getOwnCategoryAxisTickLabelColor(), plot.getCategoryAxisTickLabelMask(), plot.getCategoryAxisVerticalTickLabels(), plot.getCategoryAxisTickLabelRotation(), plot.getOwnCategoryAxisLineColor());
        this.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor());
        if (this.isNewerVersionOrEqual("3.5.0")) {
            this.writeExpression("domainAxisMinValueExpression", plot.getDomainAxisMinValueExpression(), false);
            this.writeExpression("domainAxisMaxValueExpression", plot.getDomainAxisMaxValueExpression(), false);
            this.writeExpression("rangeAxisMinValueExpression", plot.getRangeAxisMinValueExpression(), false);
            this.writeExpression("rangeAxisMaxValueExpression", plot.getRangeAxisMaxValueExpression(), false);
        }
        this.writer.closeElement();
    }

    private void writeTimeSeriesPlot(JRTimeSeriesPlot plot) throws IOException {
        this.writer.startElement("timeSeriesPlot");
        this.writer.addAttribute("isShowLines", plot.getShowLines());
        this.writer.addAttribute("isShowShapes", plot.getShowShapes());
        this.writePlot(plot);
        this.writeExpression("timeAxisLabelExpression", plot.getTimeAxisLabelExpression(), false);
        this.writeAxisFormat("timeAxisFormat", plot.getTimeAxisLabelFont(), plot.getOwnTimeAxisLabelColor(), plot.getTimeAxisTickLabelFont(), plot.getOwnTimeAxisTickLabelColor(), plot.getTimeAxisTickLabelMask(), plot.getTimeAxisVerticalTickLabels(), plot.getOwnTimeAxisLineColor());
        this.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor());
        if (this.isNewerVersionOrEqual("3.5.0")) {
            this.writeExpression("domainAxisMinValueExpression", plot.getDomainAxisMinValueExpression(), false);
            this.writeExpression("domainAxisMaxValueExpression", plot.getDomainAxisMaxValueExpression(), false);
            this.writeExpression("rangeAxisMinValueExpression", plot.getRangeAxisMinValueExpression(), false);
            this.writeExpression("rangeAxisMaxValueExpression", plot.getRangeAxisMaxValueExpression(), false);
        }
        this.writer.closeElement();
    }

    public void writeBar3DPlot(JRBar3DPlot plot) throws IOException {
        this.writer.startElement("bar3DPlot", this.getNamespace());
        this.writer.addAttribute("isShowLabels", plot.getShowLabels());
        this.writer.addAttribute("xOffset", plot.getXOffsetDouble());
        this.writer.addAttribute("yOffset", plot.getYOffsetDouble());
        this.writePlot(plot);
        this.writeItemLabel(plot.getItemLabel());
        this.writeExpression("categoryAxisLabelExpression", plot.getCategoryAxisLabelExpression(), false);
        this.writeCategoryAxisFormat(plot.getCategoryAxisLabelFont(), plot.getOwnCategoryAxisLabelColor(), plot.getCategoryAxisTickLabelFont(), plot.getOwnCategoryAxisTickLabelColor(), plot.getCategoryAxisTickLabelMask(), plot.getCategoryAxisVerticalTickLabels(), plot.getCategoryAxisTickLabelRotation(), plot.getOwnCategoryAxisLineColor());
        this.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor());
        if (this.isNewerVersionOrEqual("3.5.0")) {
            this.writeExpression("domainAxisMinValueExpression", plot.getDomainAxisMinValueExpression(), false);
            this.writeExpression("domainAxisMaxValueExpression", plot.getDomainAxisMaxValueExpression(), false);
            this.writeExpression("rangeAxisMinValueExpression", plot.getRangeAxisMinValueExpression(), false);
            this.writeExpression("rangeAxisMaxValueExpression", plot.getRangeAxisMaxValueExpression(), false);
        }
        this.writer.closeElement();
    }

    public void writeBarChart(JRChart chart) throws IOException {
        this.writer.startElement("barChart", this.getNamespace());
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeBarPlot((JRBarPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeBar3DChart(JRChart chart) throws IOException {
        this.writer.startElement("bar3DChart", this.getNamespace());
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeBar3DPlot((JRBar3DPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeBubbleChart(JRChart chart) throws IOException {
        this.writer.startElement("bubbleChart", this.getNamespace());
        this.writeChart(chart);
        this.writeXyzDataset((JRXyzDataset)chart.getDataset());
        this.writeBubblePlot((JRBubblePlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeStackedBarChart(JRChart chart) throws IOException {
        this.writer.startElement("stackedBarChart", this.getNamespace());
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeBarPlot((JRBarPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeStackedBar3DChart(JRChart chart) throws IOException {
        this.writer.startElement("stackedBar3DChart", this.getNamespace());
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeBar3DPlot((JRBar3DPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeLineChart(JRChart chart) throws IOException {
        this.writer.startElement("lineChart", this.getNamespace());
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeLinePlot((JRLinePlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeTimeSeriesChart(JRChart chart) throws IOException {
        this.writer.startElement("timeSeriesChart", this.getNamespace());
        this.writeChart(chart);
        this.writeTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset());
        this.writeTimeSeriesPlot((JRTimeSeriesPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeHighLowDataset(JRHighLowDataset dataset) throws IOException {
        this.writer.startElement("highLowDataset", this.getNamespace());
        this.writeElementDataset(dataset);
        this.writeExpression("seriesExpression", dataset.getSeriesExpression(), false);
        this.writeExpression("dateExpression", dataset.getDateExpression(), false);
        this.writeExpression("highExpression", dataset.getHighExpression(), false);
        this.writeExpression("lowExpression", dataset.getLowExpression(), false);
        this.writeExpression("openExpression", dataset.getOpenExpression(), false);
        this.writeExpression("closeExpression", dataset.getCloseExpression(), false);
        this.writeExpression("volumeExpression", dataset.getVolumeExpression(), false);
        this.writeHyperlink("itemHyperlink", dataset.getItemHyperlink());
        this.writer.closeElement();
    }

    public void writeHighLowChart(JRChart chart) throws IOException {
        this.writer.startElement("highLowChart", this.getNamespace());
        this.writeChart(chart);
        this.writeHighLowDataset((JRHighLowDataset)chart.getDataset());
        JRHighLowPlot plot = (JRHighLowPlot)chart.getPlot();
        this.writer.startElement("highLowPlot");
        this.writer.addAttribute("isShowOpenTicks", plot.getShowOpenTicks());
        this.writer.addAttribute("isShowCloseTicks", plot.getShowCloseTicks());
        this.writePlot(plot);
        this.writeExpression("timeAxisLabelExpression", plot.getTimeAxisLabelExpression(), false);
        this.writeAxisFormat("timeAxisFormat", plot.getTimeAxisLabelFont(), plot.getOwnTimeAxisLabelColor(), plot.getTimeAxisTickLabelFont(), plot.getOwnTimeAxisTickLabelColor(), plot.getTimeAxisTickLabelMask(), plot.getTimeAxisVerticalTickLabels(), plot.getOwnTimeAxisLineColor());
        this.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor());
        if (this.isNewerVersionOrEqual("3.5.0")) {
            this.writeExpression("domainAxisMinValueExpression", plot.getDomainAxisMinValueExpression(), false);
            this.writeExpression("domainAxisMaxValueExpression", plot.getDomainAxisMaxValueExpression(), false);
            this.writeExpression("rangeAxisMinValueExpression", plot.getRangeAxisMinValueExpression(), false);
            this.writeExpression("rangeAxisMaxValueExpression", plot.getRangeAxisMaxValueExpression(), false);
        }
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeGanttChart(JRChart chart) throws IOException {
        this.writer.startElement("ganttChart", this.getNamespace());
        this.writeChart(chart);
        this.writeGanttDataset((JRGanttDataset)chart.getDataset());
        this.writeBarPlot((JRBarPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeCandlestickChart(JRChart chart) throws IOException {
        this.writer.startElement("candlestickChart", this.getNamespace());
        this.writeChart(chart);
        this.writeHighLowDataset((JRHighLowDataset)chart.getDataset());
        JRCandlestickPlot plot = (JRCandlestickPlot)chart.getPlot();
        this.writer.startElement("candlestickPlot");
        this.writer.addAttribute("isShowVolume", plot.getShowVolume());
        this.writePlot(plot);
        this.writeExpression("timeAxisLabelExpression", plot.getTimeAxisLabelExpression(), false);
        this.writeAxisFormat("timeAxisFormat", plot.getTimeAxisLabelFont(), plot.getOwnTimeAxisLabelColor(), plot.getTimeAxisTickLabelFont(), plot.getOwnTimeAxisTickLabelColor(), plot.getTimeAxisTickLabelMask(), plot.getTimeAxisVerticalTickLabels(), plot.getOwnTimeAxisLineColor());
        this.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor());
        if (this.isNewerVersionOrEqual("3.5.0")) {
            this.writeExpression("domainAxisMinValueExpression", plot.getDomainAxisMinValueExpression(), false);
            this.writeExpression("domainAxisMaxValueExpression", plot.getDomainAxisMaxValueExpression(), false);
            this.writeExpression("rangeAxisMinValueExpression", plot.getRangeAxisMinValueExpression(), false);
            this.writeExpression("rangeAxisMaxValueExpression", plot.getRangeAxisMaxValueExpression(), false);
        }
        this.writer.closeElement();
        this.writer.closeElement();
    }

    private void writeAreaPlot(JRAreaPlot plot) throws IOException {
        this.writer.startElement("areaPlot");
        this.writePlot(plot);
        this.writeExpression("categoryAxisLabelExpression", plot.getCategoryAxisLabelExpression(), false);
        this.writeCategoryAxisFormat(plot.getCategoryAxisLabelFont(), plot.getOwnCategoryAxisLabelColor(), plot.getCategoryAxisTickLabelFont(), plot.getOwnCategoryAxisTickLabelColor(), plot.getCategoryAxisTickLabelMask(), plot.getCategoryAxisVerticalTickLabels(), plot.getCategoryAxisTickLabelRotation(), plot.getOwnCategoryAxisLineColor());
        this.writeExpression("valueAxisLabelExpression", plot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor());
        if (this.isNewerVersionOrEqual("3.5.0")) {
            this.writeExpression("domainAxisMinValueExpression", plot.getDomainAxisMinValueExpression(), false);
            this.writeExpression("domainAxisMaxValueExpression", plot.getDomainAxisMaxValueExpression(), false);
            this.writeExpression("rangeAxisMinValueExpression", plot.getRangeAxisMinValueExpression(), false);
            this.writeExpression("rangeAxisMaxValueExpression", plot.getRangeAxisMaxValueExpression(), false);
        }
        this.writer.closeElement();
    }

    public void writeAreaChart(JRChart chart) throws IOException {
        this.writer.startElement("areaChart", this.getNamespace());
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeAreaPlot((JRAreaPlot)chart.getPlot());
        this.writer.closeElement();
    }

    private void writeScatterPlot(JRScatterPlot plot) throws IOException {
        this.writer.startElement("scatterPlot");
        this.writer.addAttribute("isShowLines", plot.getShowLines());
        this.writer.addAttribute("isShowShapes", plot.getShowShapes());
        this.writePlot(plot);
        this.writeExpression("xAxisLabelExpression", plot.getXAxisLabelExpression(), false);
        this.writeAxisFormat("xAxisFormat", plot.getXAxisLabelFont(), plot.getOwnXAxisLabelColor(), plot.getXAxisTickLabelFont(), plot.getOwnXAxisTickLabelColor(), plot.getXAxisTickLabelMask(), plot.getXAxisVerticalTickLabels(), plot.getOwnXAxisLineColor());
        this.writeExpression("yAxisLabelExpression", plot.getYAxisLabelExpression(), false);
        this.writeAxisFormat("yAxisFormat", plot.getYAxisLabelFont(), plot.getOwnYAxisLabelColor(), plot.getYAxisTickLabelFont(), plot.getOwnYAxisTickLabelColor(), plot.getYAxisTickLabelMask(), plot.getYAxisVerticalTickLabels(), plot.getOwnYAxisLineColor());
        if (this.isNewerVersionOrEqual("3.5.0")) {
            this.writeExpression("domainAxisMinValueExpression", plot.getDomainAxisMinValueExpression(), false);
            this.writeExpression("domainAxisMaxValueExpression", plot.getDomainAxisMaxValueExpression(), false);
            this.writeExpression("rangeAxisMinValueExpression", plot.getRangeAxisMinValueExpression(), false);
            this.writeExpression("rangeAxisMaxValueExpression", plot.getRangeAxisMaxValueExpression(), false);
        }
        this.writer.closeElement();
    }

    public void writeScatterChart(JRChart chart) throws IOException {
        this.writer.startElement("scatterChart", this.getNamespace());
        this.writeChart(chart);
        this.writeXyDataset((JRXyDataset)chart.getDataset());
        this.writeScatterPlot((JRScatterPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeXyAreaChart(JRChart chart) throws IOException {
        this.writer.startElement("xyAreaChart", this.getNamespace());
        this.writeChart(chart);
        this.writeXyDataset((JRXyDataset)chart.getDataset());
        this.writeAreaPlot((JRAreaPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeXyBarChart(JRChart chart) throws IOException {
        this.writer.startElement("xyBarChart", this.getNamespace());
        this.writeChart(chart);
        JRChartDataset dataset = chart.getDataset();
        if (dataset.getDatasetType() == 6) {
            this.writeTimeSeriesDataset((JRTimeSeriesDataset)dataset);
        } else if (dataset.getDatasetType() == 5) {
            this.writeTimePeriodDataset((JRTimePeriodDataset)dataset);
        } else if (dataset.getDatasetType() == 3) {
            this.writeXyDataset((JRXyDataset)dataset);
        }
        this.writeBarPlot((JRBarPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeXyLineChart(JRChart chart) throws IOException {
        this.writer.startElement("xyLineChart", this.getNamespace());
        this.writeChart(chart);
        this.writeXyDataset((JRXyDataset)chart.getDataset());
        this.writeLinePlot((JRLinePlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeMeterChart(JRChart chart) throws IOException {
        this.writer.startElement("meterChart", this.getNamespace());
        this.writeChart(chart);
        this.writeValueDataset((JRValueDataset)chart.getDataset());
        JRMeterPlot plot = (JRMeterPlot)chart.getPlot();
        this.writer.startElement("meterPlot");
        this.writer.addAttribute("shape", plot.getShapeValue());
        this.writer.addAttribute("angle", plot.getMeterAngleInteger());
        this.writer.addAttribute("units", plot.getUnits());
        this.writer.addAttribute("tickInterval", plot.getTickIntervalDouble());
        this.writer.addAttribute("meterColor", plot.getMeterBackgroundColor());
        this.writer.addAttribute("needleColor", plot.getNeedleColor());
        this.writer.addAttribute("tickColor", plot.getTickColor());
        if (this.isNewerVersionOrEqual("4.6.0")) {
            this.writer.addAttribute("tickCount", plot.getTickCount());
        }
        this.writePlot(chart.getPlot());
        if (this.isNewerVersionOrEqual("3.5.0") && plot.getTickLabelFont() != null) {
            this.writer.startElement("tickLabelFont");
            this.writeFont(plot.getTickLabelFont());
            this.writer.closeElement();
        }
        this.writeValueDisplay(plot.getValueDisplay());
        this.writeDataRange(plot.getDataRange());
        List<JRMeterInterval> intervals = plot.getIntervals();
        if (intervals != null) {
            for (JRMeterInterval meterInterval : intervals) {
                this.writeMeterInterval(meterInterval);
            }
        }
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeThermometerChart(JRChart chart) throws IOException {
        this.writer.startElement("thermometerChart", this.getNamespace());
        this.writeChart(chart);
        this.writeValueDataset((JRValueDataset)chart.getDataset());
        JRThermometerPlot plot = (JRThermometerPlot)chart.getPlot();
        this.writer.startElement("thermometerPlot", this.getNamespace());
        this.writer.addAttribute("valueLocation", plot.getValueLocationValue());
        this.writer.addAttribute("mercuryColor", plot.getMercuryColor());
        this.writePlot(chart.getPlot());
        this.writeValueDisplay(plot.getValueDisplay());
        this.writeDataRange(plot.getDataRange());
        if (plot.getLowRange() != null) {
            this.writer.startElement("lowRange");
            this.writeDataRange(plot.getLowRange());
            this.writer.closeElement();
        }
        if (plot.getMediumRange() != null) {
            this.writer.startElement("mediumRange");
            this.writeDataRange(plot.getMediumRange());
            this.writer.closeElement();
        }
        if (plot.getHighRange() != null) {
            this.writer.startElement("highRange");
            this.writeDataRange(plot.getHighRange());
            this.writer.closeElement();
        }
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeMultiAxisChart(JRChart chart) throws IOException {
        this.writer.startElement("multiAxisChart", this.getNamespace());
        this.writeChart(chart);
        JRMultiAxisPlot plot = (JRMultiAxisPlot)chart.getPlot();
        this.writer.startElement("multiAxisPlot");
        this.writePlot(chart.getPlot());
        List<JRChartAxis> axes = plot.getAxes();
        if (axes != null) {
            for (JRChartAxis chartAxis : axes) {
                this.writeChartAxis(chartAxis);
            }
        }
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeStackedAreaChart(JRChart chart) throws IOException {
        this.writer.startElement("stackedAreaChart", this.getNamespace());
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeAreaPlot((JRAreaPlot)chart.getPlot());
        this.writer.closeElement();
    }

    public void writeChartTag(JRChart chart) throws IOException {
        switch (chart.getChartType()) {
            case 1: {
                this.writeAreaChart(chart);
                break;
            }
            case 3: {
                this.writeBarChart(chart);
                break;
            }
            case 2: {
                this.writeBar3DChart(chart);
                break;
            }
            case 4: {
                this.writeBubbleChart(chart);
                break;
            }
            case 5: {
                this.writeCandlestickChart(chart);
                break;
            }
            case 6: {
                this.writeHighLowChart(chart);
                break;
            }
            case 7: {
                this.writeLineChart(chart);
                break;
            }
            case 17: {
                this.writeMeterChart(chart);
                break;
            }
            case 19: {
                this.writeMultiAxisChart(chart);
                break;
            }
            case 9: {
                this.writePieChart(chart);
                break;
            }
            case 8: {
                this.writePie3DChart(chart);
                break;
            }
            case 10: {
                this.writeScatterChart(chart);
                break;
            }
            case 12: {
                this.writeStackedBarChart(chart);
                break;
            }
            case 11: {
                this.writeStackedBar3DChart(chart);
                break;
            }
            case 18: {
                this.writeThermometerChart(chart);
                break;
            }
            case 16: {
                this.writeTimeSeriesChart(chart);
                break;
            }
            case 13: {
                this.writeXyAreaChart(chart);
                break;
            }
            case 14: {
                this.writeXyBarChart(chart);
                break;
            }
            case 15: {
                this.writeXyLineChart(chart);
                break;
            }
            case 20: {
                this.writeStackedAreaChart(chart);
                break;
            }
            case 21: {
                this.writeGanttChart(chart);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
    }

    private void writeSubreportReturnValue(JRSubreportReturnValue returnValue) throws IOException {
        this.writer.startElement("returnValue");
        this.writer.addEncodedAttribute("subreportVariable", returnValue.getSubreportVariable());
        this.writer.addEncodedAttribute("toVariable", returnValue.getToVariable());
        this.writer.addAttribute("calculation", returnValue.getCalculationValue(), CalculationEnum.NOTHING);
        this.writer.addAttribute("incrementerFactoryClass", returnValue.getIncrementerFactoryClassName());
        this.writer.closeElement();
    }

    protected void writeReturnValue(ReturnValue returnValue) throws IOException {
        this.writer.startElement("returnValue");
        this.writer.addEncodedAttribute("fromVariable", returnValue.getFromVariable());
        this.writer.addEncodedAttribute("toVariable", returnValue.getToVariable());
        this.writer.addAttribute("calculation", returnValue.getCalculation(), CalculationEnum.NOTHING);
        this.writer.addAttribute("incrementerFactoryClass", returnValue.getIncrementerFactoryClassName());
        this.writer.closeElement();
    }

    public void writeCrosstab(JRCrosstab crosstab) throws IOException {
        JRCrosstabParameter[] parameters;
        this.writer.startElement("crosstab", this.getNamespace());
        this.writer.addAttribute("isRepeatColumnHeaders", crosstab.isRepeatColumnHeaders(), true);
        this.writer.addAttribute("isRepeatRowHeaders", crosstab.isRepeatRowHeaders(), true);
        this.writer.addAttribute("columnBreakOffset", crosstab.getColumnBreakOffset(), 10);
        this.writer.addAttribute("runDirection", crosstab.getRunDirectionValue(), RunDirectionEnum.LTR);
        this.writer.addAttribute("horizontalPosition", crosstab.getHorizontalPosition());
        if (this.isNewerVersionOrEqual("3.5.3")) {
            this.writer.addAttribute("ignoreWidth", crosstab.getIgnoreWidth());
        }
        this.writeReportElement(crosstab);
        if (this.isNewerVersionOrEqual("4.5.0")) {
            this.writeBox(crosstab.getLineBox());
        }
        if ((parameters = crosstab.getParameters()) != null) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].isSystemDefined()) continue;
                this.writeCrosstabParameter(parameters[i]);
            }
        }
        this.writeExpression("parametersMapExpression", crosstab.getParametersMapExpression(), false);
        this.writeCrosstabDataset(crosstab);
        this.writeCrosstabHeaderCell(crosstab);
        JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
        for (int i = 0; i < rowGroups.length; ++i) {
            this.writeCrosstabRowGroup(rowGroups[i]);
        }
        JRCrosstabColumnGroup[] columnGroups = crosstab.getColumnGroups();
        for (int i = 0; i < columnGroups.length; ++i) {
            this.writeCrosstabColumnGroup(columnGroups[i]);
        }
        JRCrosstabMeasure[] measures = crosstab.getMeasures();
        for (int i = 0; i < measures.length; ++i) {
            this.writeCrosstabMeasure(measures[i]);
        }
        if (crosstab instanceof JRDesignCrosstab) {
            List<JRCrosstabCell> cellsList = ((JRDesignCrosstab)crosstab).getCellsList();
            for (JRCrosstabCell cell : cellsList) {
                this.writeCrosstabCell(cell);
            }
        } else {
            JRCrosstabCell[][] cells = crosstab.getCells();
            HashSet<JRCrosstabCell> cellsSet = new HashSet<JRCrosstabCell>();
            for (int i = cells.length - 1; i >= 0; --i) {
                for (int j = cells[i].length - 1; j >= 0; --j) {
                    JRCrosstabCell cell = cells[i][j];
                    if (cell == null || !cellsSet.add(cell)) continue;
                    this.writeCrosstabCell(cell);
                }
            }
        }
        this.writeCrosstabWhenNoDataCell(crosstab);
        this.writer.closeElement();
    }

    private void writeCrosstabDataset(JRCrosstab crosstab) throws IOException {
        JRCrosstabDataset dataset = crosstab.getDataset();
        this.writer.startElement("crosstabDataset");
        this.writer.addAttribute("isDataPreSorted", dataset.isDataPreSorted(), false);
        this.writeElementDataset(dataset);
        this.writer.closeElement(true);
    }

    private void writeCrosstabWhenNoDataCell(JRCrosstab crosstab) throws IOException {
        JRCellContents whenNoDataCell = crosstab.getWhenNoDataCell();
        if (whenNoDataCell != null) {
            this.writer.startElement("whenNoDataCell");
            this.writeCellContents(whenNoDataCell);
            this.writer.closeElement();
        }
    }

    private void writeCrosstabHeaderCell(JRCrosstab crosstab) throws IOException {
        JRCellContents headerCell = crosstab.getHeaderCell();
        if (headerCell != null) {
            this.writer.startElement("crosstabHeaderCell");
            this.writeCellContents(headerCell);
            this.writer.closeElement();
        }
    }

    protected void writeCrosstabRowGroup(JRCrosstabRowGroup group) throws IOException {
        this.writer.startElement("rowGroup");
        this.writer.addEncodedAttribute("name", group.getName());
        this.writer.addAttribute("width", group.getWidth());
        this.writer.addAttribute("totalPosition", group.getTotalPositionValue(), CrosstabTotalPositionEnum.NONE);
        this.writer.addAttribute("headerPosition", group.getPositionValue(), CrosstabRowPositionEnum.TOP);
        this.writeBucket(group.getBucket());
        JRCellContents header = group.getHeader();
        this.writer.startElement("crosstabRowHeader");
        this.writeCellContents(header);
        this.writer.closeElement();
        JRCellContents totalHeader = group.getTotalHeader();
        this.writer.startElement("crosstabTotalRowHeader");
        this.writeCellContents(totalHeader);
        this.writer.closeElement();
        this.writer.closeElement();
    }

    protected void writeCrosstabColumnGroup(JRCrosstabColumnGroup group) throws IOException {
        this.writer.startElement("columnGroup");
        this.writer.addEncodedAttribute("name", group.getName());
        this.writer.addAttribute("height", group.getHeight());
        this.writer.addAttribute("totalPosition", group.getTotalPositionValue(), CrosstabTotalPositionEnum.NONE);
        this.writer.addAttribute("headerPosition", group.getPositionValue(), CrosstabColumnPositionEnum.LEFT);
        this.writeBucket(group.getBucket());
        JRCellContents crosstabHeader = group.getCrosstabHeader();
        if (crosstabHeader != null) {
            this.writer.startElement("crosstabHeader");
            this.writeCellContents(crosstabHeader);
            this.writer.closeElement();
        }
        JRCellContents header = group.getHeader();
        this.writer.startElement("crosstabColumnHeader");
        this.writeCellContents(header);
        this.writer.closeElement();
        JRCellContents totalHeader = group.getTotalHeader();
        this.writer.startElement("crosstabTotalColumnHeader");
        this.writeCellContents(totalHeader);
        this.writer.closeElement();
        this.writer.closeElement();
    }

    protected void writeBucket(JRCrosstabBucket bucket) throws IOException {
        this.writer.startElement("bucket");
        this.writer.addAttribute("order", bucket.getOrder(), BucketOrder.ASCENDING);
        if (this.isNewerVersionOrEqual("4.1.1")) {
            this.writer.addAttribute("class", bucket.getValueClassName());
        }
        this.writeExpression("bucketExpression", bucket.getExpression(), true);
        if (this.isNewerVersionOrEqual("3.6.2")) {
            this.writeExpression("orderByExpression", bucket.getOrderByExpression(), true, Object.class.getName());
        }
        this.writeExpression("comparatorExpression", bucket.getComparatorExpression(), false);
        this.writer.closeElement();
    }

    protected void writeCrosstabMeasure(JRCrosstabMeasure measure) throws IOException {
        this.writer.startElement("measure");
        this.writer.addEncodedAttribute("name", measure.getName());
        this.writer.addAttribute("class", measure.getValueClassName());
        this.writer.addAttribute("calculation", measure.getCalculationValue(), CalculationEnum.NOTHING);
        this.writer.addAttribute("incrementerFactoryClass", measure.getIncrementerFactoryClassName());
        this.writer.addAttribute("percentageOf", measure.getPercentageType(), CrosstabPercentageEnum.NONE);
        this.writer.addAttribute("percentageCalculatorClass", measure.getPercentageCalculatorClassName());
        this.writeExpression("measureExpression", measure.getValueExpression(), false);
        this.writer.closeElement();
    }

    protected void writeCrosstabCell(JRCrosstabCell cell) throws IOException {
        this.writer.startElement("crosstabCell");
        this.writer.addAttribute("width", cell.getWidth());
        this.writer.addAttribute("height", cell.getHeight());
        this.writer.addEncodedAttribute("rowTotalGroup", cell.getRowTotalGroup());
        this.writer.addEncodedAttribute("columnTotalGroup", cell.getColumnTotalGroup());
        this.writeCellContents(cell.getContents());
        this.writer.closeElement();
    }

    protected void writeCellContents(JRCellContents contents) throws IOException {
        if (contents != null) {
            this.writer.startElement("cellContents");
            this.writer.addAttribute("backcolor", contents.getBackcolor());
            this.writer.addAttribute("mode", contents.getModeValue());
            this.writeStyleReferenceAttr(contents);
            if (this.isNewerVersionOrEqual("4.8.0")) {
                this.writeProperties(contents);
            }
            this.writeBox(contents.getLineBox());
            this.writeChildElements(contents);
            this.writer.closeElement();
        }
    }

    protected void writeCrosstabParameter(JRCrosstabParameter parameter) throws IOException {
        this.writer.startElement("crosstabParameter");
        this.writer.addEncodedAttribute("name", parameter.getName());
        this.writer.addAttribute("class", parameter.getValueClassName(), "java.lang.String");
        this.writeExpression("parameterValueExpression", parameter.getExpression(), false);
        this.writer.closeElement();
    }

    public void writeDataset(JRDataset dataset) throws IOException {
        this.writer.startElement("subDataset", this.getNamespace());
        this.writer.addEncodedAttribute("name", dataset.getName());
        this.writer.addAttribute("scriptletClass", dataset.getScriptletClass());
        this.writer.addEncodedAttribute("resourceBundle", dataset.getResourceBundle());
        this.writer.addAttribute("whenResourceMissingType", dataset.getWhenResourceMissingTypeValue(), WhenResourceMissingTypeEnum.NULL);
        if (this.isNewerVersionOrEqual("4.6.0")) {
            this.writer.addAttribute("uuid", dataset.getUUID().toString());
        }
        this.writeProperties(dataset);
        this.writeDatasetContents(dataset);
        this.writer.closeElement();
    }

    protected void writeDatasetContents(JRDataset dataset) throws IOException {
        JRVariable[] variables;
        JRSortField[] sortFields;
        JRField[] fields;
        JRParameter[] parameters;
        JRScriptlet[] scriptlets = dataset.getScriptlets();
        if (scriptlets != null && scriptlets.length > 0) {
            for (int i = 0; i < scriptlets.length; ++i) {
                this.writeScriptlet(scriptlets[i]);
            }
        }
        if ((parameters = dataset.getParameters()) != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].isSystemDefined()) continue;
                this.writeParameter(parameters[i]);
            }
        }
        if (dataset.getQuery() != null) {
            this.writeQuery(dataset.getQuery());
        }
        if ((fields = dataset.getFields()) != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                this.writeField(fields[i]);
            }
        }
        if ((sortFields = dataset.getSortFields()) != null && sortFields.length > 0) {
            for (int i = 0; i < sortFields.length; ++i) {
                this.writeSortField(sortFields[i]);
            }
        }
        if ((variables = dataset.getVariables()) != null && variables.length > 0) {
            for (int i = 0; i < variables.length; ++i) {
                if (variables[i].isSystemDefined()) continue;
                this.writeVariable(variables[i]);
            }
        }
        this.writeExpression("filterExpression", dataset.getFilterExpression(), false);
        JRGroup[] groups = dataset.getGroups();
        if (groups != null && groups.length > 0) {
            for (int i = 0; i < groups.length; ++i) {
                this.writeGroup(groups[i]);
            }
        }
    }

    public void writeDatasetRun(JRDatasetRun datasetRun) throws IOException {
        this.writer.startElement("datasetRun", this.getNamespace());
        this.writer.addEncodedAttribute("subDataset", datasetRun.getDatasetName());
        if (this.isNewerVersionOrEqual("4.6.0")) {
            this.writer.addEncodedAttribute("uuid", datasetRun.getUUID().toString());
            this.writeProperties(datasetRun);
        }
        this.writeExpression("parametersMapExpression", datasetRun.getParametersMapExpression(), false);
        JRDatasetParameter[] parameters = datasetRun.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                this.writeDatasetParameter(parameters[i]);
            }
        }
        this.writeExpression("connectionExpression", datasetRun.getConnectionExpression(), false);
        this.writeExpression("dataSourceExpression", datasetRun.getDataSourceExpression(), false);
        List<ReturnValue> returnValues = datasetRun.getReturnValues();
        if (returnValues != null && !returnValues.isEmpty()) {
            for (ReturnValue returnValue : returnValues) {
                this.writeReturnValue(returnValue);
            }
        }
        this.writer.closeElement();
    }

    public void writeFrame(JRFrame frame) throws IOException {
        this.writer.startElement("frame", this.getNamespace());
        this.writeReportElement(frame);
        this.writeBox(frame.getLineBox());
        this.writeChildElements(frame);
        this.writer.closeElement();
    }

    protected void writeHyperlinkParameters(JRHyperlinkParameter[] parameters) throws IOException {
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                JRHyperlinkParameter parameter = parameters[i];
                this.writeHyperlinkParameter(parameter);
            }
        }
    }

    protected void writeHyperlinkParameter(JRHyperlinkParameter parameter) throws IOException {
        if (parameter != null) {
            this.writer.startElement("hyperlinkParameter", JASPERREPORTS_NAMESPACE);
            this.writer.addEncodedAttribute("name", parameter.getName());
            this.writeExpression("hyperlinkParameterExpression", parameter.getValueExpression(), true, String.class.getName());
            this.writer.closeElement();
        }
    }

    public void writeHyperlink(String tagName, JRHyperlink hyperlink) throws IOException {
        this.writeHyperlink(tagName, null, hyperlink);
    }

    public void writeHyperlink(String tagName, XmlNamespace namespace, JRHyperlink hyperlink) throws IOException {
        if (hyperlink != null) {
            this.writer.startElement(tagName, namespace);
            this.writer.addEncodedAttribute("hyperlinkType", hyperlink.getLinkType(), HyperlinkTypeEnum.NONE.getName());
            this.writer.addEncodedAttribute("hyperlinkTarget", hyperlink.getLinkTarget(), HyperlinkTargetEnum.SELF.getName());
            this.writeExpression("hyperlinkReferenceExpression", JASPERREPORTS_NAMESPACE, hyperlink.getHyperlinkReferenceExpression(), false);
            this.writeExpression("hyperlinkWhenExpression", JASPERREPORTS_NAMESPACE, hyperlink.getHyperlinkWhenExpression(), false);
            this.writeExpression("hyperlinkAnchorExpression", JASPERREPORTS_NAMESPACE, hyperlink.getHyperlinkAnchorExpression(), false);
            this.writeExpression("hyperlinkPageExpression", JASPERREPORTS_NAMESPACE, hyperlink.getHyperlinkPageExpression(), false);
            this.writeExpression("hyperlinkTooltipExpression", JASPERREPORTS_NAMESPACE, hyperlink.getHyperlinkTooltipExpression(), false);
            this.writeHyperlinkParameters(hyperlink.getHyperlinkParameters());
            if (this.isNewerVersionOrEqual("3.5.1")) {
                this.writer.closeElement(true);
            } else {
                this.writer.closeElement();
            }
        }
    }

    @Override
    protected boolean toWriteConditionalStyles() {
        return true;
    }

    public JRXmlWriteHelper getXmlWriteHelper() {
        return this.writer;
    }

    public Writer getUnderlyingWriter() {
        return this.writer.getUnderlyingWriter();
    }

    public void writeComponentElement(JRComponentElement componentElement) throws IOException {
        ComponentKey componentKey = componentElement.getComponentKey();
        ComponentXmlWriter componentXmlWriter = ComponentsEnvironment.getInstance(this.jasperReportsContext).getManager(componentKey).getComponentXmlWriter(this.jasperReportsContext);
        if (componentXmlWriter.isToWrite(componentElement, this)) {
            this.writer.startElement("componentElement", this.getNamespace());
            this.writeReportElement(componentElement);
            componentXmlWriter.writeToXml(componentElement, this);
            this.writer.closeElement();
        }
    }

    protected XmlNamespace getNamespace() {
        return JASPERREPORTS_NAMESPACE;
    }

    public void writeGenericElement(JRGenericElement element) throws IOException {
        if (this.isNewerVersionOrEqual("3.1.0")) {
            this.writer.startElement("genericElement", this.getNamespace());
            this.writer.addAttribute("evaluationTime", element.getEvaluationTimeValue(), EvaluationTimeEnum.NOW);
            if (element.getEvaluationGroupName() != null) {
                this.writer.addEncodedAttribute("evaluationGroup", element.getEvaluationGroupName());
            }
            this.writeReportElement(element);
            this.writer.startElement("genericElementType");
            JRGenericElementType printKey = element.getGenericType();
            if (printKey != null) {
                this.writer.addEncodedAttribute("namespace", printKey.getNamespace());
                this.writer.addEncodedAttribute("name", printKey.getName());
            }
            this.writer.closeElement();
            JRGenericElementParameter[] params = element.getParameters();
            for (int i = 0; i < params.length; ++i) {
                JRGenericElementParameter param = params[i];
                this.writer.startElement("genericElementParameter");
                this.writer.addEncodedAttribute("name", param.getName());
                this.writer.addAttribute("skipWhenNull", param.isSkipWhenEmpty(), false);
                JRExpression valueExpression = param.getValueExpression();
                if (valueExpression != null) {
                    this.writeExpression("valueExpression", valueExpression, true, Object.class.getName());
                }
                this.writer.closeElement();
            }
            this.writer.closeElement();
        }
    }

    public void writeMultiAxisData(MultiAxisData data) throws IOException {
        if (this.isNewerVersionOrEqual("4.8.0")) {
            this.writer.startElement("multiAxisData", this.getNamespace());
            this.writer.startElement("multiAxisDataset");
            this.writeElementDataset(data.getDataset());
            this.writer.closeElement();
            for (DataAxis dataAxis : data.getDataAxisList()) {
                this.writer.startElement("dataAxis");
                this.writer.addAttribute("axis", dataAxis.getAxis());
                for (DataAxisLevel level : dataAxis.getLevels()) {
                    this.writer.startElement("axisLevel");
                    this.writer.addAttribute("name", level.getName());
                    this.writer.writeExpression("labelExpression", level.getLabelExpression());
                    this.writeDataLevelBucket(level.getBucket());
                    this.writer.closeElement();
                }
                this.writer.closeElement();
            }
            for (DataMeasure measure : data.getMeasures()) {
                this.writer.startElement("multiAxisMeasure");
                this.writer.addAttribute("name", measure.getName());
                this.writer.addAttribute("class", measure.getValueClassName());
                this.writer.addAttribute("calculation", measure.getCalculation());
                this.writer.addAttribute("incrementerFactoryClass", measure.getIncrementerFactoryClassName());
                this.writer.writeExpression("labelExpression", measure.getLabelExpression());
                this.writer.writeExpression("valueExpression", measure.getValueExpression());
                this.writer.closeElement();
            }
            this.writer.closeElement();
        }
    }

    protected void writeDataLevelBucket(DataLevelBucket bucket) throws IOException {
        this.writer.startElement("axisLevelBucket");
        this.writer.addAttribute("order", bucket.getOrder(), BucketOrder.ASCENDING);
        this.writer.addAttribute("class", bucket.getValueClassName());
        this.writer.writeExpression("bucketExpression", bucket.getExpression());
        this.writer.writeExpression("comparatorExpression", bucket.getComparatorExpression());
        List<DataLevelBucketProperty> bucketProperties = bucket.getBucketProperties();
        if (bucketProperties != null) {
            for (DataLevelBucketProperty bucketProperty : bucketProperties) {
                JRExpression valueExpression = bucketProperty.getExpression();
                String expressionText = valueExpression == null ? "" : valueExpression.getText();
                this.writer.writeCDATAElement("bucketProperty", this.getNamespace(), expressionText, "name", bucketProperty.getName());
            }
        }
        this.writer.closeElement();
    }

    protected void writeExpression(String name, JRExpression expression, boolean writeClass, String defaultClassName) throws IOException {
        if (this.isNewerVersionOrEqual("4.1.1")) {
            this.writer.writeExpression(name, expression);
        } else {
            this.writer.writeExpression(name, expression, writeClass, defaultClassName);
        }
    }

    protected void writeExpression(String name, XmlNamespace namespace, JRExpression expression, boolean writeClass) throws IOException {
        if (this.isNewerVersionOrEqual("4.1.1")) {
            this.writer.writeExpression(name, namespace, expression);
        } else {
            this.writer.writeExpression(name, namespace, expression, writeClass);
        }
    }
}

