/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.logging.access;

import com.jaspersoft.jasperserver.api.logging.access.domain.AccessEvent;
import com.jaspersoft.jasperserver.api.logging.context.LoggableEvent;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.export.modules.BaseImporterModule;
import com.jaspersoft.jasperserver.export.modules.logging.access.AccessEventsImportHandler;
import com.jaspersoft.jasperserver.export.modules.logging.access.AccessModuleConfiguration;
import com.jaspersoft.jasperserver.export.modules.logging.access.beans.AccessEventBean;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public class AccessEventsImporter
extends BaseImporterModule {
    private AccessModuleConfiguration accessModuleConfiguration;
    private AccessEventsImportHandler accessEventsImportHandler;
    private ResourceFactory clientClassFactory;
    private String includeAccessEvents;
    private int logAccessEventsInterval;

    public String getIncludeAccessEvents() {
        return this.includeAccessEvents;
    }

    public void setIncludeAccessEvents(String includeAccessEvents) {
        this.includeAccessEvents = includeAccessEvents;
    }

    public void setAccessModuleConfiguration(AccessModuleConfiguration accessModuleConfiguration) {
        this.accessModuleConfiguration = accessModuleConfiguration;
    }

    public void setAccessEventsImportHandler(AccessEventsImportHandler accessEventsImportHandler) {
        this.accessEventsImportHandler = accessEventsImportHandler;
    }

    public void setClientClassFactory(ResourceFactory clientClassFactory) {
        this.clientClassFactory = clientClassFactory;
    }

    public void setLogAccessEventsInterval(int logAccessEventsInterval) {
        this.logAccessEventsInterval = logAccessEventsInterval;
    }

    @Override
    public List<String> process() {
        long count = 0L;
        long reallyImported = 0L;
        if (!this.hasParameter(this.includeAccessEvents)) {
            commandOut.info("Skip access events importing");
            return null;
        }
        Iterator it = this.indexElement.elementIterator(this.accessModuleConfiguration.getAccessEventIndexElement());
        while (it.hasNext()) {
            Element accessEventElement = (Element)it.next();
            String countString = accessEventElement.getText();
            count = Long.valueOf(countString);
        }
        if (count > 0L) {
            for (long i = 1L; i <= count; ++i) {
                boolean isSaved = this.process(String.valueOf(i));
                if (isSaved) {
                    ++reallyImported;
                }
                if (reallyImported % (long)this.logAccessEventsInterval != 0L) continue;
                commandOut.info("Next " + this.logAccessEventsInterval + " accessEvents has been imported");
            }
            commandOut.info(reallyImported + " accessEvents has been imported successfully");
        }
        return null;
    }

    protected String getAccessEventFileName(String accessEventId) {
        return accessEventId + ".xml";
    }

    protected boolean process(String accessEventId) {
        AccessEventBean accessEventBean = (AccessEventBean)this.deserialize(this.accessModuleConfiguration.getAccessEventsDirectory(), this.getAccessEventFileName(accessEventId), this.accessModuleConfiguration.getSerializer());
        AccessEvent accessEvent = (AccessEvent)this.clientClassFactory.newObject(AccessEvent.class);
        accessEventBean.copyTo(accessEvent, this.accessEventsImportHandler);
        if (accessEvent.getUser() != null && accessEvent.getResource() != null) {
            this.accessModuleConfiguration.getAccessService().saveEvent((LoggableEvent)accessEvent);
            return true;
        }
        return false;
    }
}

