/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.logging.access.beans;

import com.jaspersoft.jasperserver.api.logging.access.domain.AccessEvent;
import com.jaspersoft.jasperserver.export.modules.common.TenantQualifiedName;
import com.jaspersoft.jasperserver.export.modules.logging.access.AccessEventsImportHandler;
import java.util.Date;

public class AccessEventBean {
    private String userName;
    private String tenantId;
    private Date eventDate;
    private boolean updating;
    private String resourceUri;

    public void copyFrom(AccessEvent accessEvent) {
        this.setUserName(accessEvent.getUser().getUsername());
        String tenantId = accessEvent.getUser().getTenantId();
        this.setTenantId(tenantId != null ? tenantId : "");
        this.setEventDate(accessEvent.getEventDate());
        this.setUpdating(accessEvent.isUpdating());
        this.setResourceUri(accessEvent.getResource().getURI());
    }

    public void copyTo(AccessEvent accessEvent, AccessEventsImportHandler accessImportHandler) {
        accessEvent.setUser(accessImportHandler.resolveUser(new TenantQualifiedName(this.getTenantId(), this.getUserName())));
        accessEvent.setEventDate(this.getEventDate());
        accessEvent.setUpdating(this.isUpdating());
        accessEvent.setResource(accessImportHandler.resolveResource(this.getResourceUri()));
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public Date getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public void setUpdating(boolean updating) {
        this.updating = updating;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }
}

