/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.mt;

import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.export.modules.BaseImporterModule;
import com.jaspersoft.jasperserver.export.modules.mt.TenantModuleConfiguration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;

public class TenantImporter
extends BaseImporterModule {
    private static final Log log = LogFactory.getLog(TenantImporter.class);
    private TenantModuleConfiguration moduleConfiguration;
    private String updateArg;

    @Override
    public List<String> process() {
        Iterator it = this.indexElement.elementIterator(this.moduleConfiguration.getTenantIndexElement());
        while (it.hasNext()) {
            Element tenantElement = (Element)it.next();
            String tenantId = tenantElement.getText();
            this.process(tenantId);
        }
        return null;
    }

    protected Boolean isMultitenancyFeatureSupported() {
        return true;
    }

    protected void process(String tenantId) {
        Tenant existingTenant = this.getTenantService().getTenant(this.executionContext, tenantId);
        if (existingTenant != null) {
            if (this.hasParameter(this.getUpdateArg())) {
                Tenant tenant = (Tenant)this.deserialize(this.getModuleConfiguration().getTenantsDirectory(), this.getTenantFileName(tenantId), this.getModuleConfiguration().getTenantSerializer());
                this.updateTenant(existingTenant, tenant);
            } else {
                commandOut.info("Tenant " + tenantId + " already exists, skipping");
            }
        } else {
            Integer tenantsCount = this.getTenantService().getNumberOfTenants(this.executionContext);
            Boolean canImportOrganization = true;
            if (tenantsCount >= 1 && !this.isMultitenancyFeatureSupported().booleanValue()) {
                canImportOrganization = false;
            }
            if (canImportOrganization.booleanValue()) {
                Tenant tenant;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deserializing tenant " + tenantId));
                }
                if ((tenant = (Tenant)this.deserialize(this.getModuleConfiguration().getTenantsDirectory(), this.getTenantFileName(tenantId), this.getModuleConfiguration().getTenantSerializer())).getAlias() == null) {
                    tenant.setAlias(tenant.getId());
                }
                if (tenant.getTheme() == null) {
                    tenant.setTheme(this.getModuleConfiguration().getTenantExportConfiguration().getDefaultThemeName());
                }
                this.getTenantService().putTenant(this.executionContext, tenant);
                commandOut.info("Imported tenant " + tenantId);
            } else {
                commandOut.warn("This feature is unavailable under the current license. Please contact support at Jaspersoft.com for help.");
            }
        }
    }

    protected String getTenantFileName(String tenantId) {
        return tenantId + ".xml";
    }

    protected TenantService getTenantService() {
        return this.getModuleConfiguration().getTenantService();
    }

    private void updateTenant(Tenant existing, Tenant newTenant) {
        existing.setParentId(newTenant.getParentId());
        existing.setTenantDesc(newTenant.getTenantDesc());
        existing.setTenantFolderUri(newTenant.getTenantFolderUri());
        existing.setTenantName(newTenant.getTenantName());
        existing.setTenantNote(newTenant.getTenantNote());
        existing.setTenantUri(existing.getTenantUri());
        existing.setAttributes(newTenant.getAttributes());
        if (newTenant.getAlias() != null) {
            existing.setAlias(newTenant.getAlias());
        }
        if (newTenant.getTheme() != null) {
            existing.setTheme(newTenant.getTheme());
        }
        this.getTenantService().putTenant(this.executionContext, existing);
        commandOut.info("Updated tenant " + existing.getId());
    }

    public TenantModuleConfiguration getModuleConfiguration() {
        return this.moduleConfiguration;
    }

    public void setModuleConfiguration(TenantModuleConfiguration moduleConfiguration) {
        this.moduleConfiguration = moduleConfiguration;
    }

    public String getUpdateArg() {
        return this.updateArg;
    }

    public void setUpdateArg(String updateArg) {
        this.updateArg = updateArg;
    }
}

