/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.repository.beans;

import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceExportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceBean;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceReferenceBean;

public class InputControlBean
extends ResourceBean {
    private byte type;
    private boolean mandatory;
    private boolean readOnly;
    private boolean visible = true;
    private ResourceReferenceBean dataType;
    private ResourceReferenceBean listOfValues;
    private ResourceReferenceBean query;
    private String[] queryVisibleColumns;
    private String queryValueColumn;
    private Object defaultValue;

    @Override
    protected void additionalCopyFrom(Resource res, ResourceExportHandler export) {
        InputControl ic = (InputControl)res;
        this.setType(ic.getType());
        this.setMandatory(ic.isMandatory());
        this.setReadOnly(ic.isReadOnly());
        this.setVisible(ic.isVisible());
        this.setDataType(export.handleReference(ic.getDataType()));
        this.setListOfValues(export.handleReference(ic.getListOfValues()));
        this.setQuery(export.handleReference(ic.getQuery()));
        this.setQueryVisibleColumns(ic.getQueryVisibleColumns());
        this.setQueryValueColumn(ic.getQueryValueColumn());
        this.setDefaultValue(ic.getDefaultValue());
    }

    @Override
    protected void additionalCopyTo(Resource res, ResourceImportHandler importHandler) {
        InputControl ic = (InputControl)res;
        ic.setType(this.getType());
        ic.setMandatory(this.isMandatory());
        ic.setReadOnly(this.isReadOnly());
        ic.setVisible(this.isVisible());
        ic.setDataType(importHandler.handleReference(this.getDataType()));
        ic.setListOfValues(importHandler.handleReference(this.getListOfValues()));
        ic.setQuery(importHandler.handleReference(this.getQuery()));
        this.copyQueryColsTo(ic);
        ic.setQueryValueColumn(this.getQueryValueColumn());
        ic.setDefaultValue(this.getDefaultValue());
    }

    protected void copyQueryColsTo(InputControl ic) {
        if (this.queryVisibleColumns != null) {
            for (int i = 0; i < this.queryVisibleColumns.length; ++i) {
                String column = this.queryVisibleColumns[i];
                ic.addQueryVisibleColumn(column);
            }
        }
    }

    public ResourceReferenceBean getDataType() {
        return this.dataType;
    }

    public void setDataType(ResourceReferenceBean dataType) {
        this.dataType = dataType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public ResourceReferenceBean getListOfValues() {
        return this.listOfValues;
    }

    public void setListOfValues(ResourceReferenceBean listOfValues) {
        this.listOfValues = listOfValues;
    }

    public ResourceReferenceBean getQuery() {
        return this.query;
    }

    public void setQuery(ResourceReferenceBean query) {
        this.query = query;
    }

    public String getQueryValueColumn() {
        return this.queryValueColumn;
    }

    public void setQueryValueColumn(String queryValueColumn) {
        this.queryValueColumn = queryValueColumn;
    }

    public String[] getQueryVisibleColumns() {
        return this.queryVisibleColumns;
    }

    public void setQueryVisibleColumns(String[] queryVisibleColumns) {
        this.queryVisibleColumns = queryVisibleColumns;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

