/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.teiid.CommandContext;
import org.teiid.PolicyDecider;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.impl.DataPolicyMetadata;

public class DataRolePolicyDecider
implements PolicyDecider {
    private boolean allowCreateTemporaryTablesByDefault = false;
    private boolean allowFunctionCallsByDefault = false;

    public Set<String> getInaccessibleResources(DataPolicy.PermissionType action, Set<String> resources, DataPolicy.Context context, CommandContext commandContext) {
        if (action == DataPolicy.PermissionType.EXECUTE && context == DataPolicy.Context.FUNCTION && this.allowFunctionCallsByDefault) {
            return Collections.emptySet();
        }
        ArrayList policies = new ArrayList(commandContext.getAllowedDataPolicies().values());
        int policyCount = policies.size();
        Iterator<String> iter = resources.iterator();
        block0: while (iter.hasNext()) {
            String resource = iter.next();
            if (action != DataPolicy.PermissionType.LANGUAGE) {
                resource = resource.toLowerCase();
            }
            while (resource.length() > 0) {
                boolean isFalse = false;
                for (int j = 0; j < policyCount; ++j) {
                    DataPolicyMetadata policy = (DataPolicyMetadata)policies.get(j);
                    Boolean allows = policy.allows(resource, action);
                    if (allows == null) continue;
                    if (allows.booleanValue()) {
                        iter.remove();
                        continue block0;
                    }
                    isFalse = true;
                }
                if (isFalse || action == DataPolicy.PermissionType.LANGUAGE) continue block0;
                resource = resource.substring(0, Math.max(0, resource.lastIndexOf(46)));
            }
        }
        return resources;
    }

    public boolean hasRole(String roleName, CommandContext context) {
        return context.getAllowedDataPolicies().containsKey(roleName);
    }

    public boolean isTempAccessable(DataPolicy.PermissionType action, String resource, DataPolicy.Context context, CommandContext commandContext) {
        Boolean result = null;
        for (DataPolicy p : commandContext.getAllowedDataPolicies().values()) {
            DataPolicyMetadata policy = (DataPolicyMetadata)p;
            if (policy.isAllowCreateTemporaryTables() == null) continue;
            if (policy.isAllowCreateTemporaryTables().booleanValue()) {
                return true;
            }
            result = policy.isAllowCreateTemporaryTables();
        }
        if (result != null) {
            return result;
        }
        return this.allowCreateTemporaryTablesByDefault;
    }

    public void setAllowCreateTemporaryTablesByDefault(boolean allowCreateTemporaryTablesByDefault) {
        this.allowCreateTemporaryTablesByDefault = allowCreateTemporaryTablesByDefault;
    }

    public void setAllowFunctionCallsByDefault(boolean allowFunctionCallsDefault) {
        this.allowFunctionCallsByDefault = allowFunctionCallsDefault;
    }

    public boolean validateCommand(CommandContext commandContext) {
        return !commandContext.getVdb().getDataPolicies().isEmpty();
    }
}

