/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class Option
implements LanguageObject {
    public static final String MAKEDEP = "MAKEDEP";
    public static final String MAKENOTDEP = "MAKENOTDEP";
    public static final String OPTIONAL = "optional";
    private List<String> makeDependentGroups;
    private List<String> makeNotDependentGroups;
    private List<String> noCacheGroups;
    private boolean noCache;

    public void addDependentGroup(String group) {
        if (this.makeDependentGroups == null) {
            this.makeDependentGroups = new ArrayList<String>();
        }
        this.makeDependentGroups.add(group);
    }

    public List<String> getDependentGroups() {
        return this.makeDependentGroups;
    }

    public void addNotDependentGroup(String group) {
        if (this.makeNotDependentGroups == null) {
            this.makeNotDependentGroups = new ArrayList<String>();
        }
        this.makeNotDependentGroups.add(group);
    }

    public List<String> getNotDependentGroups() {
        return this.makeNotDependentGroups;
    }

    public void addNoCacheGroup(String group) {
        if (this.noCacheGroups == null) {
            this.noCacheGroups = new ArrayList<String>();
        }
        this.noCacheGroups.add(group);
    }

    public List<String> getNoCacheGroups() {
        return this.noCacheGroups;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Option)) {
            return false;
        }
        Option other = (Option)obj;
        return this.noCache == other.noCache && EquivalenceUtil.areEqual(this.getDependentGroups(), other.getDependentGroups()) && EquivalenceUtil.areEqual(this.getNotDependentGroups(), other.getNotDependentGroups()) && EquivalenceUtil.areEqual(this.getNoCacheGroups(), other.getNoCacheGroups());
    }

    public int hashCode() {
        int hc = 0;
        if (this.getDependentGroups() != null) {
            hc = HashCodeUtil.hashCode((int)hc, (Object[])new Object[]{this.getDependentGroups()});
        }
        if (this.getNotDependentGroups() != null) {
            hc = HashCodeUtil.hashCode((int)hc, (Object[])new Object[]{this.getNotDependentGroups()});
        }
        if (this.getNoCacheGroups() != null) {
            hc = HashCodeUtil.hashCode((int)hc, (Object[])new Object[]{this.getNoCacheGroups()});
        }
        return hc;
    }

    @Override
    public Object clone() {
        Option newOption = new Option();
        newOption.setNoCache(this.noCache);
        if (this.getDependentGroups() != null) {
            newOption.makeDependentGroups = new ArrayList<String>(this.getDependentGroups());
        }
        if (this.getNotDependentGroups() != null) {
            newOption.makeNotDependentGroups = new ArrayList<String>(this.getNotDependentGroups());
        }
        if (this.getNoCacheGroups() != null) {
            newOption.noCacheGroups = new ArrayList<String>(this.getNoCacheGroups());
        }
        return newOption;
    }
}

