/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.teiid.client.ResizingArrayList;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.XMLType;
import org.teiid.jdbc.JDBCPlugin;

public class BatchSerializer {
    static final byte CURRENT_VERSION = 2;
    private static ColumnSerializer defaultSerializer = new ColumnSerializer();
    private static final Map<String, ColumnSerializer[]> serializers = new HashMap<String, ColumnSerializer[]>(128);
    private static ColumnSerializer arrayColumnSerializer;
    private static final ColumnSerializer arrayColumnSerialier2;
    private static final int MAX_UTF = 21845;
    static int DATE_NORMALIZER;
    public static final long MIN_DATE_32;
    public static final long MAX_DATE_32;
    public static final long MIN_TIME_32;
    public static final long MAX_TIME_32;

    private BatchSerializer() {
    }

    static void writeIsNullData(ObjectOutput out, int col, List<? extends List<?>> batch) throws IOException {
        int numBytes = batch.size() / 8;
        int row = 0;
        int currentByte = 0;
        int byteNum = 0;
        while (byteNum < numBytes) {
            int n = currentByte = batch.get(row).get(col) == null ? 128 : 0;
            if (batch.get(row + 1).get(col) == null) {
                currentByte |= 0x40;
            }
            if (batch.get(row + 2).get(col) == null) {
                currentByte |= 0x20;
            }
            if (batch.get(row + 3).get(col) == null) {
                currentByte |= 0x10;
            }
            if (batch.get(row + 4).get(col) == null) {
                currentByte |= 8;
            }
            if (batch.get(row + 5).get(col) == null) {
                currentByte |= 4;
            }
            if (batch.get(row + 6).get(col) == null) {
                currentByte |= 2;
            }
            if (batch.get(row + 7).get(col) == null) {
                currentByte |= 1;
            }
            out.write(currentByte);
            ++byteNum;
            row += 8;
        }
        if (batch.size() % 8 > 0) {
            currentByte = 0;
            int mask = 128;
            while (row < batch.size()) {
                if (batch.get(row).get(col) == null) {
                    currentByte |= mask;
                }
                ++row;
                mask >>= 1;
            }
            out.write(currentByte);
        }
    }

    static void writeIsNullData(ObjectOutput out, int offset, Object[] batch) throws IOException {
        int currentByte = 0;
        int mask = 128;
        while (offset < batch.length) {
            if (batch[offset] == null) {
                currentByte |= mask;
            }
            ++offset;
            mask >>= 1;
        }
        out.write(currentByte);
    }

    static void readIsNullData(ObjectInput in, byte[] isNullBytes) throws IOException {
        for (int i = 0; i < isNullBytes.length; ++i) {
            isNullBytes[i] = in.readByte();
        }
    }

    static final boolean isNullObject(byte[] isNull, int row) {
        return (isNull[row / 8] & 1 << 7 - row % 8) != 0;
    }

    private static final boolean isNullObject(int row, byte b) {
        return (b & 1 << 7 - row % 8) != 0;
    }

    private static ColumnSerializer getSerializer(String type, byte version) {
        ColumnSerializer[] sers = serializers.get(type);
        if (sers == null) {
            if (DataTypeManager.isArrayType((String)type)) {
                if (version < 2) {
                    return arrayColumnSerializer;
                }
                return arrayColumnSerialier2;
            }
            return defaultSerializer;
        }
        return sers[Math.min(version, sers.length - 1)];
    }

    public static void writeBatch(ObjectOutput out, String[] types, List<? extends List<?>> batch) throws IOException {
        BatchSerializer.writeBatch(out, types, batch, (byte)2);
    }

    public static void writeBatch(ObjectOutput out, String[] types, List<? extends List<?>> batch, byte version) throws IOException {
        if (batch == null) {
            out.writeInt(-1);
        } else {
            if (version > 0 && batch.size() > 0) {
                out.writeInt(-batch.size() - 1);
                out.writeByte(version);
            } else {
                out.writeInt(batch.size());
            }
            if (batch.size() > 0) {
                int columns = types.length;
                out.writeInt(columns);
                for (int i = 0; i < columns; ++i) {
                    ColumnSerializer serializer = BatchSerializer.getSerializer(types[i], version);
                    try {
                        serializer.writeColumn(out, i, batch);
                        continue;
                    }
                    catch (ClassCastException e) {
                        Object obj = null;
                        String objectClass = null;
                        for (int row = 0; row < batch.size(); ++row) {
                            obj = batch.get(row).get(i);
                            if (obj == null) continue;
                            objectClass = obj.getClass().getName();
                            break;
                        }
                        throw new TeiidRuntimeException((BundleUtil.Event)JDBCPlugin.Event.TEIID20001, JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID20001, new Object[]{types[i], new Integer(i), objectClass}));
                    }
                }
            }
        }
    }

    public static List<List<Object>> readBatch(ObjectInput in, String[] types) throws IOException, ClassNotFoundException {
        int rows = in.readInt();
        if (rows == 0) {
            return new ArrayList<List<Object>>(0);
        }
        if (rows == -1) {
            return null;
        }
        byte version = 0;
        if (rows < 0) {
            rows = -(rows + 1);
            version = in.readByte();
        }
        int columns = in.readInt();
        ResizingArrayList<List<Object>> batch = new ResizingArrayList<List<Object>>(rows);
        int numBytes = rows / 8;
        int extraRows = rows % 8;
        for (int currentRow = 0; currentRow < rows; ++currentRow) {
            batch.add(currentRow, Arrays.asList(new Object[columns]));
        }
        byte[] isNullBuffer = new byte[extraRows > 0 ? numBytes + 1 : numBytes];
        for (int col = 0; col < columns; ++col) {
            BatchSerializer.getSerializer(types[col], version).readColumn(in, col, batch, isNullBuffer);
        }
        return batch;
    }

    static {
        serializers.put("bigdecimal", new ColumnSerializer[]{new BigDecimalColumnSerializer()});
        serializers.put("biginteger", new ColumnSerializer[]{new BigIntegerColumnSerializer()});
        serializers.put("boolean", new ColumnSerializer[]{new BooleanColumnSerializer()});
        serializers.put("byte", new ColumnSerializer[]{new ByteColumnSerializer()});
        serializers.put("char", new ColumnSerializer[]{new CharColumnSerializer()});
        serializers.put("date", new ColumnSerializer[]{new DateColumnSerializer(), new DateColumnSerializer1(), new DateColumnSerializer()});
        serializers.put("double", new ColumnSerializer[]{new DoubleColumnSerializer()});
        serializers.put("float", new ColumnSerializer[]{new FloatColumnSerializer()});
        serializers.put("integer", new ColumnSerializer[]{new IntColumnSerializer()});
        serializers.put("long", new ColumnSerializer[]{new LongColumnSerializer()});
        serializers.put("short", new ColumnSerializer[]{new ShortColumnSerializer()});
        serializers.put("time", new ColumnSerializer[]{new TimeColumnSerializer(), new TimeColumnSerializer1(), new TimeColumnSerializer()});
        serializers.put("timestamp", new ColumnSerializer[]{new TimestampColumnSerializer()});
        serializers.put("string", new ColumnSerializer[]{defaultSerializer, new StringColumnSerializer1()});
        serializers.put("clob", new ColumnSerializer[]{defaultSerializer, new ClobColumnSerializer1()});
        serializers.put("blob", new ColumnSerializer[]{defaultSerializer, new BlobColumnSerializer1()});
        serializers.put("xml", new ColumnSerializer[]{defaultSerializer, new XmlColumnSerializer1()});
        serializers.put("null", new ColumnSerializer[]{defaultSerializer, new NullColumnSerializer1()});
        serializers.put("object", new ColumnSerializer[]{defaultSerializer, new ObjectColumnSerializer(19, 1)});
        serializers.put("varbinary", new ColumnSerializer[]{new BinaryColumnSerializer(), new BinaryColumnSerializer1()});
        arrayColumnSerializer = new ColumnSerializer(){

            @Override
            protected void writeObject(ObjectOutput out, Object obj) throws IOException {
                try {
                    super.writeObject(out, ((java.sql.Array)obj).getArray());
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }

            @Override
            protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
                return new ArrayImpl((Object[])in.readObject());
            }
        };
        arrayColumnSerialier2 = new ArrayColumnSerializer2(new ObjectColumnSerializer(19, 2));
        DATE_NORMALIZER = 0;
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("GMT"));
        c.set(1900, 0, 1, 0, 0, 0);
        c.set(14, 0);
        MIN_DATE_32 = c.getTimeInMillis();
        MAX_DATE_32 = MIN_DATE_32 + 257698037700000L;
        DATE_NORMALIZER = -((int)(MIN_DATE_32 / 60000L));
        MAX_TIME_32 = 2147483647000L;
        MIN_TIME_32 = -2147483648000L;
    }

    private static class TimestampColumnSerializer
    extends ColumnSerializer {
        private TimestampColumnSerializer() {
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            Timestamp ts = (Timestamp)obj;
            out.writeLong(ts.getTime());
            out.writeInt(ts.getNanos());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            Timestamp ts = new Timestamp(in.readLong());
            ts.setNanos(in.readInt());
            return ts;
        }
    }

    private static class TimeColumnSerializer1
    extends ColumnSerializer {
        private TimeColumnSerializer1() {
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            long time = ((Time)obj).getTime();
            if (time < MIN_TIME_32 || time > MAX_TIME_32) {
                throw new IOException(JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID20029, new Object[]{obj.getClass().getName()}));
            }
            out.writeInt((int)(time / 1000L));
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return new Time(((long)in.readInt() & 0xFFFFFFFFL) * 1000L);
        }
    }

    private static class DateColumnSerializer1
    extends ColumnSerializer {
        private DateColumnSerializer1() {
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            long time = ((Date)obj).getTime();
            if (time < MIN_DATE_32 || time > MAX_DATE_32) {
                throw new IOException(JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID20029, new Object[]{obj.getClass().getName()}));
            }
            out.writeInt((int)(time / 60000L) + DATE_NORMALIZER);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return new Date((((long)in.readInt() & 0xFFFFFFFFL) - (long)DATE_NORMALIZER) * 60000L);
        }
    }

    private static class TimeColumnSerializer
    extends ColumnSerializer {
        private TimeColumnSerializer() {
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeLong(((Time)obj).getTime());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return new Time(in.readLong());
        }
    }

    private static class DateColumnSerializer
    extends ColumnSerializer {
        private DateColumnSerializer() {
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeLong(((Date)obj).getTime());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return new Date(in.readLong());
        }
    }

    private static class BigDecimalColumnSerializer
    extends ColumnSerializer {
        private BigDecimalColumnSerializer() {
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            BigDecimal val = (BigDecimal)obj;
            out.writeInt(val.scale());
            BigInteger unscaled = val.unscaledValue();
            byte[] bytes = unscaled.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            int scale = in.readInt();
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            return new BigDecimal(new BigInteger(bytes), scale);
        }
    }

    private static class BigIntegerColumnSerializer
    extends ColumnSerializer {
        private BigIntegerColumnSerializer() {
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            BigInteger val = (BigInteger)obj;
            byte[] bytes = val.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            return new BigInteger(bytes);
        }
    }

    private static class CharColumnSerializer
    extends ColumnSerializer {
        private CharColumnSerializer() {
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeChar(((Character)obj).charValue());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return Character.valueOf(in.readChar());
        }
    }

    private static class ByteColumnSerializer
    extends ColumnSerializer {
        private ByteColumnSerializer() {
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeByte(((Byte)obj).byteValue());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return in.readByte();
        }
    }

    private static class BooleanColumnSerializer
    extends ColumnSerializer {
        private BooleanColumnSerializer() {
        }

        @Override
        public void writeColumn(ObjectOutput out, int col, List<? extends List<?>> batch) throws IOException {
            int currentByte = 0;
            int mask = 128;
            for (int row = 0; row < batch.size(); ++row) {
                Object obj = batch.get(row).get(col);
                if (obj == null) {
                    currentByte |= mask;
                }
                if ((mask >>= 1) == 0) {
                    out.write(currentByte);
                    currentByte = 0;
                    mask = 128;
                }
                if (obj == null) continue;
                if (((Boolean)obj).booleanValue()) {
                    currentByte |= mask;
                }
                if ((mask >>= 1) != 0) continue;
                out.write(currentByte);
                currentByte = 0;
                mask = 128;
            }
            if (mask != 128) {
                out.write(currentByte);
            }
        }

        @Override
        public void readColumn(ObjectInput in, int col, List<List<Object>> batch, byte[] isNull) throws IOException, ClassNotFoundException {
            int currentByte = 0;
            int mask = 0;
            for (int row = 0; row < batch.size(); ++row) {
                if (mask == 0) {
                    currentByte = in.read();
                    mask = 128;
                }
                boolean isNullVal = (currentByte & mask) != 0;
                mask >>= 1;
                if (isNullVal) continue;
                if (mask == 0) {
                    currentByte = in.read();
                    mask = 128;
                }
                batch.get(row).set(col, (currentByte & mask) == 0 ? Boolean.FALSE : Boolean.TRUE);
                mask >>= 1;
            }
        }
    }

    private static class ShortColumnSerializer
    extends ColumnSerializer {
        private ShortColumnSerializer() {
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeShort(((Short)obj).shortValue());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return in.readShort();
        }
    }

    private static class DoubleColumnSerializer
    extends ColumnSerializer {
        private DoubleColumnSerializer() {
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeDouble((Double)obj);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return new Double(in.readDouble());
        }
    }

    private static class FloatColumnSerializer
    extends ColumnSerializer {
        private FloatColumnSerializer() {
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeFloat(((Float)obj).floatValue());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return new Float(in.readFloat());
        }
    }

    private static class LongColumnSerializer
    extends ColumnSerializer {
        private LongColumnSerializer() {
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeLong((Long)obj);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return in.readLong();
        }
    }

    private static class IntColumnSerializer
    extends ColumnSerializer {
        private IntColumnSerializer() {
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeInt((Integer)obj);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return in.readInt();
        }
    }

    private static class ColumnSerializer {
        private ColumnSerializer() {
        }

        public void writeColumn(ObjectOutput out, int col, List<? extends List<?>> batch) throws IOException {
            BatchSerializer.writeIsNullData(out, col, batch);
            Object obj = null;
            for (int i = 0; i < batch.size(); ++i) {
                obj = batch.get(i).get(col);
                if (obj == null) continue;
                this.writeObject(out, obj);
            }
        }

        public void readColumn(ObjectInput in, int col, List<List<Object>> batch, byte[] isNull) throws IOException, ClassNotFoundException {
            BatchSerializer.readIsNullData(in, isNull);
            for (int i = 0; i < batch.size(); ++i) {
                if (BatchSerializer.isNullObject(isNull, i)) continue;
                batch.get(i).set(col, DataTypeManager.getCanonicalValue((Object)this.readObject(in)));
            }
        }

        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeObject(obj);
        }

        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readObject();
        }
    }

    private static class XmlColumnSerializer1
    extends ColumnSerializer {
        private XmlColumnSerializer1() {
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            ((XMLType)obj).writeExternal(out, (byte)2);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            XMLType xt = new XMLType();
            xt.readExternal(in, (byte)2);
            return xt;
        }
    }

    private static class BlobColumnSerializer1
    extends ColumnSerializer {
        private BlobColumnSerializer1() {
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            ((Externalizable)obj).writeExternal(out);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            BlobType bt = new BlobType();
            bt.readExternal(in);
            return bt;
        }
    }

    private static class ClobColumnSerializer1
    extends ColumnSerializer {
        private ClobColumnSerializer1() {
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            ((Externalizable)obj).writeExternal(out);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            ClobType ct = new ClobType();
            ct.readExternal(in);
            return ct;
        }
    }

    private static class NullColumnSerializer1
    extends ColumnSerializer {
        private NullColumnSerializer1() {
        }

        @Override
        public void writeColumn(ObjectOutput out, int col, List<? extends List<?>> batch) throws IOException {
        }

        @Override
        public void readColumn(ObjectInput in, int col, List<List<Object>> batch, byte[] isNull) throws IOException, ClassNotFoundException {
        }
    }

    private static class StringColumnSerializer1
    extends ColumnSerializer {
        private StringColumnSerializer1() {
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            String str = (String)obj;
            if (str.length() <= 21845) {
                out.writeByte(116);
                out.writeUTF(str);
            } else {
                out.writeByte(124);
                out.writeObject(obj);
            }
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            if (in.readByte() == 116) {
                return in.readUTF();
            }
            return super.readObject(in);
        }
    }

    public static final class ObjectColumnSerializer
    extends ColumnSerializer {
        int highestKnownCode;
        byte version;

        public ObjectColumnSerializer(int highestKnownCode, byte version) {
            this.highestKnownCode = highestKnownCode;
            this.version = version;
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            int code = DataTypeManager.getTypeCode(obj.getClass());
            out.writeByte((byte)code);
            this.writeObject(out, obj, code);
        }

        protected void writeObject(ObjectOutput out, Object obj, int code) throws IOException {
            if (code == 2) {
                if (Boolean.TRUE.equals(obj)) {
                    out.write(1);
                } else {
                    out.write(0);
                }
            } else if (code <= this.highestKnownCode && code != 14) {
                ColumnSerializer s = BatchSerializer.getSerializer(DataTypeManager.getDataTypeName(obj.getClass()), this.version);
                s.writeObject(out, obj);
            } else {
                super.writeObject(out, obj);
            }
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            byte code = in.readByte();
            return this.readObject(in, code);
        }

        private Object readObject(ObjectInput in, int code) throws IOException, ClassNotFoundException {
            if (code == 2) {
                if (in.readByte() == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            if (code != 14) {
                ColumnSerializer s = BatchSerializer.getSerializer(DataTypeManager.getDataTypeName((Class)DataTypeManager.getClass((int)code)), this.version);
                return s.readObject(in);
            }
            return super.readObject(in);
        }
    }

    static class BinaryColumnSerializer
    extends ColumnSerializer {
        BinaryColumnSerializer() {
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            super.writeObject(out, ((BinaryType)obj).getBytesDirect());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            byte[] bytes = (byte[])super.readObject(in);
            return new BinaryType(bytes);
        }
    }

    static class BinaryColumnSerializer1
    extends ColumnSerializer {
        BinaryColumnSerializer1() {
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            byte[] bytes = ((BinaryType)obj).getBytes();
            out.writeInt(bytes.length);
            out.write(bytes);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            return new BinaryType(bytes);
        }
    }

    private static final class ArrayColumnSerializer2
    extends ColumnSerializer {
        ObjectColumnSerializer ser;

        public ArrayColumnSerializer2(ObjectColumnSerializer ser) {
            this.ser = ser;
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            Object[] values = null;
            try {
                values = (Object[])((java.sql.Array)obj).getArray();
            }
            catch (SQLException e) {
                out.writeInt(-1);
                return;
            }
            out.writeInt(values.length);
            int code = DataTypeManager.getTypeCode(values.getClass().getComponentType());
            out.writeByte((byte)code);
            int i = 0;
            while (i < values.length) {
                BatchSerializer.writeIsNullData(out, i, values);
                int end = Math.min(values.length, i + 8);
                while (i < end) {
                    if (values[i] != null) {
                        this.ser.writeObject(out, values[i], code);
                    }
                    ++i;
                }
            }
            out.writeBoolean(obj instanceof ArrayImpl && ((ArrayImpl)obj).isZeroBased());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            int length = in.readInt();
            if (length == -1) {
                return new ArrayImpl(null);
            }
            byte code = in.readByte();
            Object[] vals = (Object[])Array.newInstance(DataTypeManager.getClass((int)code), length);
            int i = 0;
            while (i < length) {
                byte b = in.readByte();
                int end = Math.min(length, i + 8);
                while (i < end) {
                    if (!BatchSerializer.isNullObject(i, b)) {
                        vals[i] = this.ser.readObject(in, code);
                    }
                    ++i;
                }
            }
            ArrayImpl result = new ArrayImpl(vals);
            result.setZeroBased(in.readBoolean());
            return result;
        }
    }
}

