/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionFactory;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.FileConnection;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;

@Translator(name="file", description="File Translator, reads contents of files or writes to them")
public class FileExecutionFactory
extends ExecutionFactory<ConnectionFactory, FileConnection> {
    public static BundleUtil UTIL = BundleUtil.getBundleUtil(FileExecutionFactory.class);
    public static final String GETTEXTFILES = "getTextFiles";
    public static final String GETFILES = "getFiles";
    public static final String SAVEFILE = "saveFile";
    private Charset encoding = Charset.defaultCharset();
    private boolean exceptionIfFileNotFound = true;

    public FileExecutionFactory() {
        this.setSourceRequiredForMetadata(false);
    }

    @TranslatorProperty(display="File Encoding", advanced=true)
    public String getEncoding() {
        return this.encoding.name();
    }

    public void setEncoding(String encoding) {
        this.encoding = Charset.forName(encoding);
    }

    @TranslatorProperty(display="Exception if file not found", advanced=true)
    public boolean isExceptionIfFileNotFound() {
        return this.exceptionIfFileNotFound;
    }

    public void setExceptionIfFileNotFound(boolean exceptionIfFileNotFound) {
        this.exceptionIfFileNotFound = exceptionIfFileNotFound;
    }

    public ProcedureExecution createProcedureExecution(final Call command, ExecutionContext executionContext, RuntimeMetadata metadata, final FileConnection fc) throws TranslatorException {
        if (command.getProcedureName().equalsIgnoreCase(SAVEFILE)) {
            return new ProcedureExecution(){

                public void execute() throws TranslatorException {
                    String filePath = (String)((Argument)command.getArguments().get(0)).getArgumentValue().getValue();
                    Object file = ((Argument)command.getArguments().get(1)).getArgumentValue().getValue();
                    if (file == null || filePath == null) {
                        throw new TranslatorException(UTIL.getString("non_null"));
                    }
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Saving", filePath});
                    InputStream is = null;
                    try {
                        if (file instanceof SQLXML) {
                            is = ((SQLXML)file).getBinaryStream();
                        } else if (file instanceof Clob) {
                            is = new ReaderInputStream(((Clob)file).getCharacterStream(), FileExecutionFactory.this.encoding);
                        } else if (file instanceof Blob) {
                            is = ((Blob)file).getBinaryStream();
                        } else {
                            throw new TranslatorException(UTIL.getString("unknown_type"));
                        }
                        ObjectConverterUtil.write((InputStream)is, (File)fc.getFile(filePath));
                    }
                    catch (IOException e) {
                        throw new TranslatorException((Throwable)e, UTIL.getString("error_writing"));
                    }
                    catch (SQLException e) {
                        throw new TranslatorException((Throwable)e, UTIL.getString("error_writing"));
                    }
                    catch (ResourceException e) {
                        throw new TranslatorException((Throwable)e, UTIL.getString("error_writing"));
                    }
                }

                public void close() {
                }

                public void cancel() throws TranslatorException {
                }

                public List<?> next() throws TranslatorException, DataNotAvailableException {
                    return null;
                }

                public List<?> getOutputParameterValues() throws TranslatorException {
                    return Collections.emptyList();
                }
            };
        }
        return new FileProcedureExecution(command, fc);
    }

    public void getMetadata(MetadataFactory metadataFactory, FileConnection connection) throws TranslatorException {
        Procedure p = metadataFactory.addProcedure(GETTEXTFILES);
        p.setAnnotation("Returns text files that match the given path and pattern as CLOBs");
        ProcedureParameter param = metadataFactory.addProcedureParameter("pathAndPattern", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("The path and pattern of what files to return.  Currently the only pattern supported is *.<ext>, which returns only the files matching the given extension at the given path.");
        metadataFactory.addProcedureResultSetColumn("file", "clob", p);
        metadataFactory.addProcedureResultSetColumn("filePath", "string", p);
        Procedure p1 = metadataFactory.addProcedure(GETFILES);
        p1.setAnnotation("Returns text files that match the given path and pattern as BLOBs");
        param = metadataFactory.addProcedureParameter("pathAndPattern", "string", ProcedureParameter.Type.In, p1);
        param.setAnnotation("The path and pattern of what files to return.  Currently the only pattern supported is *.<ext>, which returns only the files matching the given extension at the given path.");
        metadataFactory.addProcedureResultSetColumn("file", "blob", p1);
        metadataFactory.addProcedureResultSetColumn("filePath", "string", p1);
        Procedure p2 = metadataFactory.addProcedure(SAVEFILE);
        p2.setAnnotation("Saves the given vale to the given path.  Any existing file will be overriden.");
        metadataFactory.addProcedureParameter("filePath", "string", ProcedureParameter.Type.In, p2);
        param = metadataFactory.addProcedureParameter("file", "object", ProcedureParameter.Type.In, p2);
        param.setAnnotation("The contents to save.  Can be one of CLOB, BLOB, or XML");
    }

    public boolean areLobsUsableAfterClose() {
        return true;
    }

    private final class FileProcedureExecution
    implements ProcedureExecution {
        private final Call command;
        private final FileConnection fc;
        private File[] files = null;
        boolean isText = false;
        private int index;

        private FileProcedureExecution(Call command, FileConnection fc) {
            this.command = command;
            this.fc = fc;
        }

        public void execute() throws TranslatorException {
            String path = (String)((Argument)this.command.getArguments().get(0)).getArgumentValue().getValue();
            try {
                this.files = FileConnection.Util.getFiles((String)path, (FileConnection)this.fc);
            }
            catch (ResourceException e) {
                throw new TranslatorException((Throwable)e);
            }
            if (this.files == null && FileExecutionFactory.this.exceptionIfFileNotFound) {
                throw new TranslatorException(UTIL.getString("file_not_found", new Object[]{path}));
            }
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Getting", this.files != null ? this.files.length : 0, "file(s)"});
            String name = this.command.getProcedureName();
            if (name.equalsIgnoreCase(FileExecutionFactory.GETTEXTFILES)) {
                this.isText = true;
            } else if (!name.equalsIgnoreCase(FileExecutionFactory.GETFILES)) {
                throw new TeiidRuntimeException("Unknown procedure name " + name);
            }
        }

        public void close() {
        }

        public void cancel() throws TranslatorException {
        }

        public List<?> next() throws TranslatorException, DataNotAvailableException {
            if (this.files == null || this.index >= this.files.length) {
                return null;
            }
            ArrayList<Object> result = new ArrayList<Object>(2);
            File file = this.files[this.index++];
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Getting", file});
            InputStreamFactory.FileInputStreamFactory isf = new InputStreamFactory.FileInputStreamFactory(file);
            isf.setLength(file.length());
            BlobType value = null;
            if (this.isText) {
                ClobImpl clob = new ClobImpl((InputStreamFactory)isf, -1L);
                clob.setEncoding(FileExecutionFactory.this.encoding.name());
                value = new ClobType((Clob)clob);
            } else {
                value = new BlobType((Blob)new BlobImpl((InputStreamFactory)isf));
            }
            result.add(value);
            result.add(file.getName());
            return result;
        }

        public List<?> getOutputParameterValues() throws TranslatorException {
            return Collections.emptyList();
        }
    }
}

