/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.filter;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResourceItem;
import com.jaspersoft.jasperserver.api.search.SearchCriteria;
import com.jaspersoft.jasperserver.api.search.SearchCriteriaFactory;
import com.jaspersoft.jasperserver.api.search.SearchFilter;
import com.jaspersoft.jasperserver.api.search.SearchSorter;
import java.util.List;
import java.util.Map;

public class ResourceTypeSearchCriteriaFactory
implements SearchCriteriaFactory,
Cloneable {
    private ResourceFactory persistentClassMappings;
    private Map<String, SearchFilter> typeSpecificFilters;
    private String resourceType;

    public SearchCriteriaFactory newFactory(String type) {
        try {
            ResourceTypeSearchCriteriaFactory newOne = (ResourceTypeSearchCriteriaFactory)this.clone();
            if (this.resourceType != null) {
                Class<?> oldClass;
                Class<?> classToReplace = Class.forName(type);
                if (!classToReplace.isAssignableFrom(oldClass = Class.forName(this.resourceType))) {
                    newOne.setResourceType(type);
                }
            } else {
                newOne.setResourceType(type);
            }
            return newOne;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("unexpected", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("unexpected", e);
        }
    }

    public SearchCriteria create(ExecutionContext context, List<SearchFilter> filters) {
        Class clazz = this.resourceType == null ? RepoResourceItem.class : this.persistentClassMappings.getImplementationClass(this.resourceType);
        SearchCriteria searchCriteria = SearchCriteria.forClass(clazz);
        if (this.typeSpecificFilters.get(this.getResourceType()) != null) {
            this.typeSpecificFilters.get(this.getResourceType()).applyRestrictions(this.getResourceType(), context, searchCriteria);
        }
        if (filters != null) {
            for (SearchFilter filter : filters) {
                filter.applyRestrictions(this.getResourceType(), context, searchCriteria);
            }
        }
        return searchCriteria;
    }

    public void applySorter(ExecutionContext context, SearchCriteria searchCriteria, SearchSorter sorter) {
        String resourceType = this.getResourceType();
        if (sorter != null) {
            sorter.applyOrder(resourceType, context, searchCriteria);
        }
    }

    public void setPersistentClassMappings(ResourceFactory persistentClassMappings) {
        this.persistentClassMappings = persistentClassMappings;
    }

    public void setTypeSpecificFilters(Map<String, SearchFilter> typeSpecificFilters) {
        this.typeSpecificFilters = typeSpecificFilters;
    }

    public void setResourceType(String defaultResourceType) {
        this.resourceType = defaultResourceType;
    }

    public String getResourceType() {
        if (this.resourceType == null) {
            return Resource.class.getName();
        }
        return this.resourceType;
    }
}

