/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.helper;

import com.jaspersoft.jasperserver.search.model.permission.Permission;
import com.jaspersoft.jasperserver.search.model.permission.PermissionToDisplay;
import com.jaspersoft.jasperserver.search.model.permission.RoleWithPermission;
import com.jaspersoft.jasperserver.search.model.permission.UserWithPermission;
import com.jaspersoft.jasperserver.war.helper.JSONHelper;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PermissionJSONHelper
extends JSONHelper
implements Serializable {
    protected static final String PERMISSION_TO_DISPLAY = "permissionToDisplay";
    protected static final String IS_DISABLED = "isDisabled";
    protected static final String PERMISSION = "permission";
    protected static final String INHERITED_PERMISSION = "inheritedPermission";
    protected static final String IS_INHERITED = "isInherited";
    protected static final String TYPE = "type";
    protected static final String NEW_PERMISSION = "newPermission";

    public JSONObject createUserWithPermissionsJson(List<UserWithPermission> userWithPermissionList, String objectType) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        for (UserWithPermission userWithPermission : userWithPermissionList) {
            jsonArray.put((Object)this.createUserWithPermissionJson(userWithPermission));
        }
        jsonObject.put("entities", (Object)jsonArray);
        jsonObject.put(TYPE, (Object)objectType);
        return jsonObject;
    }

    private JSONObject createUserWithPermissionJson(UserWithPermission userWithPermission) throws JSONException {
        JSONObject jsonObject = this.convertUserToJson(userWithPermission.getUser(), null);
        JSONObject permissionToDisplay = this.convertPermissionToDisplayToJson(userWithPermission.getPermissionToDisplay());
        jsonObject.put(PERMISSION_TO_DISPLAY, (Object)permissionToDisplay);
        return jsonObject;
    }

    private JSONObject convertPermissionToDisplayToJson(PermissionToDisplay permissionToDisplay) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        if (permissionToDisplay.getPermission() != null) {
            jsonObject.put(PERMISSION, (Object)permissionToDisplay.getPermission().name());
        }
        if (permissionToDisplay.getInheritedPermission() != null) {
            jsonObject.put(INHERITED_PERMISSION, (Object)permissionToDisplay.getInheritedPermission().name());
        }
        jsonObject.put(IS_INHERITED, permissionToDisplay.isInherited());
        jsonObject.put(IS_DISABLED, permissionToDisplay.isDisabled());
        return jsonObject;
    }

    public JSONObject createRoleWithPermissionsJson(List<RoleWithPermission> roleWithPermissionList, String objectType) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        for (RoleWithPermission roleWithPermission : roleWithPermissionList) {
            jsonArray.put((Object)this.createRoleWithPermissionJson(roleWithPermission));
        }
        jsonObject.put("entities", (Object)jsonArray);
        jsonObject.put(TYPE, (Object)objectType);
        return jsonObject;
    }

    private JSONObject createRoleWithPermissionJson(RoleWithPermission roleWithPermission) throws JSONException {
        JSONObject jsonObject = this.convertRoleToJson(roleWithPermission.getRole(), null);
        JSONObject permissionToDisplay = this.convertPermissionToDisplayToJson(roleWithPermission.getPermissionToDisplay());
        jsonObject.put(PERMISSION_TO_DISPLAY, (Object)permissionToDisplay);
        return jsonObject;
    }

    public Set<UserWithPermission> convertJsonArrayToUserWithPermissionSet(String json) throws JSONException {
        JSONArray array = new JSONArray(json);
        HashSet<UserWithPermission> userWithPermissionSet = new HashSet<UserWithPermission>(array.length());
        for (int i = 0; i < array.length(); ++i) {
            UserWithPermission userWithPermission = new UserWithPermission();
            userWithPermission.setUser(this.convertJsonToUser(array.getJSONObject(i)));
            userWithPermission.setPermissionToDisplay(this.convertJsonToPermissionToDisplay(this.getJsonObjectIfHas(array.getJSONObject(i), PERMISSION_TO_DISPLAY)));
            userWithPermissionSet.add(userWithPermission);
        }
        return userWithPermissionSet;
    }

    public Set<RoleWithPermission> convertJsonArrayToRoleWithPermissionSet(String json) throws JSONException {
        JSONArray array = new JSONArray(json);
        HashSet<RoleWithPermission> roleWithPermissionSet = new HashSet<RoleWithPermission>(array.length());
        for (int i = 0; i < array.length(); ++i) {
            RoleWithPermission roleWithPermission = new RoleWithPermission();
            roleWithPermission.setRole(this.convertJsonToRole(array.getJSONObject(i)));
            roleWithPermission.setPermissionToDisplay(this.convertJsonToPermissionToDisplay(this.getJsonObjectIfHas(array.getJSONObject(i), PERMISSION_TO_DISPLAY)));
            roleWithPermissionSet.add(roleWithPermission);
        }
        return roleWithPermissionSet;
    }

    private PermissionToDisplay convertJsonToPermissionToDisplay(JSONObject jsonObject) throws JSONException {
        PermissionToDisplay permissionToDisplay = new PermissionToDisplay();
        String permissionString = this.getPropertyIfHas(jsonObject, PERMISSION);
        permissionToDisplay.setPermission(permissionString != null ? Permission.valueOf(permissionString) : null);
        String newPermissionString = this.getPropertyIfHas(jsonObject, NEW_PERMISSION);
        permissionToDisplay.setNewPermission(newPermissionString != null ? Permission.valueOf(newPermissionString) : null);
        String inheritedPermissionString = this.getPropertyIfHas(jsonObject, INHERITED_PERMISSION);
        permissionToDisplay.setInheritedPermission(inheritedPermissionString != null ? Permission.valueOf(inheritedPermissionString) : null);
        permissionToDisplay.setInherited(Boolean.parseBoolean(this.getPropertyIfHas(jsonObject, IS_INHERITED)));
        return permissionToDisplay;
    }
}

