/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ResourceLookupImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.search.common.ItemsExistException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseService {
    private static final Log log = LogFactory.getLog(BaseService.class);
    protected RepositoryService repositoryService;

    protected boolean isObjectsLabelsExist(String parentFolderUri, Set<String> objectsLabels, String folderUri) {
        return !this.getExistingObjectLabels(parentFolderUri, objectsLabels, folderUri).isEmpty();
    }

    protected Set<String> getExistingObjectLabels(String parentFolderUri, Set<String> objectsLabels, String folderUri) {
        HashSet<String> existingLabels = new HashSet<String>();
        try {
            List repoFolderList = this.repositoryService.getSubFolders(null, parentFolderUri);
            FilterCriteria criteria = FilterCriteria.createFilter();
            criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)parentFolderUri));
            List resources = this.repositoryService.loadResourcesList(null, criteria);
            repoFolderList.addAll(resources);
            for (String objectLabel : objectsLabels) {
                if (!this.isLabelExist(objectLabel, repoFolderList, folderUri)) continue;
                existingLabels.add(objectLabel);
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        return existingLabels;
    }

    private boolean isLabelExist(String objectLabel, List repoFolderList, String folderUri) {
        for (int i = 0; i < repoFolderList.size(); ++i) {
            if (repoFolderList.get(i) instanceof FolderImpl) {
                FolderImpl repoFolder = (FolderImpl)repoFolderList.get(i);
                if (folderUri != null && folderUri.equals(repoFolder.getURIString()) || !objectLabel.equalsIgnoreCase(repoFolder.getLabel())) continue;
                return true;
            }
            if (!(repoFolderList.get(i) instanceof ResourceLookupImpl)) continue;
            ResourceLookupImpl res = (ResourceLookupImpl)repoFolderList.get(i);
            if (folderUri != null && folderUri.equals(res.getURIString()) || !objectLabel.equalsIgnoreCase(res.getLabel())) continue;
            return true;
        }
        return false;
    }

    protected void ensureObjectLabelsNew(String parentFolderUri, Set<String> objectLabel) throws JSException, ItemsExistException {
        Set<String> existingLabels = this.getExistingObjectLabels(parentFolderUri, objectLabel, null);
        if (existingLabels.isEmpty()) {
            return;
        }
        throw new ItemsExistException(existingLabels);
    }

    protected boolean isObjectsLabelsExist(String parentFolderUri, Set<String> objectLabel) {
        return this.isObjectsLabelsExist(parentFolderUri, objectLabel, null);
    }

    protected boolean isObjectLabelExist(String parentFolderUri, String objectLabel, String folderUri) {
        HashSet<String> set = new HashSet<String>();
        set.add(objectLabel);
        return this.isObjectsLabelsExist(parentFolderUri, set, folderUri);
    }

    protected boolean isObjectLabelExist(String parentFolderUri, String objectLabel) {
        return this.isObjectLabelExist(parentFolderUri, objectLabel, null);
    }

    protected boolean isLabelsUnique(Map<String, Resource> resourceMap) {
        HashSet<String> labels = new HashSet<String>();
        for (Resource resource : resourceMap.values()) {
            labels.add(resource.getLabel().toLowerCase());
        }
        return resourceMap.size() == labels.size();
    }

    protected Map<String, Resource> getResourcesWithUniqueName(Map<String, Resource> resourceMap) {
        HashMap<String, Resource> resultMap = new HashMap<String, Resource>();
        HashSet<String> selected = new HashSet<String>();
        for (Map.Entry<String, Resource> entry : resourceMap.entrySet()) {
            String name = entry.getValue().getName();
            if (selected.contains(name)) continue;
            selected.add(name);
            resultMap.put(entry.getKey(), entry.getValue());
        }
        return resultMap;
    }

    protected Map<String, Resource> getResourceMap(Set<String> resourceUris) {
        HashMap<String, Resource> resourceMap = new HashMap<String, Resource>();
        for (String uri : resourceUris) {
            resourceMap.put(uri, this.repositoryService.getResource(null, uri));
        }
        return resourceMap;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
}

