/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.filter;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.search.SearchCriteria;
import com.jaspersoft.jasperserver.search.common.SearchAttributes;
import com.jaspersoft.jasperserver.search.filter.BaseSearchFilter;
import com.jaspersoft.jasperserver.search.mode.AccessType;
import com.jaspersoft.jasperserver.search.service.RepositorySearchCriteria;
import java.io.Serializable;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class AccessTypeFilter
extends BaseSearchFilter
implements Serializable {
    public static final String ACCESS_TYPE_FILTER_NAME = "accessTypeFilter";
    public static final String ACCESS_TYPE_FILTER_ALL_OPTION = "accessTypeFilter-all";
    public static final String ACCESS_TYPE_FILTER_CHANGED_BY_ME_OPTION = "accessTypeFilter-changedByMe";

    public void applyRestrictions(String type, ExecutionContext context, SearchCriteria criteria) {
        RepositorySearchCriteria searchCriteria = this.getTypedAttribute(context, RepositorySearchCriteria.class);
        if (searchCriteria == null) {
            String accessFilter;
            SearchAttributes searchAttributes = this.getSearchAttributes(context);
            User user = null;
            if (context.getAttributes() != null) {
                for (Object o : context.getAttributes()) {
                    if (!(o instanceof User)) continue;
                    user = (User)o;
                }
            }
            if (user != null && searchAttributes != null && searchAttributes.getState() != null && (accessFilter = searchAttributes.getState().getCustomFiltersMap().get(ACCESS_TYPE_FILTER_NAME)) != null && !accessFilter.equals(ACCESS_TYPE_FILTER_ALL_OPTION)) {
                this.processCriteria(criteria, user, accessFilter.equals(ACCESS_TYPE_FILTER_CHANGED_BY_ME_OPTION));
            }
        } else if (!searchCriteria.getAccessType().equals((Object)AccessType.ALL)) {
            this.processCriteria(criteria, searchCriteria.getUser(), AccessType.MODIFIED.equals((Object)searchCriteria.getAccessType()));
        }
    }

    private void processCriteria(SearchCriteria criteria, User user, boolean modified) {
        String alias = criteria.getAlias("accessEvents", "ae");
        criteria.add((Criterion)Restrictions.eq((String)(alias + ".updating"), (Object)modified));
        String userAlias = criteria.getAlias(alias + ".user", "u");
        criteria.add((Criterion)Restrictions.eq((String)(userAlias + ".username"), (Object)user.getUsername()));
        String tenantId = user.getTenantId() == null ? "organizations" : user.getTenantId();
        String tenantAlias = criteria.getAlias(userAlias + ".tenant", "t");
        criteria.add((Criterion)Restrictions.eq((String)(tenantAlias + ".tenantId"), (Object)tenantId));
    }
}

