/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nux.xom.io.StaxUtil;

final class StaxReader
implements XMLStreamReader {
    private ParentNode root;
    private Node current;
    private int eventType;
    private final boolean isCoalescing;
    private String textValue;
    private static final boolean DEBUG = false;

    public StaxReader(Node root) {
        this(root, true);
    }

    private StaxReader(Node root, boolean isCoalescing) {
        if (root == null) {
            throw new IllegalArgumentException("root node must not be null");
        }
        this.isCoalescing = isCoalescing;
        this.current = root;
        this.setEventType(root);
        this.textValue = null;
        if (root instanceof Text) {
            this.textValue = root.getValue();
        }
        this.root = null;
        if (root instanceof ParentNode) {
            this.root = (ParentNode)root;
        }
    }

    public void close() throws XMLStreamException {
        this.root = null;
        this.current = null;
        this.textValue = null;
        this.eventType = 8;
    }

    public int getEventType() {
        return this.eventType;
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.root == null) {
            return false;
        }
        int ev = this.getEventType();
        return this.current != this.root || ev != 2 && ev != 8;
    }

    public int next() throws XMLStreamException {
        do {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Attempted to read beyond end of XML tree");
            }
            this.textValue = null;
            int i = 0;
            if (this.isEndElement() || this.current.getChildCount() <= 0) {
                if (this.isStartElement()) {
                    return this.setEventType(2);
                }
                i = this.current.getParent().indexOf(this.current) + 1;
                this.current = this.current.getParent();
                if (i >= this.current.getChildCount()) {
                    int ev = this.current == this.root && this.current instanceof Document ? 8 : 2;
                    return this.setEventType(ev);
                }
            }
            this.current = this.nextChild(i);
            this.setEventType(this.current);
        } while (this.textValue != null && this.textValue.length() == 0);
        return this.getEventType();
    }

    private Node nextChild(int i) {
        Node node = this.current.getChild(i);
        if (node instanceof Text) {
            this.textValue = node.getValue();
            if (this.isCoalescing) {
                Node n;
                int count = this.current.getChildCount();
                while (++i < count && (n = this.current.getChild(i)) instanceof Text) {
                    node = n;
                    this.textValue = String.valueOf(this.textValue) + node.getValue();
                }
            }
        }
        return node;
    }

    private int setEventType(Node node) {
        int ev;
        if (node instanceof Element) {
            ev = 1;
        } else if (node instanceof Text) {
            ev = 4;
        } else if (node instanceof Comment) {
            ev = 5;
        } else if (node instanceof Attribute) {
            ev = 10;
        } else if (node instanceof ProcessingInstruction) {
            ev = 3;
        } else if (node instanceof DocType) {
            ev = 11;
        } else if (node instanceof Document) {
            ev = 7;
        } else {
            throw new IllegalStateException("Cannot read node type: " + node);
        }
        return this.setEventType(ev);
    }

    private int setEventType(int eventType) {
        this.eventType = eventType;
        return eventType;
    }

    public int nextTag() throws XMLStreamException {
        block5: while (true) {
            int ev = this.next();
            switch (ev) {
                case 3: 
                case 5: 
                case 6: {
                    continue block5;
                }
                case 4: 
                case 12: {
                    if (this.isWhiteSpace()) continue block5;
                    this.throwXMLStreamException("Required whitespace-only CHARACTERS|CDATA");
                    continue block5;
                }
                case 1: 
                case 2: {
                    return ev;
                }
            }
            this.throwXMLStreamException("type", "START_ELEMENT|END_ELEMENT", StaxReader.toString(ev));
        }
    }

    public boolean isStartElement() {
        return this.getEventType() == 1;
    }

    public boolean isEndElement() {
        return this.getEventType() == 2;
    }

    public boolean isCharacters() {
        return this.getEventType() == 4;
    }

    public boolean isWhiteSpace() {
        return (this.isCharacters() || this.getEventType() == 12) && StaxReader.isWhitespaceOnly(this.getText());
    }

    private Element currentElement() {
        if (this.current instanceof Element) {
            return (Element)this.current;
        }
        this.throwIllegalStateException("START_ELEMENT|END_ELEMENT");
        return null;
    }

    private Element currentStartElement() {
        if (this.getEventType() != 1) {
            this.throwIllegalStateException("START_ELEMENT");
        }
        return (Element)this.current;
    }

    private ProcessingInstruction currentPI() {
        if (this.current instanceof ProcessingInstruction) {
            return (ProcessingInstruction)this.current;
        }
        this.throwIllegalStateException("PROCESSING_INSTRUCTION");
        return null;
    }

    private DocType currentDocType() {
        if (this.current instanceof DocType) {
            return (DocType)this.current;
        }
        this.throwIllegalStateException("DTD");
        return null;
    }

    private Attribute currentAttribute(int index) {
        if (this.getEventType() == 10) {
            return (Attribute)this.current;
        }
        return this.currentStartElement().getAttribute(index);
    }

    public String getLocalName() {
        return this.currentElement().getLocalName();
    }

    public String getPrefix() {
        String prefix = this.currentElement().getNamespacePrefix();
        return prefix;
    }

    public String getNamespaceURI() {
        String uri = this.currentElement().getNamespaceURI();
        return uri;
    }

    public QName getName() {
        return new QName(this.getNamespaceURI(), this.getLocalName(), this.getPrefix());
    }

    public int getAttributeCount() {
        if (this.getEventType() == 10) {
            return 1;
        }
        return this.currentStartElement().getAttributeCount();
    }

    public QName getAttributeName(int index) {
        return new QName(this.getAttributeNamespace(index), this.getAttributeLocalName(index), this.getAttributePrefix(index));
    }

    public String getAttributeNamespace(int index) {
        return this.currentAttribute(index).getNamespaceURI();
    }

    public String getAttributeLocalName(int index) {
        return this.currentAttribute(index).getLocalName();
    }

    public String getAttributePrefix(int index) {
        return this.currentAttribute(index).getNamespacePrefix();
    }

    public String getAttributeType(int index) {
        Attribute.Type attrType = this.currentAttribute(index).getType();
        if (attrType == Attribute.Type.ENUMERATION) {
            return "ENUMERATED";
        }
        return attrType.getName();
    }

    public String getAttributeValue(int index) {
        return this.currentAttribute(index).getValue();
    }

    public String getAttributeValue(String namespaceURI, String localName) {
        if (localName == null) {
            throw new IllegalArgumentException("localName must not be null");
        }
        if (this.getEventType() != 10 && namespaceURI != null) {
            return this.currentElement().getAttributeValue(localName, namespaceURI);
        }
        int count = this.getAttributeCount();
        int i = 0;
        while (i < count) {
            if (localName.equals(this.getAttributeLocalName(i)) && (namespaceURI == null || namespaceURI.equals(this.getAttributeNamespace(i)))) {
                return this.getAttributeValue(i);
            }
            ++i;
        }
        return null;
    }

    public boolean isAttributeSpecified(int index) {
        return false;
    }

    public String getElementText() throws XMLStreamException {
        this.require(1, null, null);
        String str = null;
        block7: while (true) {
            switch (this.next()) {
                case 2: {
                    return str == null ? "" : str;
                }
                case 4: 
                case 6: 
                case 9: 
                case 12: {
                    String text = this.getText();
                    str = str == null ? text : String.valueOf(str) + text;
                    continue block7;
                }
                case 3: 
                case 5: {
                    continue block7;
                }
                case 8: {
                    this.throwXMLStreamException("unexpected end of document when reading element text content");
                }
                case 1: {
                    this.throwXMLStreamException("element text content may not contain START_ELEMENT");
                }
            }
            this.throwXMLStreamException("Unexpected event type: " + StaxReader.toString(this.getEventType()));
        }
    }

    public int getNamespaceCount() {
        return this.currentElement().getNamespaceDeclarationCount();
    }

    public String getNamespacePrefix(int index) {
        String prefix = this.currentElement().getNamespacePrefix(index);
        return prefix;
    }

    public String getNamespaceURI(int index) {
        return this.getNamespaceURI(this.getNamespacePrefix(index));
    }

    public String getNamespaceURI(String prefix) {
        return StaxReader.getNamespaceURI(prefix, this.currentElement());
    }

    private static String getNamespaceURI(String prefix, Element elem) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix must not be null");
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return elem.getNamespaceURI(prefix);
    }

    public NamespaceContext getNamespaceContext() {
        return new NamespaceContextImpl(this.currentElement());
    }

    public String getPITarget() {
        return this.currentPI().getTarget();
    }

    public String getPIData() {
        return this.currentPI().getValue();
    }

    public String getText() {
        switch (this.getEventType()) {
            case 4: {
                return this.textValue;
            }
            case 12: {
                return this.textValue;
            }
            case 6: {
                return this.textValue;
            }
            case 5: {
                return this.current.getValue();
            }
            case 11: {
                return this.currentDocType().toXML();
            }
        }
        this.throwIllegalStateException("CHARACTERS|CDATA|SPACE|COMMENT|DTD");
        return null;
    }

    public char[] getTextCharacters() {
        return this.getText().toCharArray();
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        String text = this.getText();
        int sourceEnd = Math.min(text.length(), sourceStart + length);
        text.getChars(sourceStart, sourceEnd, target, targetStart);
        return sourceEnd - sourceStart;
    }

    public int getTextStart() {
        return 0;
    }

    public int getTextLength() {
        return this.getText().length();
    }

    public boolean hasName() {
        return this.isStartElement() || this.isEndElement();
    }

    public boolean hasText() {
        switch (this.getEventType()) {
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public String getEncoding() {
        return null;
    }

    public Location getLocation() {
        return new UnknownLocation();
    }

    public String getVersion() {
        return null;
    }

    public boolean isStandalone() {
        return false;
    }

    public boolean standaloneSet() {
        return false;
    }

    public String getCharacterEncodingScheme() {
        return null;
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (name.equals("javax.xml.stream.isNamespaceAware")) {
            return Boolean.TRUE;
        }
        if (name.equals("javax.xml.stream.isCoalescing")) {
            return this.isCoalescing ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("javax.xml.stream.isValidating")) {
            return Boolean.FALSE;
        }
        if (name.equals("javax.xml.stream.isReplacingEntityReferences")) {
            return Boolean.TRUE;
        }
        if (name.equals("javax.xml.stream.isSupportingExternalEntities")) {
            return Boolean.TRUE;
        }
        if (name.equals("javax.xml.stream.supportDTD")) {
            return Boolean.TRUE;
        }
        if (name.equals("javax.xml.stream.reporter")) {
            return null;
        }
        if (name.equals("javax.xml.stream.resolver")) {
            return null;
        }
        if (name.equals("javax.xml.stream.allocator")) {
            return null;
        }
        throw new IllegalArgumentException("Unsupported property: " + name);
    }

    public Object getDTDInfo() {
        return new DTDInfo(this.currentDocType());
    }

    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        if (this.getEventType() != type) {
            this.throwXMLStreamException("type", StaxReader.toString(type), StaxReader.toString(this.getEventType()));
        }
        if (localName != null && !localName.equals(this.getLocalName())) {
            this.throwXMLStreamException("localName", localName, this.getLocalName());
        }
        if (namespaceURI != null && !namespaceURI.equals(this.getNamespaceURI())) {
            this.throwXMLStreamException("namespaceURI", namespaceURI, this.getNamespaceURI());
        }
    }

    private void throwIllegalStateException(String expected) {
        throw new IllegalStateException("Required type: " + expected + ", actual type: " + StaxReader.toString(this.getEventType()));
    }

    private void throwXMLStreamException(String msg, String expected, String actual) throws XMLStreamException {
        msg = "Required " + msg + ":'" + expected + "', actual " + msg + ":'" + actual + "'";
        this.throwXMLStreamException(msg);
    }

    private void throwXMLStreamException(String msg) throws XMLStreamException {
        throw new XMLStreamException(msg, this.getLocation());
    }

    private static boolean isWhitespaceOnly(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (StaxReader.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhitespace(char c) {
        switch (c) {
            case '\t': {
                return true;
            }
            case '\n': {
                return true;
            }
            case '\r': {
                return true;
            }
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private static String toNull(String str) {
        return str != null && str.length() > 0 ? str : null;
    }

    private static String toEmpty(String str) {
        return str == null ? "" : str;
    }

    public String toString() {
        return StaxReader.toString(this.getEventType());
    }

    private static String toString(int ev) {
        return StaxUtil.toString(ev);
    }

    private static final class NamespaceContextImpl
    implements NamespaceContext {
        private final Element element;

        private NamespaceContextImpl(Element element) {
            this.element = element;
        }

        public String getNamespaceURI(String prefix) {
            return StaxReader.getNamespaceURI(prefix, this.element);
        }

        public String getPrefix(String namespaceURI) {
            Iterator iter = this.getPrefixes(namespaceURI);
            if (iter.hasNext()) {
                return (String)iter.next();
            }
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            ParentNode parent;
            if (namespaceURI == null) {
                throw new IllegalArgumentException("namespaceURI must not be null");
            }
            if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
                return NamespaceContextImpl.getSingletonIterator("xml");
            }
            if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
                return NamespaceContextImpl.getSingletonIterator("xmlns");
            }
            ArrayList<String> prefixes = new ArrayList<String>(1);
            Element elem = this.element;
            do {
                int count = elem.getNamespaceDeclarationCount();
                int i = 0;
                while (i < count) {
                    String prefix = elem.getNamespacePrefix(i);
                    String uri = elem.getNamespaceURI(prefix);
                    if (namespaceURI.equals(uri) && !prefixes.contains(prefix)) {
                        prefixes.add(prefix);
                    }
                    ++i;
                }
            } while ((elem = (parent = elem.getParent()) instanceof Element ? (Element)parent : null) != null);
            return Collections.unmodifiableList(prefixes).iterator();
        }

        private static Iterator getSingletonIterator(String str) {
            List<String> prefixes = Arrays.asList(str);
            return Collections.unmodifiableList(prefixes).iterator();
        }
    }

    private final class UnknownLocation
    implements Location {
        private UnknownLocation() {
        }

        public int getLineNumber() {
            return -1;
        }

        public int getColumnNumber() {
            return -1;
        }

        public int getCharacterOffset() {
            return -1;
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            String systemID = null;
            if (StaxReader.this.root != null && (systemID = StaxReader.this.root.getBaseURI()) != null && systemID.length() == 0) {
                systemID = null;
            }
            return systemID;
        }
    }

    private static final class DTDInfo {
        private final DocType docType;

        private DTDInfo(DocType docType) {
            this.docType = docType;
        }

        public String getDTDRootName() {
            return this.docType.getRootElementName();
        }

        public String getDTDSystemId() {
            return this.docType.getSystemID();
        }

        public String getDTDPublicId() {
            return this.docType.getPublicID();
        }

        public String getDTDInternalSubset() {
            return this.docType.getInternalDTDSubset();
        }
    }
}

