/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.pool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import nux.xom.pool.DocumentURIResolver;
import nux.xom.pool.FileUtil;
import nux.xom.xquery.XQuery;
import nux.xom.xquery.XQueryException;

public class XQueryFactory {
    private final Charset charset;
    private final DocumentURIResolver resolver;

    public XQueryFactory() {
        this(null, null);
    }

    public XQueryFactory(Charset charset, DocumentURIResolver resolver) {
        this.charset = charset;
        this.resolver = resolver;
    }

    public XQuery createXQuery(File query) throws XQueryException, IOException {
        return this.createXQuery(query, query.toURI());
    }

    public XQuery createXQuery(File query, URI baseURI) throws XQueryException, IOException {
        return this.createXQuery(new FileInputStream(query), baseURI);
    }

    public XQuery createXQuery(String query, URI baseURI) throws XQueryException {
        return new XQuery(query, baseURI, null, this.resolver);
    }

    public XQuery createXQuery(InputStream query, URI baseURI) throws XQueryException, IOException {
        String str = FileUtil.toString(query, this.charset);
        return this.createXQuery(str, baseURI);
    }
}

