/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.tests;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.Version;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ParsingException;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nu.xom.xinclude.XIncludeException;
import nu.xom.xinclude.XIncluder;
import nux.xom.binary.BinaryXMLCodec;
import nux.xom.pool.BuilderFactory;
import nux.xom.pool.BuilderPool;
import nux.xom.pool.DocumentFactory;
import nux.xom.pool.DocumentMap;
import nux.xom.pool.DocumentPool;
import nux.xom.pool.DocumentURIResolver;
import nux.xom.pool.FileUtil;
import nux.xom.pool.PoolConfig;
import nux.xom.pool.XOMUtil;
import nux.xom.pool.XQueryFactory;
import nux.xom.pool.XQueryPool;
import nux.xom.tests.CmdLineProgram;
import nux.xom.xquery.ResultSequenceSerializer;
import nux.xom.xquery.StreamingPathFilter;
import nux.xom.xquery.StreamingPathFilterException;
import nux.xom.xquery.StreamingTransform;
import nux.xom.xquery.XQuery;
import nux.xom.xquery.XQueryUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.XMLReader;

public final class XQueryCommand
extends CmdLineProgram {
    private LongOpt[] longOpts = null;
    private StringBuffer sb = null;
    private String[] inputFiles = null;
    private Map variables = new HashMap();
    private List queries = new ArrayList();
    private URI baseURI = null;
    private List outputFiles = new ArrayList();
    private String algorithm = "w3c";
    private String encoding = "UTF-8";
    private int indent = 4;
    private boolean stripWhitespace = false;
    private boolean explain = false;
    private int runs = 1;
    private int iterations = 1;
    private long docPoolCapacity = 0L;
    private int docPoolCompression = -1;
    private boolean noBuilderPool = false;
    private boolean debug = false;
    private String validate = "wf";
    private String namespace = null;
    private File schema = null;
    private boolean xinclude = false;
    private Object update = null;
    private StreamingPathFilter filter = null;
    private String filterQuery = null;
    private boolean xomXPath = false;

    public static void main(String[] args) {
        new XQueryCommand().doMain(args);
    }

    private XQueryCommand() {
        this.initOptions();
    }

    private String getLongUsage() {
        String text = "\n" + this.getProgramName() + " - Nux XQuery test tool with optional schema validation.\n\n" + "Usage: " + this.getProgramName() + " " + this.getOptions() + "\n\n" + "Option names can be abbreviated as long as they remain unambigous.\n" + "Option cardinalities: '?' = 0..1, '*' = 0..N, '+' = 1..N, 'def' = default.\n\n" + "Help options:\n" + "  ? --version             Display the version of this program and exit.\n" + "  ? --help                Print this help page and exit.\n\n" + "Query options:\n" + "  + --query={STRING}|FILE The XQuery to execute.\n" + "  ? --base=FILE           Resolve relative URIs found in the XQuery (def='.').\n" + "  * --var=NAME:VALUE      Pass external variables to XQuery (def=none).\n\n" + "Output options:\n" + "  * --out=FILE|/dev/null  File(s) to serialize to (def=stdout).\n" + "  ? --algo=w3c|wrap       Result sequence serialization algorithm (def=w3c).\n" + "  ? --encoding=STRING     Character encoding to serialize with (def=UTF-8).\n" + "  ? --indent=INT          Insert prettyprint indentation; disable=0 (def=4).\n\n" + "Validation options for input documents:\n" + "  ? --validate=wf|dtd|schema|relaxng|html  Set validation language (def=wf).\n" + "  ? --schema=FILE         e.g. foo.dtd|foo.xsd|foo.rng (def=undefined).\n" + "  ? --namespace=URI       Namespace of schema (def=undefined).\n\n" + "Misc options:\n" + "  ? --update={STRING}|FILE Apply update XQuery to each item in result sequence.\n" + "  ? --xinclude            Perform W3C XInclude resolution on input files.\n" + "  ? --strip               Remove whitespace-only text nodes from input files.\n" + "  ? --noexternal          Disallow Java extension functions in XQuery.\n" + "  ? --filterpath=STRING   Streaming path filter, e.g. '/a/b/c' (def=none).\n" + "  ? --filterquery={STRING}|FILE XQuery transforming each filter match (def=.).\n" + "  ? --debug               Print full stack trace on exception.\n\n" + "Benchmarking options:\n" + "  ? --runs=INT            Repeat outer loop N times (def=1).\n" + "  ? --iterations=INT      Repeat inner loop M times (def=1).\n" + "  ? --docpoolcapacity=INT Allow at most N MB memory for document pool (def=0).\n" + "  ? --docpoolcompression=-1..9    Use document ZLIB compression level (def=-1).\n" + "  ? --nobuilderpool       Disable caching of SAX XMLReaders.\n" + "  ? --explain             Print description of optimized XQuery plan.\n" + "  ? --xomxpath            Use XOM's XPath engine instead of Nux's XPath engine.\n\n" + "Examples:\n" + "  " + "cd samples/data\n" + "  " + this.getProgramName() + " --query='{doc(\"periodic.xml\")/PERIODIC_TABLE/ATOM[NAME=\"Zinc\"]}'\n" + "  " + this.getProgramName() + " --query='{declare namespace atom = \"http://www.w3.org/2005/Atom\"; doc(\"http://www.tbray.org/ongoing/ongoing.atom\")/atom:feed/atom:entry/atom:title}'\n" + "  " + this.getProgramName() + " --query='{count(//*)}' *.xml\n" + "  " + this.getProgramName() + " --query='{count(//*)}' *.xml.bnux\n" + "  " + this.getProgramName() + " --algo=wrap --query='{//node(), //@*, \"Hello World!\"}' p2pio.xml\n" + "  " + this.getProgramName() + " --query=../xmark/q09.xq ../xmark/auction-0.01.xml --out=/tmp/results.out\n" + "  " + this.getProgramName() + " --var=x:2 --var=y:5 --query='{declare variable $x external; declare variable $y external; $x * $y}'\n" + "  " + this.getProgramName() + " --query='{/receive/timeout}' --update='{declare namespace system = \"java:java.lang.System\"; system:currentTimeMillis() + 10000}' p2pio.xml\n" + "  " + this.getProgramName() + " --xinclude --query='{.}' xinclude.xml\n" + "  " + this.getProgramName() + " --query=../fulltext/q2-06.xq ../fulltext/full-text.xml\n" + "  " + this.getProgramName() + " --validate=html --query='{//*:img/string(@src)}' ../../doc/index.html\n" + "  " + this.getProgramName() + " --query='{.}' --validate=relaxng --debug --schema=../data-atom/atom.rng ../data-atom/ongoing.xml\n" + "  " + this.getProgramName() + " --query='{.}' --validate=schema --namespace='http://openuri.org/easypo' --schema=ns-order.xsd ns-order.xml\n" + "  " + this.getProgramName() + " --query='{declare namespace util = \"java:nux.xom.pool.FileUtil\"; <files> {for $uri in util:listFiles(\"../shakespeare\", false(), \"*.xml\", \"\") let $kills := count(saxon:discard-document(doc(string($uri)))//LINE[contains(., \"kill\")]) order by $kills return <file><name>{$uri}</name> <killCount>{$kills}</killCount></file> }</files>}'\n" + "  " + this.getProgramName() + " --query='{.}' --validate=schema --namespace='http://openuri.org/easypo' --schema=ns-order.xsd ns-order.xml --out=/dev/null --iter=0 --runs=100000\n" + "  " + this.getProgramName() + " --query='{count(doc(\"periodic.xml\")//*)}' --out=/dev/null --indent=0 --iter=5000 --runs=5 --docpoolcapacity=100 --explain\n";
        boolean isWindows = System.getProperty("os.name").startsWith("Windows");
        if (isWindows) {
            char z = '\u0000';
            text = text.replace('\'', z);
            text = text.replace('\"', '\'');
            text = text.replace(z, '\"');
        }
        return text;
    }

    private void initOptions() {
        this.sb = new StringBuffer();
        ArrayList<LongOpt> options = new ArrayList<LongOpt>();
        options.add(new LongOpt("help", 0, null, 104));
        options.add(new LongOpt("version", 0, null, 118));
        options.add(new LongOpt("query", 1, this.sb, 113));
        options.add(new LongOpt("base", 1, this.sb, 98));
        options.add(new LongOpt("var", 1, this.sb, 80));
        options.add(new LongOpt("out", 1, this.sb, 111));
        options.add(new LongOpt("algo", 1, this.sb, 83));
        options.add(new LongOpt("encoding", 1, this.sb, 69));
        options.add(new LongOpt("indent", 1, this.sb, 73));
        options.add(new LongOpt("strip", 0, null, 115));
        options.add(new LongOpt("update", 1, this.sb, 117));
        options.add(new LongOpt("xinclude", 0, null, 120));
        options.add(new LongOpt("explain", 0, null, 101));
        options.add(new LongOpt("noexternal", 0, null, 110));
        options.add(new LongOpt("runs", 1, this.sb, 114));
        options.add(new LongOpt("iterations", 1, this.sb, 105));
        options.add(new LongOpt("docpoolcapacity", 1, this.sb, 67));
        options.add(new LongOpt("docpoolcompression", 1, this.sb, 68));
        options.add(new LongOpt("nobuilderpool", 0, null, 112));
        options.add(new LongOpt("debug", 0, null, 100));
        options.add(new LongOpt("validate", 1, this.sb, 86));
        options.add(new LongOpt("namespace", 1, this.sb, 87));
        options.add(new LongOpt("schema", 1, this.sb, 119));
        options.add(new LongOpt("filterpath", 1, this.sb, 102));
        options.add(new LongOpt("filterquery", 1, this.sb, 70));
        options.add(new LongOpt("xomxpath", 0, null, 78));
        this.longOpts = new LongOpt[options.size()];
        options.toArray(this.longOpts);
    }

    protected int parseArguments(String[] args) {
        int c;
        if (args.length == 0) {
            System.out.println(this.getLongUsage());
            return -1;
        }
        Getopt getopt = new Getopt(this.getProgramName(), args, ":", this.longOpts, true);
        while ((c = getopt.getopt()) != -1) {
            block3 : switch (c) {
                case 104: {
                    System.out.println(this.getLongUsage());
                    return -1;
                }
                case 118: {
                    System.out.println(this.getVersionInfo());
                    return -1;
                }
                case 115: {
                    this.stripWhitespace = true;
                    break;
                }
                case 120: {
                    this.xinclude = true;
                    break;
                }
                case 101: {
                    this.explain = true;
                    break;
                }
                case 110: {
                    System.setProperty("nux.xom.xquery.XQuery.allowExternalFunctions", "false");
                    break;
                }
                case 100: {
                    this.debug = true;
                    break;
                }
                case 112: {
                    this.noBuilderPool = true;
                    break;
                }
                case 78: {
                    this.xomXPath = true;
                    break;
                }
                case 0: {
                    String arg = getopt.getOptarg();
                    char val = (char)new Integer(this.sb.toString()).intValue();
                    String optionName = this.longOpts[getopt.getLongind()].getName();
                    switch (val) {
                        case 'q': {
                            arg = arg.trim();
                            if (arg.startsWith("{") && arg.endsWith("}")) {
                                this.queries.add(arg.substring(1, arg.length() - 1));
                                break block3;
                            }
                            if (arg.equals("nop")) {
                                this.queries.add(null);
                                break block3;
                            }
                            this.queries.add(XQueryCommand.parsePath(arg));
                            break block3;
                        }
                        case 'u': {
                            arg = arg.trim();
                            if (arg.startsWith("{") && arg.endsWith("}")) {
                                this.update = arg.substring(1, arg.length() - 1);
                                break block3;
                            }
                            this.update = XQueryCommand.parsePath(arg);
                            break block3;
                        }
                        case 'b': {
                            this.baseURI = XQueryCommand.parsePath(arg).toURI();
                            break block3;
                        }
                        case 'P': {
                            int i = arg.indexOf(58);
                            if (i < 0) {
                                throw new CmdLineProgram.UsageException("Missing name:value pair");
                            }
                            String name = arg.substring(0, i).trim();
                            String value = arg.substring(i + 1);
                            this.variables.put(name, value);
                            break block3;
                        }
                        case 'o': {
                            this.outputFiles.add(XQueryCommand.parsePath(arg));
                            break block3;
                        }
                        case 'S': {
                            arg = arg.trim();
                            this.checkValidity(arg, new String[]{"w3c", "wrap"}, optionName);
                            this.algorithm = arg;
                            break block3;
                        }
                        case 'E': {
                            this.encoding = arg.trim();
                            break block3;
                        }
                        case 'I': {
                            this.indent = Math.max(0, this.parseInt(arg, optionName));
                            break block3;
                        }
                        case 'r': {
                            this.runs = this.parseIntGreaterThanZero(arg, optionName);
                            break block3;
                        }
                        case 'i': {
                            this.iterations = Math.max(0, this.parseInt(arg, optionName));
                            break block3;
                        }
                        case 'C': {
                            this.docPoolCapacity = 0x100000L * (long)this.parseInt(arg, optionName);
                            break block3;
                        }
                        case 'D': {
                            this.docPoolCompression = this.parseInt(arg, optionName);
                            break block3;
                        }
                        case 'V': {
                            arg = arg.trim();
                            this.checkValidity(arg, new String[]{"wf", "dtd", "schema", "relaxng", "html"}, optionName);
                            this.validate = arg;
                            break block3;
                        }
                        case 'W': {
                            this.namespace = arg.trim();
                            break block3;
                        }
                        case 'w': {
                            this.schema = XQueryCommand.parsePath(arg).getAbsoluteFile();
                            break block3;
                        }
                        case 'f': {
                            try {
                                this.filter = new StreamingPathFilter(arg, null);
                                break block3;
                            }
                            catch (StreamingPathFilterException e) {
                                throw new CmdLineProgram.UsageException(e);
                            }
                        }
                        case 'F': {
                            arg = arg.trim();
                            if (arg.startsWith("{") && arg.endsWith("}")) {
                                this.filterQuery = arg.substring(1, arg.length() - 1);
                                break block3;
                            }
                            try {
                                this.filterQuery = FileUtil.toString(new FileInputStream(XQueryCommand.parsePath(arg)), null);
                                break block3;
                            }
                            catch (IOException e) {
                                throw new CmdLineProgram.UsageException(e);
                            }
                        }
                    }
                    throw new InternalError("Oops. Should never reach here. val='" + val + "'");
                }
                case 58: {
                    throw new CmdLineProgram.UsageException("Option '" + this.longOpts[getopt.getLongind()].getName() + "' requires an argument");
                }
                case 63: {
                    System.err.println(this.getLongUsage());
                    return -1;
                }
                default: {
                    throw new InternalError("Oops. Should never reach here. getopt() returned '" + (char)c + "'");
                }
            }
        }
        if (this.queries.size() == 0) {
            throw new CmdLineProgram.UsageException("Missing required argument --query");
        }
        this.inputFiles = this.parseNonOptionArguments(args, getopt.getOptind(), true, 0, Integer.MAX_VALUE);
        if (this.inputFiles.length == 0) {
            this.inputFiles = new String[1];
        }
        File file = null;
        if (this.outputFiles.size() > 0) {
            file = (File)this.outputFiles.get(0);
        }
        while (this.outputFiles.size() < this.inputFiles.length) {
            this.outputFiles.add(file);
        }
        if (this.filterQuery == null) {
            this.filterQuery = ".";
        }
        if (this.update != null) {
            this.docPoolCompression = Math.max(0, this.docPoolCompression);
        }
        if (this.xomXPath) {
            int i = 0;
            while (i < this.queries.size()) {
                Object query = this.queries.get(i);
                if (query instanceof File) {
                    try {
                        query = FileUtil.toString(new FileInputStream((File)query), null);
                    }
                    catch (IOException e) {
                        throw new CmdLineProgram.UsageException(e);
                    }
                }
                this.queries.set(i, query);
                ++i;
            }
        }
        return 0;
    }

    protected void run() throws Exception {
        try {
            boolean isBench2 = this.runs > 1;
            boolean isBench = this.runs > 1 && this.iterations > 0;
            final DocumentPool docPool = this.createDocumentPool(isBench);
            DocumentURIResolver resolver = new DocumentURIResolver(){

                public Document resolve(String href, String baseURI) throws ParsingException, IOException, TransformerException {
                    String systemID = new StandardURIResolver(null).resolve(href, baseURI).getSystemId();
                    return docPool.getDocument(URI.create(systemID));
                }
            };
            XQueryPool queryPool = new XQueryPool(new PoolConfig(), new XQueryFactory(null, resolver));
            ResultSequenceSerializer serializer = new ResultSequenceSerializer();
            serializer.setAlgorithm(this.algorithm);
            serializer.setEncoding(this.encoding);
            serializer.setIndent(this.indent);
            long runsStart = System.currentTimeMillis();
            int run = 0;
            while (run < this.runs) {
                if (isBench) {
                    System.out.println("\n\n******************************************");
                    System.out.println("run = " + run + ":");
                }
                int i = 0;
                while (i < this.queries.size()) {
                    long start = System.currentTimeMillis();
                    long serializationTime = 0L;
                    Object query = this.queries.get(i);
                    XQuery xquery = query instanceof String ? queryPool.getXQuery((String)query, this.baseURI) : (query instanceof File ? queryPool.getXQuery((File)query, this.baseURI) : null);
                    if (isBench) {
                        System.out.println("query = " + query);
                    }
                    if (this.explain && run == 0 && xquery != null) {
                        System.out.println("explain = \n" + xquery.explain());
                    }
                    XQuery morpher = this.update instanceof String ? queryPool.getXQuery((String)this.update, null) : (this.update instanceof File ? queryPool.getXQuery((File)this.update, null) : null);
                    int numSerials = 0;
                    int j = 0;
                    while (j < this.inputFiles.length) {
                        Document doc = null;
                        if (this.inputFiles[j] != null) {
                            doc = docPool.getDocument(new File(this.inputFiles[j]));
                        }
                        if (this.explain && doc != null) {
                            System.out.println("stats=" + XQueryCommand.toStatisticsString((Node)doc));
                        }
                        int iter = 0;
                        while (iter < this.iterations) {
                            block33: {
                                OutputStream out;
                                Nodes results;
                                block32: {
                                    Document doc2 = doc;
                                    if (morpher != null && doc2 != null) {
                                        doc2 = new Document(doc2);
                                    }
                                    if (this.xomXPath) {
                                        if (doc2 == null) {
                                            throw new CmdLineProgram.UsageException("A context node is required by XOM's XPath engine, but missing.");
                                        }
                                        results = doc2.query((String)query);
                                    } else if (xquery != null) {
                                        results = xquery.execute((Node)doc2, null, this.variables).toNodes();
                                    } else {
                                        results = new Nodes();
                                        results.append((Node)doc2);
                                    }
                                    if (morpher != null) {
                                        int k = 0;
                                        while (doc2 == null && k < results.size()) {
                                            doc2 = results.get(k).getDocument();
                                            ++k;
                                        }
                                        XQueryUtil.update(results, morpher, null);
                                        results = new Nodes();
                                        if (doc2 != null) {
                                            results.append((Node)doc2);
                                        }
                                    }
                                    File f = (File)this.outputFiles.get(j);
                                    out = System.out;
                                    if (f == null) break block32;
                                    if (f.getAbsolutePath().equals("/dev/null")) break block33;
                                    out = new FileOutputStream(f);
                                }
                                long serializationStart = System.currentTimeMillis();
                                serializer.write(results, out);
                                if (out != System.out && out != System.err) {
                                    out.close();
                                }
                                serializationTime += System.currentTimeMillis() - serializationStart;
                                ++numSerials;
                            }
                            ++iter;
                        }
                        ++j;
                    }
                    if (isBench && this.iterations > 0) {
                        long end = System.currentTimeMillis();
                        System.out.println("\nsecs = " + (float)(end - start) / 1000.0f);
                        System.out.println("queries/sec = " + (float)(this.inputFiles.length * this.iterations) / ((float)(end - start) / 1000.0f));
                        if (numSerials > 0) {
                            System.out.println("\nserialization secs = " + (float)serializationTime / 1000.0f);
                            System.out.println("serializations/sec = " + (float)numSerials / ((float)serializationTime / 1000.0f));
                        }
                    }
                    ++i;
                }
                ++run;
            }
            if (isBench2) {
                long runsEnd = System.currentTimeMillis();
                System.out.println("\n\n******************************************");
                System.out.println("total secs = " + (float)(runsEnd - runsStart) / 1000.0f);
                System.out.println("runs/sec = " + (float)this.runs / ((float)(runsEnd - runsStart) / 1000.0f));
            }
        }
        catch (RuntimeException e) {
            if (this.debug) {
                if (e instanceof CmdLineProgram.UsageException) {
                    e = new RuntimeException(e);
                }
                throw e;
            }
            throw new CmdLineProgram.UsageException(e);
        }
        catch (Exception e) {
            if (this.debug) {
                throw e;
            }
            throw new CmdLineProgram.UsageException(e);
        }
    }

    private DocumentPool createDocumentPool(final boolean isBench) {
        BuilderPool builderPool;
        PoolConfig config = new PoolConfig();
        if (this.noBuilderPool) {
            config.setMaxEntries(0);
        }
        if (this.filter == null) {
            builderPool = new BuilderPool(config, new BuilderFactory());
        } else {
            BuilderFactory builderFactory = new BuilderFactory(){

                protected Builder newBuilder(XMLReader parser, boolean validate) {
                    StreamingTransform myTransform = new StreamingTransform(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Nodes transform(Element subtree) {
                            return XQueryUtil.xquery((Node)subtree, XQueryCommand.access$0(2.access$0(this.this$1)));
                        }
                    };
                    return new Builder(parser, validate, XQueryCommand.this.filter.createNodeFactory(null, myTransform));
                }

                static /* synthetic */ XQueryCommand access$0(2 var0) {
                    return var0.XQueryCommand.this;
                }
            };
            builderPool = new BuilderPool(config, builderFactory);
        }
        DocumentFactory docFactory = new DocumentFactory(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Document createDocument(InputStream input, URI baseURI) throws ParsingException, IOException {
                Document doc;
                long start;
                block13: {
                    block14: {
                        start = System.currentTimeMillis();
                        if (baseURI == null || !baseURI.getPath().endsWith(".bnux")) break block14;
                        if (XQueryCommand.this.filter == null) {
                            doc = this.getBinaryXMLFactory().createDocument(input, baseURI);
                            break block13;
                        } else {
                            StreamingTransform myTransform = new StreamingTransform(this){
                                final /* synthetic */ 4 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public Nodes transform(Element subtree) {
                                    return XQueryUtil.xquery((Node)subtree, XQueryCommand.access$0(4.access$0(this.this$1)));
                                }
                            };
                            if (input == null && baseURI == null) {
                                throw new IllegalArgumentException("input and baseURI must not both be null");
                            }
                            if (input == null) {
                                input = baseURI.toURL().openStream();
                            }
                            try {
                                doc = new BinaryXMLCodec().deserialize(input, XQueryCommand.this.filter.createNodeFactory(null, myTransform));
                                if (baseURI != null) {
                                    doc.setBaseURI(baseURI.toASCIIString());
                                }
                            }
                            catch (Throwable throwable) {
                                Object var7_9 = null;
                                input.close();
                                throw throwable;
                            }
                            {
                                Object var7_10 = null;
                                input.close();
                                break block13;
                            }
                        }
                    }
                    doc = super.createDocument(input, baseURI);
                }
                if (XQueryCommand.this.xinclude) {
                    try {
                        XIncluder.resolveInPlace((Document)doc, (Builder)this.newBuilder());
                    }
                    catch (XIncludeException e) {
                        throw new ParsingException(e.getMessage(), (Throwable)e);
                    }
                }
                if (XQueryCommand.this.stripWhitespace) {
                    XOMUtil.Normalizer.STRIP.normalize((ParentNode)doc);
                }
                long end = System.currentTimeMillis();
                if (isBench || XQueryCommand.this.explain) {
                    System.out.println(baseURI + " parse [ms]=" + (end - start));
                }
                return doc;
            }

            protected Builder newBuilder() {
                if (XQueryCommand.this.validate.equals("wf")) {
                    return builderPool.getBuilder(false);
                }
                if (XQueryCommand.this.validate.equals("dtd")) {
                    EntityResolver resolver;
                    if (XQueryCommand.this.schema == null) {
                        return builderPool.getBuilder(true);
                    }
                    try {
                        resolver = new BuilderFactory().createResolver(new FileInputStream(XQueryCommand.this.schema));
                    }
                    catch (IOException e) {
                        throw new CmdLineProgram.UsageException(e);
                    }
                    return builderPool.getDTDBuilder(resolver);
                }
                if (XQueryCommand.this.validate.equals("schema")) {
                    HashMap<File, String> map = new HashMap<File, String>();
                    if (XQueryCommand.this.schema != null) {
                        map.put(XQueryCommand.this.schema, XQueryCommand.this.namespace);
                    }
                    return builderPool.getW3CBuilder(map);
                }
                if (XQueryCommand.this.validate.equals("relaxng")) {
                    if (XQueryCommand.this.schema == null) {
                        throw new CmdLineProgram.UsageException("Missing required argument --schema");
                    }
                    return builderPool.getMSVBuilder(XQueryCommand.this.schema.toURI());
                }
                if (XQueryCommand.this.validate.equals("html")) {
                    XMLReader parser;
                    try {
                        parser = (XMLReader)Class.forName("org.ccil.cowan.tagsoup.Parser").newInstance();
                    }
                    catch (Exception e) {
                        throw new CmdLineProgram.UsageException(e);
                    }
                    return new Builder(parser);
                }
                throw new CmdLineProgram.UsageException("Illegal validate option: " + XQueryCommand.this.validate);
            }

            static /* synthetic */ XQueryCommand access$0(4 var0) {
                return var0.XQueryCommand.this;
            }
        };
        return new DocumentPool(new DocumentMap(new PoolConfig().setCompressionLevel(this.docPoolCompression).setCapacity(this.docPoolCapacity)), docFactory);
    }

    protected String getMailAddress() {
        return "wolfgang.DOT.hoschek.AT.mac.DOT.com";
    }

    protected String getProgramName() {
        return "fire-xquery";
    }

    protected String getHomepage() {
        return "http://dsd.lbl.gov/nux";
    }

    protected String getVersion() {
        String version;
        String s = "[";
        if (Package.getPackage("nux.xom.xquery") != null && (version = Package.getPackage("nux.xom.xquery").getImplementationVersion()) != null) {
            s = String.valueOf(s) + "nux-" + version + ", ";
        }
        s = String.valueOf(s) + "saxon-" + Version.getProductVersion();
        if (Package.getPackage("nu.xom") != null && (version = Package.getPackage("nu.xom").getImplementationVersion()) != null) {
            s = String.valueOf(s) + ", xom-" + version;
        }
        s = String.valueOf(s) + "]";
        return s;
    }

    private static File parsePath(String path) {
        String string = path = path == null ? "" : path.trim();
        if (path.startsWith("file://")) {
            path = path.substring("file://".length());
        } else if (path.startsWith("file:")) {
            path = path.substring("file:".length());
        }
        if (path.length() == 0 || path.equals(".")) {
            path = System.getProperty("user.dir", ".");
        } else {
            path = path.replace('\\', File.separatorChar);
            if ((path = path.replace('/', File.separatorChar)).startsWith("~")) {
                String home = System.getProperty("user.home", "~");
                path = String.valueOf(home) + path.substring(1);
            }
        }
        return new File(path);
    }

    private static String toStatisticsString(Node node) {
        Statistics stats = new Statistics();
        XQueryCommand.toStatisticsString(node, stats);
        NumberFormat f = NumberFormat.getPercentInstance();
        f.setMaximumFractionDigits(2);
        double nodes = (double)stats.nodes * 1.0;
        double chars = (double)stats.chars * 1.0;
        return "[nodes=" + stats.nodes + ", elements=" + f.format((double)stats.elements / nodes) + ", attributes=" + f.format((double)stats.attributes / nodes) + ", texts=" + f.format((double)stats.texts / nodes) + ", comments=" + f.format((double)stats.comments / nodes) + ", pis=" + f.format((double)stats.pis / nodes) + ", docTypes=" + f.format((double)stats.docTypes / nodes) + ", chars=" + stats.chars + ", tagChars=" + f.format((double)stats.tagChars / chars) + ", whitespaceChars=" + f.format((double)stats.whitespaceChars / chars) + ", nonASCIIChars=" + f.format((double)stats.nonASCIIChars / chars) + "]";
    }

    private static void toStatisticsString(Node node, Statistics stats) {
        Statistics statistics = stats;
        statistics.nodes = statistics.nodes + 1;
        String value = "";
        if (node instanceof ParentNode) {
            ParentNode parent = (ParentNode)node;
            int i = 0;
            while (i < parent.getChildCount()) {
                XQueryCommand.toStatisticsString(parent.getChild(i), stats);
                ++i;
            }
            if (node instanceof Element) {
                Statistics statistics2 = stats;
                statistics2.elements = statistics2.elements + 1;
                Element elem = (Element)node;
                value = elem.getQualifiedName();
                Statistics statistics3 = stats;
                statistics3.tagChars = statistics3.tagChars + (long)value.length();
                int j = 0;
                while (j < elem.getAttributeCount()) {
                    XQueryCommand.toStatisticsString((Node)elem.getAttribute(j), stats);
                    ++j;
                }
            }
        } else {
            if (node instanceof Text) {
                Statistics statistics4 = stats;
                statistics4.texts = statistics4.texts + 1;
            } else if (node instanceof Attribute) {
                Statistics statistics5 = stats;
                statistics5.attributes = statistics5.attributes + 1;
                Statistics statistics6 = stats;
                statistics6.tagChars = statistics6.tagChars + (long)((Attribute)node).getQualifiedName().length();
            } else if (node instanceof Comment) {
                Statistics statistics7 = stats;
                statistics7.comments = statistics7.comments + 1;
            } else if (node instanceof ProcessingInstruction) {
                Statistics statistics8 = stats;
                statistics8.pis = statistics8.pis + 1;
            } else if (node instanceof DocType) {
                Statistics statistics9 = stats;
                statistics9.docTypes = statistics9.docTypes + 1;
            }
            value = node.toXML();
        }
        Statistics statistics10 = stats;
        statistics10.chars = statistics10.chars + (long)value.length();
        int i = 0;
        while (i < value.length()) {
            if (XQueryCommand.isWhitespace(value.charAt(i))) {
                Statistics statistics11 = stats;
                statistics11.whitespaceChars = statistics11.whitespaceChars + 1L;
            }
            if (value.charAt(i) > '\u007f' || value.charAt(i) < '\u0000') {
                Statistics statistics12 = stats;
                statistics12.nonASCIIChars = statistics12.nonASCIIChars + 1L;
            }
            ++i;
        }
    }

    private static boolean isWhitespace(char c) {
        switch (c) {
            case '\t': {
                return true;
            }
            case '\n': {
                return true;
            }
            case '\r': {
                return true;
            }
            case ' ': {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ String access$0(XQueryCommand xQueryCommand) {
        return xQueryCommand.filterQuery;
    }

    private static final class Statistics {
        private int nodes;
        private int elements;
        private int texts;
        private int comments;
        private int attributes;
        private int pis;
        private int docTypes;
        private long chars;
        private long tagChars;
        private long whitespaceChars;
        private long nonASCIIChars;

        private Statistics() {
        }
    }
}

