/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import org.infinispan.container.InternalEntryFactoryImpl;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.container.entries.versioned.VersionedImmortalCacheEntry;
import org.infinispan.container.entries.versioned.VersionedImmortalCacheValue;
import org.infinispan.container.entries.versioned.VersionedMortalCacheEntry;
import org.infinispan.container.entries.versioned.VersionedMortalCacheValue;
import org.infinispan.container.entries.versioned.VersionedTransientCacheEntry;
import org.infinispan.container.entries.versioned.VersionedTransientCacheValue;
import org.infinispan.container.entries.versioned.VersionedTransientMortalCacheEntry;
import org.infinispan.container.entries.versioned.VersionedTransientMortalCacheValue;
import org.infinispan.container.versioning.EntryVersion;

public class VersionedInternalEntryFactoryImpl
extends InternalEntryFactoryImpl {
    @Override
    public InternalCacheEntry create(Object key, Object value, EntryVersion version) {
        return new VersionedImmortalCacheEntry(key, value, version);
    }

    @Override
    public InternalCacheEntry create(Object key, Object value, EntryVersion version, long created, long lifespan, long lastUsed, long maxIdle) {
        if (lifespan < 0L && maxIdle < 0L) {
            return new VersionedImmortalCacheEntry(key, value, version);
        }
        if (lifespan > -1L && maxIdle < 0L) {
            return new VersionedMortalCacheEntry(key, value, version, lifespan, created);
        }
        if (lifespan < 0L && maxIdle > -1L) {
            return new VersionedTransientCacheEntry(key, value, version, maxIdle, lastUsed);
        }
        return new VersionedTransientMortalCacheEntry(key, value, version, maxIdle, lifespan, lastUsed, created);
    }

    @Override
    public InternalCacheValue createValue(CacheEntry cacheEntry) {
        long lifespan = cacheEntry.getLifespan();
        long maxIdle = cacheEntry.getMaxIdle();
        if (lifespan < 0L && maxIdle < 0L) {
            return new VersionedImmortalCacheValue(cacheEntry.getValue(), cacheEntry.getVersion());
        }
        if (lifespan > -1L && maxIdle < 0L) {
            return new VersionedMortalCacheValue(cacheEntry.getValue(), cacheEntry.getVersion(), -1L, lifespan);
        }
        if (lifespan < 0L && maxIdle > -1L) {
            return new VersionedTransientCacheValue(cacheEntry.getValue(), cacheEntry.getVersion(), maxIdle, -1L);
        }
        return new VersionedTransientMortalCacheValue(cacheEntry.getValue(), cacheEntry.getVersion(), -1L, lifespan, maxIdle, -1L);
    }

    @Override
    public InternalCacheEntry create(Object key, Object value, EntryVersion version, long lifespan, long maxIdle) {
        if (lifespan < 0L && maxIdle < 0L) {
            return new VersionedImmortalCacheEntry(key, value, version);
        }
        if (lifespan > -1L && maxIdle < 0L) {
            new VersionedMortalCacheEntry(key, value, version, lifespan);
        }
        if (lifespan < 0L && maxIdle > -1L) {
            new VersionedTransientCacheEntry(key, value, version, maxIdle);
        }
        return new VersionedTransientMortalCacheEntry(key, value, version, maxIdle, lifespan);
    }

    @Override
    public InternalCacheEntry update(InternalCacheEntry ice, long lifespan, long maxIdle) {
        EntryVersion version = ice.getVersion();
        if (ice instanceof ImmortalCacheEntry) {
            if (lifespan < 0L) {
                if (maxIdle < 0L) {
                    return ice;
                }
                return new VersionedTransientCacheEntry(ice.getKey(), ice.getValue(), version, maxIdle);
            }
            if (maxIdle < 0L) {
                return new VersionedMortalCacheEntry(ice.getKey(), ice.getValue(), version, lifespan);
            }
            long ctm = System.currentTimeMillis();
            return new VersionedTransientMortalCacheEntry(ice.getKey(), ice.getValue(), version, maxIdle, lifespan, ctm, ctm);
        }
        if (ice instanceof MortalCacheEntry) {
            if (lifespan < 0L) {
                if (maxIdle < 0L) {
                    return new VersionedImmortalCacheEntry(ice.getKey(), ice.getValue(), version);
                }
                return new VersionedTransientCacheEntry(ice.getKey(), ice.getValue(), version, maxIdle);
            }
            if (maxIdle < 0L) {
                ice.setLifespan(lifespan);
                return ice;
            }
            long ctm = System.currentTimeMillis();
            return new VersionedTransientMortalCacheEntry(ice.getKey(), ice.getValue(), version, maxIdle, lifespan, ctm, ctm);
        }
        if (ice instanceof TransientCacheEntry) {
            if (lifespan < 0L) {
                if (maxIdle < 0L) {
                    return new VersionedImmortalCacheEntry(ice.getKey(), ice.getVersion(), version);
                }
                ice.setMaxIdle(maxIdle);
                return ice;
            }
            if (maxIdle < 0L) {
                return new VersionedMortalCacheEntry(ice.getKey(), ice.getValue(), version, lifespan);
            }
            long ctm = System.currentTimeMillis();
            return new VersionedTransientMortalCacheEntry(ice.getKey(), ice.getValue(), version, maxIdle, lifespan, ctm, ctm);
        }
        if (ice instanceof TransientMortalCacheEntry) {
            if (lifespan < 0L) {
                if (maxIdle < 0L) {
                    return new VersionedImmortalCacheEntry(ice.getKey(), ice.getValue(), version);
                }
                return new VersionedTransientCacheEntry(ice.getKey(), ice.getValue(), version, maxIdle);
            }
            if (maxIdle < 0L) {
                return new VersionedMortalCacheEntry(ice.getKey(), ice.getValue(), version, lifespan);
            }
            ice.setLifespan(lifespan);
            ice.setMaxIdle(maxIdle);
            return ice;
        }
        return ice;
    }
}

