/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.io;

import java.io.IOException;
import java.io.InputStream;
import org.infinispan.Cache;
import org.infinispan.io.FileChunkMapper;
import org.infinispan.io.GridFile;

public class GridInputStream
extends InputStream {
    private int index = 0;
    private int localIndex = 0;
    private byte[] currentBuffer = null;
    private boolean endReached = false;
    private FileChunkMapper fileChunkMapper;

    GridInputStream(GridFile file, Cache<String, byte[]> cache) {
        this.fileChunkMapper = new FileChunkMapper(file, cache);
    }

    @Override
    public int read() throws IOException {
        int remaining = this.getBytesRemainingInChunk();
        if (remaining == 0) {
            if (this.endReached) {
                return -1;
            }
            this.fetchNextChunk();
            if (this.currentBuffer == null) {
                return -1;
            }
            if (this.isLastChunk()) {
                this.endReached = true;
            }
        }
        byte retval = this.currentBuffer[this.localIndex++];
        ++this.index;
        return retval;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int totalBytesRead = 0;
        while (len > 0) {
            int bytesRead = this.readFromChunk(b, off, len);
            if (bytesRead == -1) {
                return totalBytesRead > 0 ? totalBytesRead : -1;
            }
            off += bytesRead;
            len -= bytesRead;
            totalBytesRead += bytesRead;
        }
        return totalBytesRead;
    }

    private int readFromChunk(byte[] b, int off, int len) {
        int remaining = this.getBytesRemainingInChunk();
        if (remaining == 0) {
            if (this.endReached) {
                return -1;
            }
            this.fetchNextChunk();
            if (this.currentBuffer == null) {
                return -1;
            }
            if (this.isLastChunk()) {
                this.endReached = true;
            }
            remaining = this.getBytesRemainingInChunk();
        }
        int bytesToRead = Math.min(len, remaining);
        System.arraycopy(this.currentBuffer, this.localIndex, b, off, bytesToRead);
        this.localIndex += bytesToRead;
        this.index += bytesToRead;
        return bytesToRead;
    }

    private boolean isLastChunk() {
        return this.currentBuffer.length < this.getChunkSize();
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int available() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.index = 0;
        this.localIndex = 0;
        this.endReached = false;
    }

    private int getBytesRemainingInChunk() {
        return this.currentBuffer == null ? 0 : this.currentBuffer.length - this.localIndex;
    }

    private void fetchNextChunk() {
        this.currentBuffer = this.fileChunkMapper.fetchChunk(this.getChunkNumber());
        this.localIndex = 0;
    }

    private int getChunkNumber() {
        return this.index / this.getChunkSize();
    }

    private int getChunkSize() {
        return this.fileChunkMapper.getChunkSize();
    }
}

