/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.BaseStateTransferTask;
import org.infinispan.statetransfer.DistributedStateTransferManagerImpl;
import org.infinispan.statetransfer.LockInfo;
import org.infinispan.statetransfer.StateTransferCancelledException;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.util.Immutables;
import org.infinispan.util.ReadOnlyDataContainerBackedKeySet;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DistributedStateTransferTask
extends BaseStateTransferTask {
    private static final Log log = LogFactory.getLog(DistributedStateTransferTask.class);
    private final DistributionManager dm;
    private final DistributedStateTransferManagerImpl stateTransferManager;
    private List<Object> keysToRemove;
    private Collection<Address> oldCacheSet;
    private Collection<Address> newCacheSet;
    private TransactionTable transactionTable;

    public DistributedStateTransferTask(RpcManager rpcManager, Configuration configuration, DataContainer dataContainer, DistributedStateTransferManagerImpl stateTransferManager, DistributionManager dm, StateTransferLock stateTransferLock, CacheNotifier cacheNotifier, int newViewId, Collection<Address> members, ConsistentHash chOld, ConsistentHash chNew, boolean initialView, TransactionTable transactionTable) {
        super(stateTransferManager, rpcManager, stateTransferLock, cacheNotifier, configuration, dataContainer, members, newViewId, chNew, chOld, initialView);
        this.dm = dm;
        this.stateTransferManager = stateTransferManager;
        this.oldCacheSet = chOld != null ? Immutables.immutableCollectionWrap(chOld.getCaches()) : Collections.emptySet();
        this.newCacheSet = Immutables.immutableCollectionWrap(chNew.getCaches());
        this.transactionTable = transactionTable;
    }

    @Override
    public void doPerformStateTransfer() throws Exception {
        if (!this.stateTransferManager.startStateTransfer(this.newViewId, this.members, this.initialView)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debugf("Commencing rehash %d on node: %s. Before start, data container had %d entries", this.newViewId, this.self, this.dataContainer.size());
        }
        this.newCacheSet = Collections.emptySet();
        this.oldCacheSet = Collections.emptySet();
        this.keysToRemove = new ArrayList<Object>();
        this.stateTransferLock.blockNewTransactions(this.newViewId);
        if (this.trace) {
            log.tracef("Rebalancing: chOld = %s, chNew = %s", this.chOld, this.chNew);
        }
        if (this.configuration.isRehashEnabled() && !this.initialView) {
            this.cacheNotifier.notifyDataRehashed(this.oldCacheSet, this.newCacheSet, this.newViewId, true);
            int numOwners = this.configuration.getNumOwners();
            HashMap<Address, Collection<InternalCacheEntry>> states = new HashMap<Address, Collection<InternalCacheEntry>>();
            for (InternalCacheEntry ice : this.dataContainer) {
                this.rebalance(ice.getKey(), ice, numOwners, this.chOld, this.chNew, null, states, this.keysToRemove);
            }
            this.checkIfCancelled();
            CacheStore cacheStore = this.stateTransferManager.getCacheStoreForStateTransfer();
            if (cacheStore != null) {
                for (Object object : cacheStore.loadAllKeys(new ReadOnlyDataContainerBackedKeySet(this.dataContainer))) {
                    this.rebalance(object, null, numOwners, this.chOld, this.chNew, cacheStore, states, this.keysToRemove);
                }
            } else if (this.trace) {
                log.trace("No cache store or cache store is shared, not rebalancing stored keys");
            }
            this.checkIfCancelled();
            for (Map.Entry entry : states.entrySet()) {
                this.pushPartialState(Collections.singleton(entry.getKey()), (Collection)entry.getValue(), null);
            }
            if (this.transactionTable != null) {
                log.debug("Starting lock migration");
                HashMap<Address, Collection<LockInfo>> locksToMigrate = new HashMap<Address, Collection<LockInfo>>();
                this.rebalanceLocks(numOwners, locksToMigrate, this.transactionTable.getRemoteTransactions());
                this.rebalanceLocks(numOwners, locksToMigrate, this.transactionTable.getLocalTransactions());
                for (Map.Entry e : locksToMigrate.entrySet()) {
                    this.pushPartialState(Collections.singleton(e.getKey()), null, (Collection)e.getValue());
                }
            }
            this.finishPushingState();
        } else if (!this.initialView) {
            log.trace("Rehash not enabled, so not pushing state");
        }
    }

    private void rebalanceLocks(int numOwners, Map<Address, Collection<LockInfo>> locksToMigrate, Collection<? extends CacheTransaction> tx) throws StateTransferCancelledException {
        for (CacheTransaction cacheTransaction : tx) {
            Iterator<Object> i$ = cacheTransaction.getLockedKeys().iterator();
            while (i$.hasNext()) {
                Address oldLockOwner = this.self;
                Object key = i$.next();
                Address newLockOwner = this.chNew.locate(key, numOwners).get(0);
                if (oldLockOwner.equals(newLockOwner)) continue;
                log.tracef("Migrating lock %s from node %s to ", key, oldLockOwner, newLockOwner);
                Collection<LockInfo> lockInfo = locksToMigrate.get(newLockOwner);
                if (lockInfo == null) {
                    lockInfo = new ArrayList<LockInfo>();
                    locksToMigrate.put(newLockOwner, lockInfo);
                }
                lockInfo.add(new LockInfo(cacheTransaction.getGlobalTransaction(), key));
                if (lockInfo.size() <= this.stateTransferChunkSize) continue;
                this.pushPartialState(Collections.singleton(newLockOwner), null, lockInfo);
                locksToMigrate.remove(newLockOwner);
            }
        }
    }

    @Override
    public void commitStateTransfer() {
        this.dm.setConsistentHash(this.chNew);
        if (this.configuration.isRehashEnabled() && !this.initialView) {
            this.stateTransferManager.invalidateKeys(this.keysToRemove);
            this.cacheNotifier.notifyDataRehashed(this.oldCacheSet, this.newCacheSet, this.newViewId, false);
        }
        super.commitStateTransfer();
    }

    private void rebalance(Object key, InternalCacheEntry value, int numOwners, ConsistentHash chOld, ConsistentHash chNew, CacheStore cacheStore, Map<Address, Collection<InternalCacheEntry>> states, List<Object> keysToRemove) throws StateTransferCancelledException {
        List<Address> newOwners;
        List<Address> oldOwners = chOld.locate(key, numOwners);
        if (((Object)oldOwners).equals(newOwners = chNew.locate(key, numOwners))) {
            return;
        }
        Address pushingOwner = null;
        for (int i = oldOwners.size() - 1; i >= 0; --i) {
            Address server = oldOwners.get(i);
            if (!chNew.getCaches().contains(server)) continue;
            pushingOwner = server;
            break;
        }
        if (this.trace) {
            log.tracef("Rebalancing key %s from %s to %s, pushing owner is %s", new Object[]{key, oldOwners, newOwners, pushingOwner});
        }
        if (this.self.equals(pushingOwner)) {
            if (value == null) {
                try {
                    value = cacheStore.load(key);
                }
                catch (CacheLoaderException e) {
                    log.failedLoadingValueFromCacheStore(key);
                }
            }
            for (Address server : newOwners) {
                if (oldOwners.contains(server)) continue;
                Collection<InternalCacheEntry> stateForANode = states.get(server);
                if (stateForANode == null) {
                    stateForANode = new ArrayList<InternalCacheEntry>();
                    states.put(server, stateForANode);
                }
                if (value != null) {
                    stateForANode.add(value);
                }
                if (stateForANode.size() < this.stateTransferChunkSize) continue;
                this.pushPartialState(Collections.singleton(server), stateForANode, null);
                states.remove(server);
            }
        }
        if (!newOwners.contains(this.self)) {
            keysToRemove.add(key);
        }
    }
}

